#include "http_server_metrics.h"

namespace NMonitoring {
    THttpCallMetrics* NMonitoring::THttpServerMetrics::Metrics(TStringBuf endpoint) {
        if (endpoint.ends_with('/')) {
            endpoint.remove_suffix(1);
        }

        {
            TLightReadGuard g{Lock};
            auto it = MetricsByEndpoint.find(endpoint);
            if (it != MetricsByEndpoint.end()) {
                return it->second.get();
            }
        }
        {
            TLightWriteGuard g{Lock};
            NMonitoring::TLabels labels = {{"endpoint", endpoint}};

            const auto it = MetricsByEndpoint.find(endpoint);
            if (it != MetricsByEndpoint.end()) {
                return it->second.get();
            }

            auto [insert, success] = MetricsByEndpoint.emplace(endpoint, std::make_unique<THttpCallMetrics>(Registry, std::move(labels), "http.server"));
            return insert->second.get();
        }
    }
} // namespace NMonitoring
