#pragma once

#include "http_metrics.h"

namespace NMonitoring {
    struct THttpServerMetrics {
        THttpServerMetrics(NMonitoring::IMetricRegistry& registry)
            : Registry{registry}
        {
        }

        THttpCallMetrics* Metrics(TStringBuf endpoint);

    private:
        NMonitoring::IMetricRegistry& Registry;
        TLightRWLock Lock;
        THashMap<TString, std::unique_ptr<THttpCallMetrics>> MetricsByEndpoint;
    };

} // namespace NMonitoring
