#include "logging.h"

#include <library/cpp/json/writer/json.h>

#include <util/datetime/base.h>
#include <util/string/builder.h>

namespace NMonitoring {
    TStringBuf LogPriorityStr(ELogPriority priority) {
        switch (priority) {
            case TLOG_EMERG:
                return TStringBuf("EMERG");
            case TLOG_ALERT:
                return TStringBuf("ALERT");
            case TLOG_CRIT:
                return TStringBuf("CRIT");
            case TLOG_ERR:
                return TStringBuf("ERROR");
            case TLOG_WARNING:
                return TStringBuf("WARN");
            case TLOG_NOTICE:
                return TStringBuf("NOTICE");
            case TLOG_INFO:
                return TStringBuf("INFO");
            case TLOG_DEBUG:
                return TStringBuf("DEBUG");
            case TLOG_RESOURCES:
                return TStringBuf("RESOURCES");
            default:
                return TStringBuf("UNKNOWN");
        }
    }

    TString SimpleLogFormatter(ELogPriority, TStringBuf data) {
        TStringBuilder result;
        result << TInstant::Now().ToStringLocalUpToSeconds() << " ";
        return result << data << Endl;
    }

    TString DeployJsonLogFormatter(ELogPriority priority, TStringBuf data) {
        NJsonWriter::TBuf buf;
        buf.BeginObject();
        buf.WriteKey("@timestamp")
            .WriteString(TInstant::Now().FormatLocalTime("%Y-%m-%dT%H:%M:%S%Ez")); // RFC3339
        buf.WriteKey("message").WriteString(data);
        buf.WriteKey("levelStr").WriteString(LogPriorityStr(priority));
        buf.EndObject();
        return buf.Str() + "\n";
    }

    TLog& GetSimpleStderrLogger() {
        static TLog LOGGER{"cerr", TLOG_INFO};
        LOGGER.SetFormatter(SimpleLogFormatter);
        return LOGGER;
    }
} // namespace NMonitoring
