#pragma once

#include <library/cpp/logger/global/global.h>
#include <library/cpp/logger/log.h>

#include <util/generic/string.h>

namespace NMonitoring {
    TStringBuf LogPriorityStr(ELogPriority priority);

    TString SimpleLogFormatter(ELogPriority, TStringBuf data);

    // https://deploy.yandex-team.ru/docs/concepts/pod/sidecars/logs/logs#format
    TString DeployJsonLogFormatter(ELogPriority priority, TStringBuf data);

    TLog& GetSimpleStderrLogger();

    class TRequestLog {
    public:
        TRequestLog(TLog& logger, const TString& requestId = "")
            : Logger(logger)
            , RequestId(requestId) {
        }

        inline TLogElement operator<<(ELogPriority priority) {
            TLogElement element(Logger << priority);
            if (RequestId) {
                element << "[" << RequestId << "] ";
            }
            return element;
        }

        void SetRequestId(TString requestId) {
            RequestId = std::move(requestId);
        }

        TLog& GetLogger() const {
            return Logger;
        }

    private:
        TLog& Logger;
        TString RequestId;
    };
} // namespace NMonitoring
