#include "metrics.h"

namespace NMonitoring {
    NUnistat::TIntervals TStatsInitializer::GetLinearWeights(double minValue, double maxValue, double step) {
        NUnistat::TIntervals values;
        for (double value = minValue; value <= maxValue; value += step) {
            values.push_back(value);
        }
        return values;
    }

    NUnistat::TIntervals TStatsInitializer::GetLogWeights(double logBase, int minLog, int maxLog){
        NUnistat::TIntervals values;
        values.push_back(0.0);
        for (const auto log: xrange(minLog, maxLog+1)) {
            values.push_back(std::pow(logBase, log));
        }
        return values;
    }
} // namespace NMonitoring
