#pragma once

#include <library/cpp/unistat/unistat.h>

#include <util/generic/xrange.h>

#include <cmath>

namespace NMonitoring {
    class TStatsInitializer {
    public:
        virtual void Init(TUnistat&) const {
        }
        virtual ~TStatsInitializer() = default;

        void DrillAbsoluteHole(TUnistat& creator, const TString& name) const {
            // NOTE(rocco66): it is dangerous method for per DC aggregation
            // it will crash if instances are in different golovan groups
            creator.DrillFloatHole(name, "amxx", DefaultPriority, NUnistat::TStartValue(0), EAggregationType::LastValue);
        }

        void DrillAmmxHole(TUnistat& creator, const TString& name) const {
            creator.DrillFloatHole(name, "ammx", DefaultPriority, NUnistat::TStartValue(0), EAggregationType::LastValue);
        }

        void DrillSummHole(TUnistat& creator, const TString& name) const {
            creator.DrillFloatHole(name, "summ", DefaultPriority);
        }

        void DrillAnnnHole(TUnistat& creator, const TString& name) const {
            creator.DrillFloatHole(name, "annn", DefaultPriority, NUnistat::TStartValue(0), EAggregationType::LastValue);
        }

        void DrillHistogramHole(TUnistat& creator, const TString& name, const TString& suffix = "hgram") const {
            static auto intervals = GetLogWeights(1.5, -50, 50);
            DrillHistogramHole(creator, name, intervals, suffix);
        }

        void DrillHistogramHole(TUnistat& creator, const TString& name, const NUnistat::TIntervals& intervals, const TString& suffix = "hgram") const {
            creator.DrillHistogramHole(name, suffix, DefaultPriority, intervals);
        }

        void DrillAhhhHole(TUnistat& creator, const TString& name) const {
            creator.DrillFloatHole(name, "ahhh", DefaultPriority, NUnistat::TStartValue(0), EAggregationType::LastValue);
        }

        static NUnistat::TIntervals GetLinearWeights(double minValue, double maxValue, double step);
        static NUnistat::TIntervals GetLogWeights(double logBase = 1.5, int minLog = -50, int maxLog = 50);

    protected:
        NUnistat::TPriority DefaultPriority = NUnistat::TPriority(10);
    };
} // namespace NMonitoring
