#include "metrics_replier.h"

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/encode/spack/spack_v1.h>
#include <library/cpp/monlib/encode/text/text.h>

using namespace NMonitoring;

EFormat FormatFromHeaders(const THttpHeaders& headers) {
    const auto* header = headers.FindHeader("Accept");
    if (!header) {
        return EFormat::TEXT;
    }
    return FormatFromAcceptHeader(header->Value());
}

ECompression CompressionFromHeaders(const THttpHeaders& headers) {
    const auto* header = headers.FindHeader("Accept-Encoding");
    if (!header) {
        return ECompression::IDENTITY;
    }
    return CompressionFromAcceptEncodingHeader(header->Value());
}

void TMetricsHandler::DoReply(const TServiceRequest::TRef request, const TParsedHttpFull&) {
    auto& headers = request->GetInput().Headers();
    EFormat format = FormatFromHeaders(headers);

    IMetricEncoderPtr encoder;
    TString content;
    TStringOutput out(content);
    if (format == EFormat::TEXT) {
        encoder = EncoderText(&out);
    } else {
        format = EFormat::SPACK;
        encoder = EncoderSpackV1(&out, ETimePrecision::SECONDS, CompressionFromHeaders(headers));
    }

    RegistryPtr_->Accept(TInstant::Zero(), encoder.Get());
    encoder->Close();

    request->Finish(THttpResponse(HttpCodes::HTTP_OK)
        .SetContent(content, ContentTypeByFormat(format)));
}
