#pragma once

#include <library/cpp/msgpack/strbuf_adaptor.h>
#include <library/cpp/msgpack/string_adaptor.h>
#include <library/cpp/string_utils/base64/base64.h>
#include <contrib/libs/msgpack/include/msgpack.hpp>

#include <util/generic/yexception.h>

namespace NMonitoring {
    template <class TContainer, class TValue>
    class TMsgpackIterator {
    public:
        TMsgpackIterator(const TContainer& object)
            : Object(object) {
        }

        inline TValue* begin() const {
            return Object.ptr;
        }

        inline TValue* end() const {
            return Object.ptr + Object.size;
        }

    private:
        TContainer Object;
    };

    using TMapIterator = TMsgpackIterator<msgpack::object_map, msgpack::object_kv>;
    using TArrayIterator = TMsgpackIterator<msgpack::object_array, msgpack::object>;

    inline void EnsureIs(const msgpack::object& obj, msgpack::type::object_type expected) {
        if (Y_UNLIKELY(obj.type != expected)) {
            ythrow yexception() << "wrong type of object given";
        }
    }

    template <class T>
    inline void PackString(msgpack::packer<T>& packer, TStringBuf string) {
        packer.pack_str(string.size());
        packer.pack_str_body(string.data(), string.size());
    }
} // namespace NMonitoring
