#include "settings.h"

namespace NMonitoring {
    void TSettings::FromJson(IInputStream& input) {
        NConfig::TGlobals globals;
        NConfig::TConfig config = NConfig::TConfig::FromJson(input, globals);
        FillFromFileConfig(config);
    }

    void TSettings::FillFromFileConfig(const NConfig::TConfig& config) {
        if (config.Has("http-threads")) {
            SetHttpThreadPoolSize(config["http-threads"].As<ui16>());
        }
        if (config.Has("client-timeout-ms")) {
            SetClientTimeout(TDuration::MilliSeconds(config["client-timeout-ms"].As<ui32>()));
        }
        if (config.Has("http-max-queue-size")) {
            SetMaxQueueSize(config["http-max-queue-size"].As<ui32>());
        }
        if (config.Has("http-max-connections")) {
            SetMaxConnections(config["http-max-connections"].As<ui32>());
        }
        if (config.Has("http-listen-backlog")) {
            SetListenBacklog(config["http-listen-backlog"].As<int>());
        }
    }
}
