#pragma once

#include <library/cpp/config/config.h>

#include <util/stream/input.h>
#include <util/system/types.h>
#include <util/datetime/base.h>

namespace NMonitoring {
    class TSettings {
    public:
        ui16 GetHttpPort() const {
            return HttpPort;
        }

        void SetHttpPort(ui16 port) {
            HttpPort = port;
        }

        ui16 GetHttpThreadPoolSize() const {
            return HttpThreadPoolSize;
        }

        void SetHttpThreadPoolSize(ui16 value) {
            HttpThreadPoolSize = value;
        }

        void SetEnableCompression(bool value) {
            EnableCompression = value;
        }

        bool GetEnableCompression() const {
            return EnableCompression;
        }

        void SetClientTimeout(TDuration timeout) {
            ClientTimeout = timeout;
        }

        TDuration GetClientTimeout() const {
            return ClientTimeout;
        }

        void SetMaxQueueSize(ui32 value) {
            MaxQueueSize = value;
        }

        ui32 GetMaxQueueSize() const {
            return MaxQueueSize;
        }

        void SetMaxConnections(ui32 value) {
            MaxConnections = value;
        }

        ui32 GetMaxConnections() const {
            return MaxConnections;
        }

        void SetListenBacklog(int value) {
            ListenBacklog = value;
        }

        int GetListenBacklog() const {
            return ListenBacklog;
        }

        void FromJson(IInputStream& input);

    protected:
        virtual void FillFromFileConfig(const NConfig::TConfig& config);

    private:
        ui16 HttpPort = 10801; // random meaningless number
        ui16 HttpThreadPoolSize = 8;
        bool EnableCompression = false;
        TDuration ClientTimeout = TDuration::Minutes(1);
        ui32 MaxQueueSize = 1024;
        ui32 MaxConnections = 1024;
        int ListenBacklog = 128;
    };
}
