#pragma once

#include "application.h"

#include <library/cpp/logger/global/global.h>

#include <util/generic/algorithm.h>
#include <util/generic/vector.h>

inline TLog& GetLogger() {
    auto& log = TLoggerOperator<TGlobalLog>::Log();
    log.SetFormatter(NMonitoring::SimpleLogFormatter);
    return log;
}

template<class T>
inline bool OneOf(const T& value, const TVector<T>& items) {
    return Find(items, value) != items.cend();
}
