#pragma once

#include "web_server.h"

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_value.h>
#include <library/cpp/json/json_writer.h>
#include <library/cpp/unistat/unistat.h>

namespace NMonitoring {
    inline static void WriteJson(THttpOutput& output, const TString& value, bool finish = true) {
        output << THttpResponse()
                      .SetContentType(TStringBuf("application/json"))
                      .SetContent(value);
        if (finish) {
            output.Finish();
        }
    }

    inline static void WriteJson(THttpOutput& output, const NJson::TJsonValue& value, bool finish = true) {
        WriteJson(output, NJson::WriteJson(value), finish);
    }

    inline static NJson::TJsonValue ParseJson(THttpInput& input) {
        NJson::TJsonValue result;
        NJson::ReadJsonTree(&input, &result, true);
        return result;
    }

    class TStatsHandler : public IServiceReplier {
        virtual void DoReply(const TServiceRequest::TRef request, const TParsedHttpFull&) override {
            request->Finish(THttpResponse()
                .SetContentType(TStringBuf("application/json"))
                .SetContent(TUnistat::Instance().CreateJsonDump(0, false)));
        }
    };

    class TEmptyHandler : public IServiceReplier {
        virtual void DoReply(const TServiceRequest::TRef request, const TParsedHttpFull&) override {
            request->Finish(THttpResponse(HttpCodes::HTTP_OK).SetContentType("text/plain"));
        }
    };

    class TOkHandler : public IServiceReplier {
        virtual void DoReply(const TServiceRequest::TRef request, const TParsedHttpFull&) override {
            request->Finish(THttpResponse(HttpCodes::HTTP_OK).SetContent("OK").SetContentType("text/plain"));
        }
    };

} // namespace NMonitoring
