package metrics

import (
	"strings"
	"sync"
	"time"
)

var (
	requestCountMetrics = NewCounterMap("requests.%s.%d")
	requestTimeMetrics  = NewMetricsMap("requests.%s.response_time", func(key string) Metric {
		// from 4ms to 32s
		return NewHistogram(key, DeltaHT, MakeLogWeights(1.2, -30))
	})
	metricsLock = sync.Mutex{}
)

func WriteRequestStats(path string, code int, duration time.Duration) {
	safePath := strings.Trim(path, "/")
	requestCountMetrics.GetFor(safePath, code).Update(1)
	requestTimeMetrics.GetFor(safePath).Update(duration.Seconds())
}
