package metrics

import "time"

type Stopwatch struct {
	start time.Time
}

func NewStopwatch() Stopwatch {
	return Stopwatch{time.Now()}
}

func (sw *Stopwatch) Get() time.Duration {
	return time.Since(sw.start)
}

func (sw *Stopwatch) Reset() time.Duration {
	v := time.Since(sw.start)
	sw.start = time.Now()
	return v
}
