package metrics

import (
	"errors"
)

type unitedRegistry struct {
	registries []Registry
}

func NewUnitedRegistry(registries []Registry) Registry {
	return &unitedRegistry{registries: registries}
}

func (r *unitedRegistry) RegisterNumeric(numeric *Numeric) {
	for _, subReg := range r.registries {
		subReg.RegisterNumeric(numeric)
	}
}

func (r *unitedRegistry) RegisterCounter(counter *Counter) {
	for _, subReg := range r.registries {
		subReg.RegisterCounter(counter)
	}
}

func (r *unitedRegistry) RegisterHistogram(histogram *Histogram) {
	for _, subReg := range r.registries {
		subReg.RegisterHistogram(histogram)
	}
}

func (r *unitedRegistry) WithTags(tags map[string]string) Registry {
	var registries []Registry
	for _, subReg := range r.registries {
		registries = append(registries, subReg.WithTags(tags))
	}
	return NewUnitedRegistry(registries)
}

func (r *unitedRegistry) WithPrefix(prefix string) Registry {
	var registries []Registry
	for _, subReg := range r.registries {
		registries = append(registries, subReg.WithPrefix(prefix))
	}
	return NewUnitedRegistry(registries)
}

func (r *unitedRegistry) Handlers() []RegistryHandler {
	var retval []RegistryHandler
	for _, subReg := range r.registries {
		retval = append(retval, subReg.Handlers()...)
	}
	return retval
}

func (r *unitedRegistry) Serialize() ([]byte, error) {
	return nil, errors.New("not supported")
}
