#!/bin/sh
set -e
set -x

if ( which protoc3 >/dev/null ); then
    protoc=$(which protoc3)
else
    protoc=$(which protoc)
fi

CLIENT_ROOT_DIR=./
cd ${CLIENT_ROOT_DIR}

PROTOBUF_DIR=../instancectl/src/protobuf
THIRDPARTY_DIR=../instancectl/src/protobuf/third_party
OUTPUT_DIR=src/
rm -rf ${OUTPUT_DIR}
mkdir -p ${OUTPUT_DIR}

# Compile client stub
"${protoc}" -I ${THIRDPARTY_DIR} -I ${PROTOBUF_DIR} \
       --plugin=protoc-gen-httprpc=../instancectl/scripts/protoc-gen-http-rpc.py \
       --httprpc_out=${OUTPUT_DIR}/ \
       --python_out=${OUTPUT_DIR}/ \
       ${PROTOBUF_DIR}/clusterpb/*.proto

make_init() {
    local root=$1
    if [ ! -d ${root} ]; then
        return
    fi
    touch ${root}/__init__.py
    for i in $(ls ${root}); do
        make_init ${root}/${i}
    done
}

make_init ${OUTPUT_DIR}/clusterpb

# FIXME: requires python interpreter with protobuf3 installed
ret=0
PYDONTWRITEBYTECODE=1 python /dev/stdin  <<EOF || ret=$?
import os
import sys
import importlib
sys.path.insert(0, 'src')
import clusterpb
files = os.listdir('src/clusterpb/')
for file_ in files:
    file_full_path = os.path.join('src/clusterpb/', file_)
    if not os.path.isfile(file_full_path):
        continue
    if not file_.endswith('.py'):
        continue
    importlib.import_module('clusterpb.' + file_.replace('.py', ''))

EOF

if [ ${ret} -ne 0 ]; then
    echo "Import test failed" >&2
    exit 1
fi

