# FAQ

Последнее время много команд начали переезжать в YP и стали часто возникать вопросы как устроена миграция контейнеров в YP. Ниже мы постарались ответить на все вопросы про это.

[Все про миграции в YP](https://rtc.yandex-team.ru/docs/service-requirements#migraciya-podov)

## Как запускать приложения в instancectl.conf/loop.conf {#run}

[Документация тут](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/)

## Как попасть в контейнер? {#shell-into-container}

В контейнер можно попасть несколькими способами:

1. Через `sky portoshell`. Работает с любой машины, где есть одновременно:
    * `skynet`;
    * Дырки до порта `10045` **железного хоста**, на котором живёт инстанс (например до `SEARCHPRODNETS`);
    * В `ssh-agent` проброшены ключ пользователя, который есть на staff.
1. Через `ssh -p 10046 ...`. Работает с любой машины, где есть одновременно:
    * Дырки до порта `10046` **железного хоста**, на котором живёт инстанс (например до `SEARCHPRODNETS`);
    * В `ssh-agent` проброшены ключ пользователя, который есть на staff.
1. Через `ssh`. Работает для сервисов, изолированных по сети (т.е. с включенным MTN). Работает с любой машины, где есть одновременно:
    * Дырки до 22 порта контейнера (доступ до сетевого макроса указанного при аллокации подов подойдёт);
    * В `ssh-agent` проброшены ключ пользователя, который есть на staff.
1. С железной машины.

Ниже описаны способы (1-3):

1. Открыть список инстансов в UI:

    ![img](https://jing.yandex-team.ru/files/sshipkov/2017-12-26_16-26-39.ef9bae1.png)

1. Скопировать команду для входа в контейнер:

    ![img](https://jing.yandex-team.ru/files/sshipkov/2018-02-09_17-27-24.55ca202.png)

### Возможные проблемы {#shell-into-container-troubleshooting}

При невозможности зайти в контейнер, нужно сделать следующее:

1. Посмотреть, как выглядит сообщение об ошибке. Если оно имеет вид `Auth failure: Authentication as login failed`, то это проблема аутентификации, а не авторизации, это значит, в ssh-agent не проброшены никакие ключи пользователя со стаффа. Для решения этой проблемы нужно выполнить следующий пункт.
1. Проверить, что в ssh-agent проброшен хотя бы один ключ со стаффа. Для этого на машине, с которой пользователь пытается зайти в контейнер, этот же пользователь должен позвать `ssh-add -L`. В выводе должен присутствовать ключ, лежащий на [staff](http://staff.yandex-team.ru/) данного пользователя. [Подробнее](https://wiki.yandex-team.ru/diy/common-ssh/#chtotakoessh-agentiagentforwarding). [Как исправить](https://wiki.yandex-team.ru/diy/common-ssh/#instrukciiponastrojjkessh-klientov).
1. Проверить через [puncher](https://puncher.yandex-team.ru/), что с машины, с которой пользователь пытается зайти в контейнер, есть дырка до требуемого сетевого макроса:
    * В случае (1-2) до железной машины;
    * В случае (3) до сетевого макроса инстансов.

## Как выключить хостовый skynet ssh в сетевом namespace контейнера {#ssh-instance-net}

Нужно выставить соответствующую опцию в `disabled`:
![img](https://jing.yandex-team.ru/files/sshipkov/2018-02-09_17-33-06.a5abb2b.png)

## Как пробросить устройство в контейнер {#host-devices}

На данный момент доступны устройства:

1. `/dev/kvm`;
1. `/dev/net/tun`, доступ к которому выдаётся по аппруву команды Nanny.

Для проброса устройства в контейнер, необходимо:

1. При деплое на YP выставить соответствующий флажок при аллокации:
    ![img](https://jing.yandex-team.ru/files/sshipkov/2018-05-30_18-29-46.ec5668e.png)
1. Создать пустой контейнер или использовать существующий (если в сервисе используется `loop.conf`, контейнер должен называться, как существующая секция `loop.conf`, [подробнее об использовании контейнеров](how-to/structured-instancectl-config.md)) и выставить нужные галки в `Host devices`.

![hostdevices.png](https://jing.yandex-team.ru/files/sshipkov/host_devices.8d47cdf.png)

## Как запустить процесс из-под другого пользователя? {#run-as-user}

Функционал доступен только при полной изоляции сервиса.
При использовании Instance Spec достаточно указать **UID** в секции Security Context запускаемого контейнера. Username будет резолвится неправильно: https://st.yandex-team.ru/RTCSUPPORT-15794.
При использовании instancectl.conf нужно добавить в Instance Spec контейнер с именем соответствующей секции из instancectl.conf, в котором также задать пользователя в Security Context.
![img](https://jing.yandex-team.ru/files/sshipkov/2018-05-17_13-44-02.bcf69ca.png)

## Как запустить подконтейнер/секцию инстанса с лимитами по ресурсам {#subcontainer-limits}

Возможность доступна только при использовании Instance Spec и **не доступна с loop.conf/instancectl.conf**.
![img](https://jing.yandex-team.ru/files/sshipkov/2018-06-21_13-50-31.760eb43.png)

## Как включить NAT64 в контейнере {#nat64}

Из контейнеров можно ходить во внешние IPv4-only сервисы через NAT64. Для этого необходимо:

1. Включить опцию `NAT64_LOCAL` в настройках сервиса (описано ниже)
1. Запросить доступ до Интернет в [https://puncher.yandex-team.ru/,](https://puncher.yandex-team.ru/,) в качестве приёмника нужно указать слово `Интернет`.
После включения этой опции в новой ревизии инстансов в `/etc/resolv.conf` первым будет записан адрес локального резолвера, кеширующего данные из NAT64-nameserver. [Подробнее о NAT64.](https://wiki.yandex-team.ru/iaas/nat64/)

{% note warning %}

Старый способ настройки `NAT64` (без `LOCAL`) признан deprecated, см. детали в [https://st.yandex-team.ru/SPPROBLEM-202](https://st.yandex-team.ru/SPPROBLEM-202)

![img](https://jing.yandex-team.ru/files/sshipkov/nat64-local.f678828.png)

{% endnote %}

## Как использовать секреты в контейнере {#secrets}

См. [гайд по доставке секретов ](how-to/secrets.md)

## Как включить read-only монтирование файлов в контейнере? {#read-only}

Есть два способа доставки файлов в контейнер в режиме read-only:
1. Принести файл в read-only как есть, без распаковки
2. Принести в контейнер архив в распакованном виде в режиме read-only

Ниже рассмотрим оба варианта.

### Как принести файл в контейнер в режиме read-only без распаковки? {#read-only-packed}

Эту возможность можно включить только для всех файлов сервиса одновременно, поштучно переводить ресурсы в read-only нельзя.
1. Зайти в `Runtime -> Instance Spec`
![img](https://jing.yandex-team.ru/files/bromigo/Screen%20Shot%202021-11-17%20at%2017.01.21.png)
1. В разделе `File bind settings -> Mode` выбрать `READ_ONLY`
![img](https://jing.yandex-team.ru/files/bromigo/Screen%20Shot%202021-11-17%20at%2017.02.45.png)
1. Сохранить изменения

### Как принести в контейнер архив в распакованном виде в режиме read-only {#read-only-unpacked}

Открыть `ISS properties` интересующего файла и указать:
* `Mount volume mode` – выбрать `Create new volume and mount in read only`
* `Path to mount volume` – путь, по которому нужно смонтировать вольюм

{% note warning %}

Ресурс должен быть tar.gz-архивом, иначе ISS не сможет использовать его как слой!

{% endnote %}

![img](https://jing.yandex-team.ru/files/alonger/Selection_004.png)

Под капотом ISS смонтирует новый вольюм в read-only режиме и положит в него указанный ресурс как слой.

## Настройки расселения подов {#update-pod-set}

Примеры настроек, определяющих на каких серверах из имеющегося парка можно запустить контейнеры сервиса:
1. Поддержка процессором набора инструкций AVX и AVX2
2. Производитель процессора: Intel или AMD
3. Пропускная способность сетевой карты: не меньше 10 гигабит или любая
4. Ограничения на число подов, которые можно поселить в одной серверной стойке. Оно нужно, чтобы не селить все поды сервиса в одну стойку и избежать шанса, что все они разом уйдут в даунтайм при проблемах с ней.

### Как поменять настройки расселения подов? {#update-pod-reallocation}

Чтобы поменять эти настройки может быть нужно переселить поды сервиса (например, если сейчас поды сервиса живут на хостах с процессором AMD, а их хочется переселить на Intel). Пока что мы не умеем делать это автоматически ([тикет на доработку](https://st.yandex-team.ru/YP-3741)), поэтому нужно будет запустить реаллокацию сервиса вручную. Итого нужно сделать следующее:
1. Для каждого кластера нажать `View pods -> Update pod set`
    ![img](https://jing.yandex-team.ru/files/alonger/update-pod-set.png)
2. Поменять требуемые настройки расселения и нажать `Update`. Теперь настройки сохранились в YP, но их ещё нужно применить, для чего переселим поды.
3. Для запуска реаллокации открыть `Reallocate pods`
4. По умолчанию реаллокация выполняется без переезда, в нашем же случае необходимо наоборот гарантировать переезд всех подов на сервера с нужными нам требованиями. Пока что единственный способ сделать это: поменять заказ диска (HDD или SSD). Например, можно уменьшить его на 1 мегабайт. ([Тикет, чтобы переезд можно было делать без смены заказа диска](https://st.yandex-team.ru/SWAT-7120))
    ![img](https://jing.yandex-team.ru/files/alonger/disk-update.png)
5. Для безопасности есть смысл переселять поды покластерно, сначала в одном датацентре, потом в другом и так далее. Для этого при запуске реаллокации можно выбрать конкретный кластер и повторить этот процесс для всех кластеров.
    ![img](https://jing.yandex-team.ru/files/alonger/Screenshot%20from%202022-03-06%2014-28-51.png)
