# Создание образа с программой для Porto

##  Disclaimer {#disclaimer}
В Няне есть возможность приносить исполняемые программы не только как каталог или файл по ссылке (или ресурс Sandbox), но и собирать набор слоёв в overlayFS. Для этого Няня формирует описание инстанса для ISS, агент которого на хосте скачивает образы и передаёт их командами в Porto, создавая тем самым иерархию каталогов для контейнера и последующего запуска в них программ. Здесь мы попробуем описать механизм работы и то, как самостоятельно оформить образ.

##  Механизм работы {#mechanics}
Если посмотреть на формат образа (`image`) Docker'а, то можно увидеть, что это просто архив, который содержит:

* иерархию каталогов и файлов образа;
* метаданные о том, какие нижележащие слои необходимы, кто собрал и т.д.;

Если отбросить детали, то команда `docker run`:
* скачивает образ и метаданные из `registry`;
* проходит по цепочке зависимостей каждого нижележащего слоя, скачивает их;
* монтирует слои в overlayFS (или другой драйвер, например, `devicemapper`);
* создаёт контейнер (набор cgroups и namespaces);
* запусукает указанную в метаданных команду в созданном контейнере;

Таким образом для описание среды выполнения программы достаточно данных, которые содержатся в `docker image`. В этом блеск и нищета Docker'а.

К сожалению, ни porto, ни ISS не умеют работать с указанным форматом. Там, где `docker run` выполняет все действия, в наших условиях ответственность разделена между несколькими независимыми сервисами. Рассмотрим основные варианты реализации каждой части.

###  Реестр образов {#registry}
В компании есть внутренний `docker registry`, но сейчас его рассматривать не будем. В качестве реестра (той части, которая ответственна за хранение) будем использовать Sandbox. Т.е. Sandbox может является хранилищем артефактов. О том, как их создавать, попробуем поговорить ниже.

###  Зависимости образов {#image-dependencies}
Очень удобным кажется разделение окружения для выполнения программы:

* ОС;
* набор установленных программ (python, java, etc);
от набора компонентов (файлов, каталогов), которые входят в состав самой программы. В мире docker зависимости можно описать в `Dockerfile`. В Няне, на данный момент, пользователь сам указывает набор образов и порядок их монтирования на странице `Instance Spec` сервиса:

![img](https://jing.yandex-team.ru/files/sshipkov/instancespeclayers.80c7227.png)

Указанный список образов будет передан в ISS, агент которого на передаст в porto команды для их корректного монтирования.

###  Скачивание образов {#downloading-image}
Если `docker run` обращается к реестру для скачивания образов, то в нашем случае агент ISS про это ничего не знает и скачивает образы по указанным ему ссылкам средствами `sky get` или напрямую по прямой HTTP ссылке.

###  Монтирование образов {#mounting-image}
Если `docker run` самостоятельно (с помощью разных реализаций "драйверов") монтирует цепочку образов как указано в метаданных образа, то в нашем случае агент ISS с помощью RPC передаёт в porto команды для монтирования overlayFS образов средствами демона `portod`. При этом `portod` выполнит распаковку архива с файловой системой.

###  Запуск образов {#running-image}
Если `docker run` узнаёт о том, какой исполняемый файл надо запустить в контейнере из метаданных образа, то в нашем случае ISS умеет запускать только один файл (который должен быть отдельным ресурсом и не может присутствовать в образе) - это `iss_hook_start` из каталога инстанса (который с помощью bind mount монтируется внутрь контейнера). В Няне для запуска и управления пользовательскими процессами обычно используется супервизор `instancectl`.

## Создание образа с инфраструктурными компонентами {#infra-components-image-create}
Было предложено собрать образ, в котором будут присутствовать вещи, нужные для деплоя в Runtime-облаке. На данный момент это как минимум:

* skynet
* InstanceCtl.

Для этого было сделано:

* Взят [базовый образ Ubuntu Precise](https://sandbox.yandex-team.ru/task/52715537/view), собранный разработчиками porto;
* Поверх образа был запущен [скрипт установки](https://git.qe-infra.yandex-team.ru/projects/JUNK/repos/alonger/browse/instancectl.sh?until=4927b9cebf22b73651bece5084afdb88ce6a9240) skynet и InstanceCtl;
* Результат был смерджен в [один архив](https://sandbox.yandex-team.ru/task/71510469/view).

##  Создание образа {#create-image}

Образ — это просто архив, контейнер `tar`, который может быть упакован различными алгоритмами (`.tar.gz`, `.tar.bz2`, `.tar.xz`).

Для создания образа с пользовательской программой достаточно:

* Создать желаемую иерархию каталогов, куда мы хотим поместить нашу программу, например, `mkdir -p opt/yandex/sepe/serve/`.
* Поместить нашу программу в неё, например, `mv serve.exe opt/yandex/testing/serve/`.
* Упаковать иерархию в контейнер `tar`: `tar -cvf serve.tar --owner="loadbase" opt`.
При необходимости можно поменять владельца файлов, например, на root. Т.к. распаковка происходит на хосте, то пользователь должен присутствовать в `/etc/passwd` на хосте.

В итоге у нас есть готовый образ, который можно принести на машину и запустить программу из него.

