#  Создание сервиса 
При создании сервиса нужно заполнить поля:

## Id - Идентификатор {#id}

Уникальный идентификатор сервиса. Требований к именованию сервисов нет, но лучше следовать трем правилам:
* Использовать только нижний регистр букв, для разделения использовать **_** (подчёркивание).
Символ **-** (дефис,минус) лучше не использовать. Предыдущее поколение систем деплоя bsconfig использовало дефис как спецсимвол. Мы постарались везде это учесть, но лучше это не проверять и дефис не использовать.
Совет: идентификатор сервиса используется для формирования пути на диске, если использовать только нижний регистр, то вводить пути удобнее.\
* Примерный шаблон `<tier_type>_<service_type>_<location>_...`.
Например, `production_setrace_msk`. Это боевая инсталляция сервиса Setrace, установлен он только в Москве.
* Пользовательский ad-hoc сервис можно именовать по схеме `test_<login>_<service_type>`
Например, `test_nekto0n_nanny`.

## Desc - Описание {#desc}

В этом поле можно оставить любую информацию про сервис. Это полезно, чтобы потом вспомнить что же это за сервис. Например, "Production instances of setrace.yandex-team.ru".

## Category - Категория {#category}

В Няне создано больше 7000 сервисов. Чтобы в них не запутаться, удобно показывать сервисы в иерархии, как файловую систему.

При создании сервиса лучше сразу его размещать в каталоге по общим правилам:

* (Боевые)/(общие тестовые) сервисы располагаются согласно условной орг. структуре:
* `/search/sepe/`
* `/search/mmeta/`
* `/search/base/`


* Частные пользовательские сервисы аналогично домашним каталогам в Unix:
* `/users/nekto0n/test_setrace_nekto0n`


* Глубина каталогов не должна превышать 3 (трёх).


## Comment - Комментарий первой ревизии {#comment}

Сервисы или создаются новые или копируются из существующих. Если сервис скопирован, то в это поле можно написать название родительского сервиса. По-умолчанию, подставляется строка "Initial commit".

## ABC service {#abc}

to-do

## SOX audit {#sox}

to-do

## Type of instances {#inst-types}

### YP {#yp}

Все ресурсы в поисковом "облаке" распределяет "сервис", называемый **генератором топологий** или **[YP-Lite](https://wiki.yandex-team.ru/yp/)**. По факту, этот сервис совмещает в себе несколько функций:

* Учёт доступных ресурсов
* Выделение ресурсов сервисам/проектам
* Генерация конфигурационных файлов для сервисов, имеющих бекенды в том же облаке

### GenCFG {#gencfg}

to-do

## Instance type {#type}

to-do

### Docker layers {#docker-layers}
to-do

### Sandbox layers {#sandbox-layers}
to-do

### QEMU_KVM {#qemu-kvm}
to-do

### OS_CONTAINER {#os-container}
to-do

## YASM Тэги инстансов {#instance-tags}

Для разметки инстансов в облаке используются тэги (также известные как `itags`, `instance_tags`). Разметку инстансов этими тэгами выполняет nanny при деплое на мощности YP. В последствии эти тэги используются для настройки мониторинга инстансов, их фильтрации и группировки. При деплое на YP тэги `itype, ctype, prj` должны быть указаны в UI сервиса.

Каждый инстанс обязательно размечен следующими тэгами:

* `itype` - Тип инстанса, программа. Например - `basesearch`, `alemateworker`, ... . Этот тэг используется [в головане](https://wiki.yandex-team.ru/golovan/faq/) для понимания того, как правильно мониторить данный тип программы (какие логи парсить, в какую HTTP-ручку стучать для сбора статистики, etc). [Подробнее про мониторинг сервиса силами голован](monitoring/monitoring.md#yasm-monitoring). К этому тэгу привязывается **[квота по количеству метрик в головане](https://clubs.at.yandex-team.ru/solomon/680)**;
* `ctype` - Тип контура. Например, `prod`, `prestable`, `test`.
* `prj` - Проект, например `music`, `web`;
* `metaprj` - метапроект, позволяющий группировать инстансы нескольких проектов;
* `geo` - геолокация, заполняется автоматически силами Nanny; на данный момент возможные значения `msk`, `sas`, `man`, `vla`;
* `dc` - конкретный датацентр, в котором будет запущен инстанс, заполняется автоматически силами Nanny: например, в случае с Москвой: `iva`, `myt`.

## Главная страница сервиса {#service-page}

![service-page.png](https://jing.yandex-team.ru/files/sshipkov/service-page.0e3467c.png)

Условно страница разделена на три колонки:

* Левая - управление описанием сервиса.
* Центральная - текущее состояние сервиса и инструменты для выкладки/отключения.
* Правая - просмотр событий, связанных с сервисом.


## Настройка расположения инстансов {#placement}

Управление, на какие хосты будет размещен сервис, осуществляется в разделе "Instances".
![instances.png](https://jing.yandex-team.ru/files/sshipkov/instances.e6f29c9.png)

##  Настройка администраторов {#setup-administrators}

Управлять сервисом могут только назначенные администраторы. Управлять ими можно на странице "Administrators" в разделе "Administration" (страница расположена в левом нижнем углу основной страницы сервиса).

Автор сервиса обладает ролями:

* **Owners** - владелец сервиса.
Владельцы сервиса могут назначать другие роли пользователям и удалять сам сервис, они имеют доступ в контейнеры сервиса. Нельзя удалить всех владельцев сервиса.
* **Operation managers** - управляющие операциями.
Управляющие операциями могут производить выкладку и отключение сервиса, изменять информационные атрибуты, они имеют доступ в контейнеры сервиса.
* **Configuration managers** - управляющие конфигурацией.
Управляющие конфигурациями могут изменять информационные и runtime атрибуты, они имеют доступ в контейнеры сервиса.

#### См. также {#see-also}

* [{#T}](../howto-manage-service.md)
