# Запуск Juggler в контейнерах

## О чём? {#whatsit}

Внутри инстансов изолированного по файловой системе и сети сервиса может быть необходимо запускать [juggler-проверки](https://wiki.yandex-team.ru/sm/juggler/). Для этого нужно запустить в сервисе **контейнерный juggler-агент**. Ниже описано, как это сделать.

##  Как это работает? {#how-does-it-work}
При включении в сервисе контейнерного juggler-агента при следующем деплое произойдёт следующее:

* В инстансы сервиса будет принесён бинарник juggler-агента;
* juggler-агент будет запущен в подконтейнере инстанса.

Juggler-агент будет запускать принесённые в инстанс bundle'ы с проверками, которые можно доставить одним из следующих способов:

* Пометить хотя бы один ресурс в сервисе как bundle с проверками. Тогда этот bundle будет распакован в директорию с проверками;
* Положить распакованный bundle в директорию с проверками.
[Подробнее о поиске проверок агентом](https://docs.yandex-team.ru/juggler/client/basics).
Если инстанс запускается в chroot, директория для распаковки бандла:
`/juggler/checks/<bundle_name>`
иначе:
`(BSCONFIG_IDIR)s/checks/<bundle_name>`

Для агрегации результатов проверки, запускаемой в инстансах, в UI Nanny можно настроить агрегированную проверку, которая будет создана в juggler.

##  Ограничения и особенности {#restrictions}

* Функционал совместим как со [структурированным конфигом instancectl](../structured-instancectl-config.md), так и с `instancectl.conf/loop.conf`.
* Функционал доступен для использования как в chroot, так и без него, как в MTN, так и без него.
* Для агрегации проверок средствами UI Nanny в `Monitoring settings` необходимо использовать `Instance resolve type: NANNY`.
* Juggler-агент по умолчанию запускается в подконтейнере со следующими лимитами, которые можно переопределить в UI:
    * `cpu_limit: 0.5c # 0.5 cores`
    * `memory_limit: 512M`

Для включения juggler-агента нужно (подробности в пошаговой инструкции ниже):

* Включить соответствующую опцию в UI;
* Принести в файлах хотя бы один bundle с проверками;
* Настроить агрегированную проверку в `Monitoring settings` сервиса.

##  Как запустить juggler-агента в контейнере с Instance Spec? {#how-to-enable-instance-spec}

1. Включить опцию `Start juggler subagent in container`

    ![2017-10-1016-02-37.png](../../_assets/2017-10-10_16-02-37.png)

2. Собрать bundle с проверками по [документации](https://wiki.yandex-team.ru/sm/juggler/juggler-client/#sborkasvoegobandla).

3. Указать собранный bundle в виде sandbox-ресурса в файлах сервиса и выставить в нём флажок `Is juggler bundle` или принести его в директорию с проверками другим способом (например, в виде слоя FS):

    {% note warning %}
    
    Ресурс должен быть обязательно не динамический
    
    {% endnote %}
    
    ![2017-10-1016-04-59.png](https://jing.yandex-team.ru/files/sshipkov/2017-10-1016-04-59.9a31049.png)

##  Как настроить агрегированную проверку? {#how-to-aggregate}

Для создания агрегированной проверки на основе приносимых пассивных нужно:

1. Указать в `Monitoring settings` сервиса `instance_resolve_type: NANNY`:

    ![2017-10-1016-12-15.png](https://jing.yandex-team.ru/files/sshipkov/2017-10-1016-12-15.c0d543b.png)

1. Добавить агрегированную пассивную проверку. В `Service name` нужно вписать имя проверки, приносимой указанной в `MANIFEST.json` в bundle и выводимой проверкой в `stdout`:

    ![2017-10-1016-15-15.png](https://jing.yandex-team.ru/files/sshipkov/2017-10-1016-15-15.e16c6e6.png)

1. Подождать, пока Nanny зальёт проверку в juggler, после этого на странице сервиса должна появиться кнопка `Juggler checks`:

    ![2017-10-1016-19-46.png](https://jing.yandex-team.ru/files/sshipkov/2017-10-1016-19-46.46af34b.png)

