# Перекластеризация Nanny-сервиса без рестарта

##  Что это? {#intro}
Вычислительные ресурсы в облаке выделяются через [GenCfg](https://gencfg.yandex-team.ru/). Распределение инстансов по кластеру меняется со временем (машины демонтируются, добавляются новые, etc). Это требует от пользователя переезда между хостами -- перекластеризации. Обычно при перекластеризации меняется (добавляется/удаляется) лишь небольшая часть инстансов сервиса. Но при этом меняются тэги всех инстансов сервиса, т.к. в их число входит версия топологии. А изменение тэгов инстанса приводит к рестарту инстанса. Из-за этого перекластеризация приводит к рестарту всех инстансов сервиса, даже тех, хосты, порты и ресурсы которых не поменялись.

##  Как перекластеризоваться без рестарта {#how-to}
В Nanny+ISS добавлена возможность исключить тэги топологии из числа статических тэгов инстансов. Для этого нужно выставить `Instance tags settings: TOPOLOGY_DYNAMIC` в описании инстансов сервиса. **Первая выкатка конфигурации с этой настройкой вызовет рестарт. Следующая выкатка будет уже без рестарта неизменившихся инстансов.**

Что поменяется:

* Из `BSCONFIG_ITAGS` пропадут тэги `a_topology_*`;
О чём не следует беспокоиться:
* cloud resolver продолжит работать: [https://st.yandex-team.ru/RX-151](https://st.yandex-team.ru/RX-151)
* построение графиков потребления ресурсов в gencfg продолжит работать: [https://st.yandex-team.ru/RX-165](https://st.yandex-team.ru/RX-165)

![img](https://jing.yandex-team.ru/files/sshipkov/2017-07-05_12-28-47.9fede64.png)

При этом тэги топологии инстансов записываются в [dynamic properties](https://st.yandex-team.ru/ISS-4382) инстанса `GENCFG_GROUP, GENCFG_RELEASE, GENCFG_REVISION` и доступны в API ISS-агента.

Несмотря на то, что в общем случае, изменение ресурсов приводит к рестартам инстанса - для изменяемых ресурсов можно воспользоваться [динамическими ресурсами](https://wiki.yandex-team.ru/iss3/specifications/configuration/resource/#dinamicheskijjresurs). Обновление подобных динамических ресурсов так же не приведет к рестарту инстанса (важно не забыть описать [notify_script](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/#notifyscript) в секции instancectl для бинарника который использует этот ресурс).

![img](https://jing.yandex-team.ru/files/sshipkov/Files__mail_search_prestable__Services__Home_2017-08-02_12-30-19.9d3da80.png)

