# Активация инстансов с учётом шардов

##  Пример {#example}
Сервис состоит из множества инстансов, каждый из которых запущен со своим куском индекса -- шардом. Каждый шард представлен в трёх (в общем случае `N`) репликах, лежащих на разных хостах, над каждой из которых запущен отдельный инстанс сервиса. Чтобы сервис отвечал на запросы полными данными, необходимо, чтобы в любой момент был запущен хотя бы один (в общем случае `K`) инстансов над каждым уникальным шардом. Для этого нужно выполнять рестарт сервиса для выкладки новой ревизии в правильном порядке: чтобы никогда не рестартить одновременно все инстансы одного шарда данных.

##  Варианты настройки {#how-to}
Для включения такого порядка переключения нужно настроить [рецепты сервиса](../reference/defaultrecipies.md) одним из двух способов.

### 1. Sharded selectors {#sharded-host-selector}
Первый вариант: выставить в задачах подготовки и активации сервиса параметр одним из двух значений:

* `instance_selector: sharded_instance_selector`;
* `instance_selector: sharded_host_selector`.
В этом случае переключение будет происходить так, как написано в [исходном примере](#example) с учётом порогов деградации.
Единственное отличие `sharded_host_selector` в следующем: если на хосте есть несколько инстансов (в том числе, например, с разными шардами), они все будут отправлены в обработку одновременно только когда это позволит сделать порог деградации. Этот тип селектора не допускает ситуацию, при которой часть инстансов из общего множества живущих на хосте запущена в обработку, а часть -- ещё нет. Эта особенность была нужна для совместимости с bsconfig, и сейчас `sharded_host_selector` больше не должен быть нужен, вместо него всегда должно хватать `sharded_instance_selector`.

Для работы этого метода **необходимо**, чтобы шарды были прописаны в описании сервиса (вкладка `Shard`) в виде `SANDBOX_SHARDMAP`.

При этом значения порогов `operating_degrade_level` и `stop_degrade_level` из [рецептов](../reference/defaultrecipies.md) будут учитываться в рамках шарда.

Поэтому пороги деградации для шардированного переключения нужно подправить.
Пример:

1. В сервисе есть 100 шардов, каждый представлен в 3-ёх репликах. Если `operating_degrade_level = 0.5`, и `stop_degrade_level = 0.5`, то переключение будет происходить так, чтобы одновременно было погашено не больше `округление_вниз(0.5 * 3) = 1` реплики каждого из шардов. Это значит, что если хотя бы в одном шарде есть хотя бы одна неотвечающая реплика (например из-за мёртвой машины), то переключение никогда не будет завершено. Следовательно, нужно или увеличивать допустимые пороги деградации, или использовать метод 2

### 2. Упорядочивание по тэгу шарда {#group-by-tag-prefix}
Сделано в рамках тикета [SWAT-3071](https://st.yandex-team.ru/SWAT-3071).

[Обсуждение из рассылки с детальным описанием](https://ml.yandex-team.ru/thread/2370000003239323610/#message2370000003239323610).

Для работы этого метода необходимо, чтобы у инстансов был выставлен тег `OPT_shardid=<N>` из gencfg.

Упрощённо схема выглядит так:

1. Инстансы сервиса группируются по значению `N` из тега `OPT_shardid=N`;
1. Последовательность формируется по принципу:

* 1-й элемент из группы 1;
* 1-й элемент из группы 2;
* 1-й элемент из группы 3;
* ...
* 2-й элемент из группы 1;
* 2-й элемент из группы 2;
* ...

Такая схема позволяет избегать зависания переключения, возможного в методе 1, при этом практически снимая вероятность одновременного выключения всех инстансов одного шарда.

Для включения этого метода в рецептах активации необходимо выставить параметр: `group_by_tag_prefix: OPT_shardid=`.

