# Как включить дисковые квоты

## О чем
Как включить дисковые квоты для сервисов Няни, которые уже работают в chroot.

## 1. Как проверить значения квот
Изначально квоты на volume'ы задаются в gencfg. Квоты бывают на 3 вида томов:

- на "/" - место монтирования базового образа ОС. Базовый образ всегда монтируется в "/", создавая для вас нужную операционную систему. Если вы используете режим `virt_mode=app` (сокращенный образ), то мы предлагаем закладывать 500 МБ на снепшот. Если используется режим `virt_mode=os` (полный образ), то закладывать 1.5 ГБ на снепшот. Если у вас 3 снепшота, для полного образа нужно заложить 1.5*3=4.5*1.1 (на всякий случай)=4.95 ГБ
- на workdir, рабочий каталог - место запуска вашего приложения в контейнере. Здесь находятся все бинарники, конфиги, принесенные ISS, и все ваши данные, которые вы сохраняете в процессе работы. Квота рассчитывается в каждом конкретном случае и это пространство требуется для каждого снепшота Няни. Сейчас файлы, которые приносит ISS в квоте не учитываются (в будущем будет еще одна квота для "оптимизации").
Пример: вы в процессе работы сохраняете 10 МБ данных в рабочий каталог, если у вас 3 снепшота, то нужно заложить 10МБ*3=30*1.1 (на всякий случай)=33 МБ. Практически мы советуем выделять не менее 1ГБ на рабочий каталог т.к. если вам вдруг завтра понадобится добавить данные размером 2 МБ, то места уже может не хватить.

Сами квоты описываются в json-формате по каждому тому в группах:

```json
    {
        "generate_deprecated_uuid": false, /*Системная часть, без изменений*/
        "guest_mp": "/logs", /*Место монтирования в файловой системе контейнера*/
        "host_mp_root": "/place", /*Выбор либо "/place"=hdd, либо "/ssd"=ssd*/
        "mount_point_workdir": false, /*Ставится в true, только если это том для хранения working directory (cwd)*/
        "quota": "1.10 Gb", /*Квота на том. В случае "/" и "working directory" эта квота на все снепшоты*/
        "shared": false, /*Признак, что том делится между контейнерами, должен быть всегда false*/
        "symlinks": [] /*Должны быть пустыми*/
    }
```

Пример: 

![img](https://jing.yandex-team.ru/files/sshipkov/Monosnap_2018-03-23_18-33-15.4210861.png)

## 2. Как включить квоты в Няне
В Няне нужно явно указать, что вы включаете квоты и указать размер квоты на один снепшот внутри "/" и "working directory". Т.е. квота, заданная в Gencfg на эти пути, будет разделена между всеми снепшотами Няни, где под каждый снепшот будет пытаться выделиться меньшая квота. **Если при создании очередного снепшота в квоте не хватит для него места снепшот останется в состоянии "GENERATING" с сообщением об ошибке в таскгруппе.**

Пример:

![img](https://jing.yandex-team.ru/files/sshipkov/Image_2017-12-06_11-22-40.1c57b10.png)

## 3. Не забыть проверить все целиком
Теперь нужно проверить, что все работает. Нужно выкатить новый снепшот и убедиться, что снепшот нормально активируется.

