# Перевод сервиса на отдельный mount namespace

##  О чём {#dislaimer}

Попробуем в этом документе собрать инструкцию по переводу сервиса на отдельную файловую систему.

{% note warning %}

Здесь рассматривается только вариант перевода `rootfs` - т.е. `/`. Для обеспечения изоляции еще нужно уйти от схемы монтирования хостовых каталогов и перенести файлы в изолированные разделы(volumes). Как хранить свои данные в вольюмах описано в  [Перевод сервиса на выделенный storage](move-to-volumes.md).

{% endnote %}

##  Technical notes {#technical-notes}
В документе мы рассматриваем запуск приложения пользователя в контейнере, который имеет отдельный `mount namespace` и в качестве `/` используется [overlayfs](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/Documentation/filesystems/overlayfs.txt), которая состоит

* из архива с базовым образом ОС, который предоставляет пользователь (`lowerdir`)
* каталога, в который производится запись (`upperdir`)
Квоты, рассматриваемые ниже, относятся к размеру каталога `upperdir`, по сути - diff'у, который записал пользователь поверх базового образа.

##  Базовый слой {#base-layer}
Т.к. для запуска нужен только архив с "базовым образом", то у пользователя есть выбор в каком виде ему удобно предоставить системе этот образ. Существует два варианта:

* использование образа в формате Docker (набора слоёв) из внутреннего registry.yandex.net
* использование базового слоя от команды эксплуатации runtime облака (a.k.a porto layer)

###  Docker Image {#base-layer-docker-image}
В качестве базового образа `/` можно использовать образ докера, размещённый в registry.yandex.net.

![img](https://jing.yandex-team.ru/files/sshipkov/docker-image.65d3162.png)

###  Porto Layer {#base-layer-porto-layer}
Командой эксплуатации runtime облака поддерживается "каноничный" образ базового слоя операционной системы, который собирается в Sandbox. Рекомендуется брать самый свежий образ [из списка](https://sandbox.yandex-team.ru/resources?type=PORTO_LAYER_SEARCH_UBUNTU_PRECISE_APP). 

![img](https://jing.yandex-team.ru/files/sshipkov/porto-layer.7c6bbac.png)

Если в базовом слое вам не хватает каких-либо пакетов, или хочется положить свои инструменты, вы можете создать свой слой по
[этой инструкции](https://wiki.yandex-team.ru/runtime-cloud/serviceinportocontainer/#sborkasvoegosloja), и добавить его в свой сервис поверх базового слоя.

##  Проброс каталогов с хоста {#host-bind-mount}

Если сервис хранит свои данные или ведёт запись логов в "публичном" каталоге:

* `/place/db/www/logs`
* `/place/db/bsconfig/webcache`
* `/place/db/bsconfig/webstate`
и
* по каким-то причинам нет возможности использовать volumes(*)
* необходима миграция данных
можно смонтировать эти каталоги внутрь своего контейнера. Для этого нужно отметить нужный галочкой в интерфейсе Nanny (вкладка **Instance Spec**):

![img](https://jing.yandex-team.ru/files/sshipkov/host-bind-mount.22721d6.png)

`*` - использование volumes рассматривается в [Перевод сервиса на выделенный storage](move-to-volumes.md).

##  Настройка rootfs в Gencfg {#gencfg-rootfs}
Т.к. rootfs тоже использует ресурсы хоста (место на диске), то необходимо этот момент регулировать, учитывать и ограничивать. Настроить ограничения на размер можно через UI gencfg в разделе _Volumes_ - для этого нужно:

1. Отредактировать JSON документ для `/` volume'а

    ![img](https://jing.yandex-team.ru/files/sshipkov/updatevolumes.491d70b.png)

    ```json
    {
        "guest_mp": "/",
        "host_mp_root": "/place",
        "quota": "1 Gb",
        "shared": false,
        "symlinks": []
    }
    ```
    
    где:

    * `guest_mp` (guest mount point) - точка монтирования, для `rootfs` - это `/`.
    * `host_mp_root` - раздел на хост машине для хранения данных
    Доступны варианты:
        * `/place` - на HDD
        * `/ssd` - на SSD
    * `quota` - максимальный размер тома
        При превышении приложении будет получать ошибку `ENOSPC`.
    * `shared` - доступен ли этот раздел для других сервисов/групп.
        В данный момент функциональность не протестирована и рекомендуется всегда использовать значение `false`.
    * `symlinks` - список символьных ссылок, которые необходимо установить на том в контейнере
        В данный момент функциональность не протестирована и рекомендуется всегда использовать пустой список `[]`.
2. Выставить в сервисе новый тег gencfg (если сервис живет на trunk, дождаться обновления trunk gencfg). Следить за процессом генерации тега/обновления trunk можно ((https://clusterstate.yandex-team.ru/gencfg здесь)) 1.
3. Включить **Volumes** в настройках сервиса:

    ![img](https://jing.yandex-team.ru/files/sshipkov/2017-09-0819-10-24.159fb0e.png)

##  Мониторинг через YASM (голован) {#yasm}
Если вы используете кастомные модули голована, которые требуют доступа к файловой системе инстанса (читают логи или другие файлы в FS инстанса), при заезде в chroot, необходимо включить в своих инстансах контейнерный yasm-агент. [Инструкция](https://wiki.yandex-team.ru/golovan/yasmagent/subagent/#kakzamonitoritjasmominstansvkontejjnere).

##  Issues {#issues}

* В данный момент **выставленные ограничения размеров **для rootfs** временно не доносятся до хостов и, соответственно, не учитываются**.
* ISS-4746
При запуске контейнера используется 2 каталога с квотами:
    * `cwd` - рабочий каталог инстанса (`/place/db/iss3/instances...`)
    * `root` - `/`
Это затрудняет квотирование и учёт дискового пространства.



