# Перевод сервиса на SSD

## О чём {#dislaimer}

Попробуем в этом документе собрать инструкцию по переносу всех или части данных сервиса на SSD.
Сейчас отдельно настраивается место хранения для:

* Директории инстанса сервиса;
* RootFS сервиса;
* Ресурсов и шардов сервиса;
* Persistent volume'ов сервиса;
* Логов сервиса.
Настройка каждого из вышеперечисленных пунктов имеет свои особенности. Рассмотрим каждый из них.

## Перенос директории инстанса на SSD {#instance-dir}

Директорией инстанса в терминах Nanny/ISS называется рабочая директория (`cwd`) инстанса. В ней запускаются отдельные секции из конфига `instancectl.conf` инстанса, хуки ISS (`iss_hook_start`, `iss_hook_stop`, ...). В ней **не хранятся** ресурсы сервиса, а лежат только симлинки на них.
Поэтому обычно в этой директории лежат только:

* логи instancectl `loop.log[.full]` и его `state`-файлы;
* файлы, в которые перенаправляются `stdout`, `stderr` секций сервиса;
* файлы, которые секции сервиса сами создают на диске, например, результаты распаковки архивов, приносимых в ресурсах сервиса.

{% note warning %}

Смена места хранения директории инстанса возможна только при наличии RootFS.

Перенести на SSD директорию инстанса без заезда в chroot нельзя.

{% endnote %}

## Перенос RootFS инстанса на SSD {#rootfs}

Описан в отдельном документе: [Перевод сервиса на отдельный mount namespace](move-to-rootfs.md)
При переносе RootFS на SSD туда же автоматически будет перенесена и директория инстанса.

## Перенос ресурсов/шардов сервиса на SSD {#resources}

Сейчас место хранения каждого ресурса и шарда сервиса настраивается отдельно.
Для переезда на SSD нужно указать `storage = /ssd`:

1. В конкретном ресурсе:

    ![img](https://jing.yandex-team.ru/files/sshipkov/2017-05-19_12-42-11.048ca0c.png)

1. На странице шарда/шардмапа:

    ![img](https://jing.yandex-team.ru/files/sshipkov/2017-05-19_12-40-57.a5dceaf.png)

## Перенос persistent volumes на SSD {#persistent-volumes}

Описан в отдельном документе: [Перевод сервиса на выделенный storage](move-to-volumes.md)

## Перенос логов сервиса на SSD {#logs}

Правильный путь переноса логов на SSD: использовать persistent volume `/logs`. При этом нужно не забыть настроить [ротацию логов в изолированной файловой системе](../logrotate.md#custom-rootfs).

