# Перевод сервиса на выделенный storage

##  О чём {#dislaimer}
Попробуем в этом документе собрать инструкцию по переносу данных сервиса на выделенные volume'ы для хранения.

Важно:
* для перевода сервиса на выделенные volumes **необходимо сначала перевести его в chroot** по инструкции [Перевод сервиса на отдельный mount namespace](move-to-rootfs.md).
* формат предоставления места на дисках **может быть пересмотрен** в ближайшем будущем
* пока **все** не перейдут на использование volume'ов - нет гарантий, что место на диске не закончится
при этом использовать volume'ы на данном этапе можно:
* если риски потерять данные выше возможных будущих проблем при использовании volume'ов
Например, если на физических хостах есть другие сервисы без изоляции (в данный момент в RTC таких большинство), то они могут по ошибке удалить ваши данные из общих каталогов (`webstate` и `webcache`).
* данные можно восстановить из других реплик/иного хранилища

Переводить **production** сервисы на выделенный storage можно, но нужно это делать **пределельно** осторожно и постепенно.

##  Gencfg {#gencfg}
Необходимо сконфигурировать в настройках группы GENCFG volume'ы для хранения данных сервиса.

![img](https://jing.yandex-team.ru/files/sshipkov/movetovolumesgencfg.9754f71.png)

Для этого необходимо на странице группы в самом низу карточки отредактировать описание volume'ов. Это список json документов, каждый из которых описывает volume. Доступны следующие поля:

* `guest_mp` (guest mount point) - точка монтирования в контейнере
* `host_mp_root` - раздел на хост машине для хранения данных
Доступны варианты:
    * `/place` - на HDD
    * `/ssd` - на SSD
* `quota` - максимальный размер тома
При превышении приложении будет получать ошибку `ENOSPC`.
* `shared` - доступен ли этот раздел для других сервисов/групп.
В данный момент функциональность не протестирована и рекомендуется всегда использовать значение `false`.
* `symlinks` - список символьных ссылок, которые необходимо установить на том в контейнере
В данный момент функциональность не протестирована и рекомендуется всегда использовать пустой список `[]`.

Разберём примеры.

###  Volume: rootfs {#gencfg-rootfs}

Переход на изоляцию по файловой системе описан в [Перевод сервиса на отдельный mount namespace](move-to-rootfs.md).

###  Data volume {#gencfg-volume}
```json
{
    "guest_mp": "/var/lib/mongo",
    "host_mp_root": "/ssd",
    "quota": "100 Gb",
    "shared": false,
    "symlinks": []
}
```

Важно:
* При использовании стандартного образа из `Sandbox layers` необходимо **удалить** предлагаемый по-умолчанию `/var/tmp` если он есть в списке.

###  Known issues {#gencfg-known-issues}
* gencfg разрешает указывать `/ssd` без валидации того, что SSD есть на машине.
* [https://st.yandex-team.ru/PLATFORMOPS-235](https://st.yandex-team.ru/PLATFORMOPS-235)
* [https://st.yandex-team.ru/RUNTIMECLOUD-3585](https://st.yandex-team.ru/RUNTIMECLOUD-3585)
* [https://st.yandex-team.ru/ISS-4766](https://st.yandex-team.ru/ISS-4766)

###  Изменение volume'ов {#gencfg-changing-volumes}

TL;DR: изменять размер volume'ы после выкладки **нельзя**.
При создании volume'а gencfg генерирует _уникальный идентификатор_ тома. При **изменении** хотя бы одного из атрибутов:
* `guest_mp`
* `host_mp_root`
* `shared`
а так же при **изменении** имени группы будет создан **новый** volume и данные будут утеряны. Т.е. в gencfg **можно** изменить квоту дискового пространства.
На хосте ситуация выглядит сложнее. Если в одной ревизии инстанса у volume'а квота `200G`, а в другой - `300G` (из другого тэга gencfg), то:
* при активации ревизии с квотой `300G` iss-agent попросит porto создать volume с новыми параметрами
* porto ответит `VOLUME_ALREADY_CREATED`
* volume останется без изменений

##  Nanny {#nanny}
Далее нам необходимо использовать эти volume'ы в нашем сервисе. Для этого:

* сервис **должен** использовать либо докер, либо porto образ (`Sandbox layers`)
* включаем галочку `Mount gencfg volumes into instance filesystem`

![img](https://jing.yandex-team.ru/files/sshipkov/movetovolumesnanny.5451f26.png)

Теперь мы готовы к запуску сервиса с выделенным хранилищем. Если у нас уже есть данные, например, в `/db/bsconifg/webstate`, то их необходимо перенести.

##  Перенос read-only данных {#migration-readonly}

##  Перенос read-write данных {#migration-readwrite}
Рассмотрим сценарий, когда данные нашего сервиса, например, mongodb хранятся в общем каталоге на хосте. Т.е. дано:

* данные лежат в каталоге хоста `/place/db/bsconfig/webstate/mongodb_{BSCONFIG_IPORT}`
* внутри контейнера должны лежать в `/var/lib/mongo`
Тогда план действий может быть следующим:
* монтируем каталог хоста внутрь контейнера
Для этого мы на странице `Instance Spec` выбираем `Bind /place/db/bsconfig/webstate into container`
* копируем данные в volume
Копировать надо только при условии, что предыдущий инстанс погас (чтобы в данные не происходило записи). К сожалению, init container'ы и prepare_script для этого не подходят, т.к. они могу выполняться параллельно запущенному инстансу из предыдущей ревизии сервиса. Тогда у нас два вариант:
    * дописываем команду копирования перед запуском приложения
    `cp -pr /place/db/bsconfig/webstate/mongodb_{BSCONFIG_IPORT}/* /var/lib/mongo/ && ./bin/mongod ...`
    * в `instancectl.conf` настраиваем копирование в `install_script`
    `install_script = cp -pr /place/db/bsconfig/webstate/mongodb_{BSCONFIG_IPORT}/* /var/lib/mongo/`
    Так же рекомендуется добавить проверку, на то, что копирование не затрёт данные, например, при рестарте приложения после падения - т.к. эти скрипты будут отрабатывать при каждом старте.

Далее мы:
* запускаем выкладку и проверяем, что всё работает
* отключаем монтирование host каталога (отжимаем галочку `Bind ...`)
* удаляем копирование данных из скриптов
* выкатываем сервис заново

##  Полезные советы {#migration-tips}
* Для проверки работоспособности схемы полезно использовать ручную смену состояния инстансов.

![img](https://jing.yandex-team.ru/files/sshipkov/movetovolumesmanual1.e6cff87.png)

