#  Выставление дисковых квот в сервисе

Каждому инстансу изолированного сервиса выделяется ограниченная квота под размещение данных на диске (hdd или ssd).
Квоты выделяются на:

1. **Persistent volumes**. Это вольюмы, которые сохраняются при перевыкладке инстансов. Если инстанс запишет в этот вольюм какие-то данные, а потом будет перевыкачен с новой версией бинарника, то данный вольюм будет присутствовать в новой версии инстанса без потерь данных (*). Обычно такие вольюмы маунтятся по пути `/persistent` или `/logs` в инстансе (в его mountnamespace). Все эти вольюмы изначально пусты, заполнить их можно только изнутри самого инстанса.
1. **Root volume**. Это вольюм с корнем файловой системы (т.е. его mount point это `/`). В этом вольюме будут присутствовать файлы, приносимых в слоях файловой системы (`FS layers`). При этом файлы, принесённые в слое и в виде sandbox-ресурсов сервиса, не будут учитываться в квоте (занимают место бесплатно, не квотируются). Квотируются только те файлы, которые инстанс создаст в процессе своей работы.
1. **Work dir volume**. Это вольюм с директорией инстанса (`cwd`). Он маунтится в `/db/iss3/instances/<some_instance_hash>`. В ней запускаются отдельные секции из конфига `instancectl.conf` инстанса, хуки ISS (`iss_hook_start`, `iss_hook_stop`, ...). В ней **не хранятся** ресурсы сервиса, а лежат только симлинки на них. Поэтому обычно в этой директории лежат только:
    * логи instancectl `loop.log[.full]` и его `state`-файлы;
    * файлы, в которые перенаправляются `stdout`, `stderr` секций сервиса;
    * файлы, которые секции сервиса сами создают на диске, например, результаты распаковки архивов, приносимых в ресурсах сервиса.
    
    Все файлы, созданные инстансом в текущей рабочей директории, будут входить в квоту на work dir.
    `Root volume` и `work dir volume` у каждой ревизии инстанса свои. То есть при перевыкладке сервиса с новой версией бинарника, этой новой версии не будут доступны файлы, созданные в рабочей директории или в `/` предыдущей версией.


##  Потеря данных volume'ов {#volumes-data-loss}

Данные вольюмов будут потеряны как минимум в следующих случаях:

1. При плановых переналивках сервера;
1. При внеплановых отказах железа.
1. Данные **root volume / work dir volume** будут удалены с диска, как только соответствующая ревизия инстанса получит целевое состояние `REMOVED` (удаление произойдёт не обязательно сразу же, но может случиться в любой момент, начиная с перевода инстанса в `REMOVED`).
1. Данные, записанные в **persistent volume**, будут удалены с диска, как только на хосте не останется ни одной ревизии инстанса в состояниях `PREPARED/ACTIVE`, в которых был указан этот volume.

**Пример**

1. В сервисе есть активный снэпшот `A` и новый снэпшот `B`;
1. В обоих снэпшотах указан один и тот же persistent volume;
1. Если запустить выкладку снэпшота `B` и сразу же удалить снэпшот `A`, то:
1. Данные persistent-вольюмов будут потеряны данные на тех инстансах, на которых новая ревизия (снэпшота `B`) не успела перейти в состояние `PREPARED` [Пример из реальной жизни](https://st.yandex-team.ru/RTCSUPPORT-1132#1528883250000).
1. Ещё одна особенность **persistent volumes** в gencfg, которая может привести к потере данных: при изменении любого параметра вольюма, включая дисковую квоту, точку монтирования и других, при выкладке его новой версии будет создан новый volume, без переноса данных, данные же старого вольюма **не будут доступны** из новой ревизии инстанса.

##  Как выставить дисковые квоты на сервис до 10GB? {#how-to-set-relaxed-quotas}

Ослабленные квоты реализованы в рамках тикета [SWAT-4142](https://st.yandex-team.ru/SWAT-4142) и **работают только для gencfg**, под YP-lite их нет.
Если под ревизию (снэпшот) инстанса сервиса суммарно требуется:

1. Не больше `10GB` суммарно на work dir и root volume на каждый снэпшот;
1. Требуется хранить не больше 5 ревизий (в cleanup policy указано суммарно не больше пяти хранящихся снэпшотов)
То квоты на root volume и work dir **достаточно указать только в Nanny**. Квоты на root volume / work dir из gencfg учитываться не будут.
Квоты на persistent volumes всё равно нужно выставлять в gencfg.
![img](https://jing.yandex-team.ru/files/sshipkov/2017-12-04_16-13-14.9aad4ea.png)
О том, что ослабленные квоты включились, можно узнать по наличие сообщения:
![img](https://jing.yandex-team.ru/files/sshipkov/2018-03-23_13-27-41.2070054.png)

##  Как выставить дисковые квоты на сервис больше 10GB? {#how-to-set-not-relaxed-quotas}

Если условия из предыдущего пункта не выполняются, то квоты на work dir и root volume нужно указывать в двух местах:

1. В Nanny нужно указать квоту на отдельный снэпшот:
    ![img](https://jing.yandex-team.ru/files/sshipkov/2017-12-04_16-13-14.9aad4ea.png)
1. В gencfg нужно указать сумму квот по всем снэпшотам на root volume и work dir.
    При этом на стадии генерации конфигурации будет проверка того, что сумма квот всех снэпшотов сервиса не превосходит квоту на rootfs и рабочую директорию, выделенную в gencfg.
