# Способ запуска инстанса в UI Nanny (containers/init_containers)

##  Что это? {#what-is-it}
Для запуска исполняемых файлов сервиса на конечных машинах кластера используется программа InstanceCtl. Для того, чтобы запустить сервис, InstanceCtl должен знать, как и какие приложения (пользовательские процессы) запускать. Описать это можно двумя способами:

* в конфигурационном файле `instancectl.conf` (или `loop.conf`)
Который пользователь должен доставить в виде ресурса в контейнер.
* в виде списка запускаемых контейнеров в UI/API сервиса. В этом случае `loop.conf` использовать не надо.

Последний способ предпочтительнее:

* упрощает логику instancectl
Убираются eval'ы, сложный граф обработки секций с переменными и связанные с этим ошибки и сложности настройки.
* позволяет валидировать содержимое на этапе сохранения
Сейчас любые проблемы в том, что не так задана переменная, дубли в названиях секции, прочие опечатки - будут видны только в логе iss-agent'а, который очень нетривиально увидеть обычному пользователю.
* понижает порог входа для новых пользователей
Пользователи не знакомы с секцией `default`, с install и prepare скриптами, с правилами eval'ов и прочими тонкостями.
* позволяет описать tcp,http,exec проверки живости
Теперь не нужны `nc` и прочие вещи. Особенно это актуально при переходе на изолированные образы, где каких-то инструментов может не быть.
* install переработан и появились отдельные `init` секции
Они выполняются последовательно, теперь сильно проще описывать сценарий подготовки, т.к. есть гарантии порядка.
* При структурированном описании появляется возможность автоматизировать анализ миграции, правки.
Формат loop.conf умеет разбирать только `instancectl`. Нет возможности написать скрипт, который проанализирует то, чем пользуются пользователи или скриптом выставить проверку HTTP.
* Часть функциональности уже давно была в instance spec.
Специальные типы volume'ов, секреты и т.д. уже давно описываются этим механизмом. Сейчас мы закончили это оформлять.

##  Как это использовать {#how-to}
В Instance Spec можно указать один или несколько контейнеров, каждый из которых будет запущен в инстансах сервиса. Здесь контейнер соответствует секции `instancectl.conf` в старой модели. **Важно:** название "контейнер" в данный момент номинальное, реально же запуск исполняемых файлов происходит в одном porto-контейнере (в будущем это место планируется расширять).
Описание контейнера содержит:

* команду для запуска с поддержкой текстовых подстановок;
* описание способа проверки состояния контейнера (используется для плавной выкладки сервиса);
* способ штатной остановки контейнера;
* прочие параметры.

Помимо обычных контейнеров существуют также **init-контейнеры**. Они являются аналогом prepare-скриптов `instancectl.conf`. Эти контейнера запускаются на стадии PREPARE-инстанса.

###  Команда для запуска контейнера {#command}
Данная команда будет запущена не внутри shell, т.е. она не поддерживает использование синтаксиса командной оболочки (операторы `|`, `>` и другие не будут работать).
Команда поддерживает подстановки стандартного контекста: `BSCONFIG_IPORT`, `BSCONFIG_IDIR`, `a_geo`, `a_dc`. [Полный список](https://wiki.yandex-team.ru/JandeksPoisk/Sepe/instancectl/#iss-loop-conf-render-params). Переменные для подстановки необходимо указывать в скобках `{}`, например, `{BSCONFIG_IPORT}`.
Все переменные для подстановки так же будут переданы при запуске команды в виде переменных окружения.
![img](https://jing.yandex-team.ru/files/sshipkov/2017-06-0518-37-04.a1e97a6.png)

Если надо выполнить несколько баш команд, то можно использовать [init containers](/#init-containers), предназначенные для этой цели.

Если же они по каким-то причинам не подходят, можно завести отдельный static file со скриптом с этими командами
куда передавать нужные переменные окружения в виде аргументов (не забывая обернуть вызов скрипта в bash -c!). Пример:

```
start_container.sh:
    PORT=$1
    some_cmd1
    some_cmd2 --port $PORT

Command:
    bash -c './start_container.sh {BSСONFIG_IPORT}'
```


####  Совместимость с переменными окружения в shell {#command-vs-shell}

**Внимание** Выполнение команд из instance spec происходит в два этапа:

1. Сначала instancectl выполняет замену переменных вида `{BSCONFIG_IPORT}`, `{BSCONFIG_IDIR}`, etc, используя стандартный метод `str.format` языка python;
1. Только после этого команды передаются для исполнения на вход в `sh`.
**Отсюда следует**, что использовать стандартный шелловый синтаксис вида `${MY_ENV_VAR}` без изменений **нельзя**. Нужно заменить такую конструкцию на `${{MY_ENV_VAR}}`, чтобы instancectl не пытался заменить эту строку на `${<значение-переменной-MY_ENV_VAR>}` до передачи команды в shell.

Кроме того, выполнение команд выполняется с помощью `exec`. Это означает, что при использовании конструкции вида `bash -c 'command --arg $(helper_command)'` произойдёт попытка выполнить подстановку **до** вызова `bash -c`, что приведёт к ошибке `Cannot start container: InvalidCommand:(wordexp(): command substitution is not supported)`. Избежать этого можно экранируя вызов команды: `bash -c 'command --arg \$(helper_command)'`.

###  Проверка живости контейнера {#readiness}

При выкладке релиза Nanny постепенно рестартит инстансы сервиса [плавающим окном](https://wiki.yandex-team.ru/runtime-cloud/nanny/alemate/yaml-recipes/#operating-degrade-level-desc). Перед тем как запустить рестарт следующей группу инстансов, Nanny убеждается, что предыдущие инстансы успешно поднялись с новым релизом и хорошо себя чувствуют. Это позволяет автоматически остановить выкладку релиза, если он содержит проблемы и приводит к падению сервиса в проде. Чтобы сервис считался живым, и выкладка продолжилась, необходимо как минимум, чтобы приложение не падало, то есть чтобы не завершался запускаемый в контейнере процесс приложения. Но это не единственный критерий, который можно использовать для определения живости, ведь сервис может испытывать проблемы даже тогда, когда он запущен. Например, процесс может не отвечать на входящие запросы или чрезмерно тормозить. Поэтому в любом продакшн сервисе всегда имеет смысл указывать проверку живости помимо встроенной, проверяющий падения процессов. Например, использовать в качестве проверки живости HTTP-запрос в инстанс сервиса, чтобы убедиться, что помимо того, чтобы не падать, он в принципе ещё и отвечает хоть на какие-то запросы. Можно подобрать и другие, специфичные для данного конкретного сервиса критерии определения его жизнеспособности.

Итого, для того, чтобы контейнер считался живым, необходимо, чтобы одновременно:

1. Не падал процесс, описанный в команде запуска контейнера;
1. Корректно отрабатывала проверка живости, указанная в UI (если такая есть).
Инстанс в целом считается живым, если живы все его контейнеры (это место планируется расширять, добавив возможность учитывать живость лишь части контейнеров, как это было возможно с `instancectl.conf`).

Доступны следующие способы проверки живости:

* `HTTP_GET` — контейнер считается живым, если статус ответа на HTTP GET запрос < 400;
* По умолчанию проверка будет использовать порт инстанса `BSCONFIG_IPORT`, однако можно указать другой порт. Поле `port` поддерживает подстановки, например, `{BSCONFIG_IPORT_PLUS_1}`.


* `TCP_SOCKET` — контейнер считается живым, если удалось успешно выполнить вызов `connect` на заданный порт;
* По умолчанию проверка будет использовать порт инстанса `BSCONFIG_IPORT`, однако можно указать другой порт. Поле `port` поддерживает подстановки, например, `{BSCONFIG_IPORT_PLUS_1}`.


* `EXEC` — контейнер считается живым, если заданная команда завершилась с нулевым кодом возврата.
* Запускаемая команда поддерживает подстановки, как и [основная команда контейнера](#command).
Также доступна настройка частоты запуска проверки живости контейнера.

![img](https://jing.yandex-team.ru/files/sshipkov/2017-06-0518-41-08.4a823bc.png)


###  Рестарт завершившихся процессов {#restart-policy}
Если между моментами запуска и завершения контейнера (с ошибкой или без неё) прошло меньше `60` секунд, то перед рестартом будет сделан перерыв, длительность которого вычисляется по формуле:

```python
jitter = random_float(0, max_jitter)
det = delay * (backoff ** fails)
result = min(det + jitter, max_period)
```

Параметры этой формулы задаются в `Container restart policy`:

![img](https://jing.yandex-team.ru/files/sshipkov/2018-07-3016-07-19.ccbb8aa.png)

Изначально `delay` равен значению из поля `Min period beetween two restarts`.
Значение `fails` это число завершений контейнера, которое обнуляется если после очередного запуска контейнер проработал больше `60` секунд.

###  Способ остановки контейнера {#stop-handler}

По умолчанию для остановки контейнера его основному процессу будет отправлен сигнал `TERM`, а затем, спустя определённый таймаут, сигнал `KILL`.
Может быть настроен другой способ остановки контейнера:

* `HTTP_GET` — для остановки контейнера будет выполнен HTTP GET запрос;
По умолчанию будет использован порт инстанса `BSCONFIG_IPORT`, однако можно указать другой порт. Поле `port` поддерживает подстановки, например, `{BSCONFIG_IPORT_PLUS_1}`.
* `EXEC` — для остановки контейнера будет выполнена указанная команда.
Запускаемая команда поддерживает подстановки, как и [основная команда контейнера](#command).
Независимо от результата выполнения команды для остановки контейнера после неё:
* В течение таймаута (секунды) `Time after pre_stop handler has been executed before sending TERM signal` не будет предпринято никаких действий;
* После этого процессу будет отправлен сигнал `TERM`;
* Спустя таймаут (в секундах) `Time after TERM signal sent before sending KILL signal`, будет отправлен сигнал `KILL`.
Для синхронизации процесса остановки контейнеров доступна опция `TERM signal barrier` с допустимыми значениями `IGNORE` и `WAIT`. Если выставить её в `WAIT`, то перед отправкой сигнала `TERM` данному контейнеру, instancectl:
* Дождётся завершения команд остановки **всех остальных** контейнеров;
* Дождётся истечения таймаута перед отправкой сигнала `TERM` остальным контейнерам.

![img](https://jing.yandex-team.ru/files/sshipkov/2017-08-1519-24-16.2aacaee.png)

###  Init-контейнеры {#init-containers}
Для выполнения действий в инстансе на стадии PREPARE необходимо описать init-контейнеры. Обычно в них выполняют действия, которые можно сделать до рестарта инстансов для сокращения суммарной длительности рестарта сервиса. Пример: распаковка архивов, создание директорий, шаблонизация конфигов.

* Все `init_containers` выполняются до запуска основных контейнеров;
* `init`-контейнеры запускаются **последовательно** в том порядке, в котором они заданы в `Instance Spec`;
* `init`-контейнер будет перезапускаться до тех пор, пока не завершится с нулевым кодом;
* Живость `init`-контейнеров никак не учитывается при вычислении статуса инстанса;
* Суммарная длительность выполнения всех `init`-контейнеров ограничивается разрешённой длительностью выполнения `iss_hook_install`;
* Запускаемая команда поддерживает подстановки.

![img](https://jing.yandex-team.ru/files/sshipkov/2017-06-0518-58-33.7b2dd9c.png)

###  Instance data volumes {#volumes}

Data volumes используются для принесения в поддиректорию инстанса данных одного из следующих типов:

* Секреты;
* ITS-ручки;
* Шаблонизированные файлы.
Пример настроенного data volume для принесения ITS-ручек в директорию `./controls`:

![img](https://jing.yandex-team.ru/files/sshipkov/screenshotfrom2019-05-1619-37-06.9eec0b1.png)

###  Notify actions {#notify-action}

Для выполнения действий при обновлении/добавлении/удалении динамических ресурсов, нужно описать список желаемых команд в поле `Actions to be taken on dynamic resources update`:

![img](https://jing.yandex-team.ru/files/sshipkov/2017-09-2511-44-27.7dbc1e0.png)

Поддержаны команды типа `HTTP_GET` и `EXEC` с подстановками переменных с помощью `{}`, например, `{BSCONFIG_IPORT}`. Команда `EXEC` поддерживает те же подстановки и будет запущена с тем же стандартным окружением, что и [обычная команда контейнера](#command).

Список изменившихся динамических ресурсов передаётся команде на вход [в виде аргументов](https://wiki.yandex-team.ru/iss3/specifications/configuration/resource/#peredachaspiskaizmenivshixsjaresursov). При использовании шеллового скрипта эти аргументы будут доступны в стандартных переменных `$@`, `$1`, `$2`, ... .

##  Как настроить {#setup}

Необходимо:

1. Переехать на версионированный InstanceCtl версии **>=1.34**: [инструкция](../reference/instance-ctl/versioned-instancectl.md);
1. Удалить из сервиса файлы `instancectl.conf` и `loop.conf`:
![img](https://jing.yandex-team.ru/files/sshipkov/2017-06-0518-16-16.fe1c8be.png)
1. Перенести описание запускаемых файлов в Instance Spec:
![img](https://jing.yandex-team.ru/files/sshipkov/2017-06-0518-19-59.dc77b4d.png)
![img](https://jing.yandex-team.ru/files/sshipkov/2017-06-0518-20-42.d11083b.png)

##  Рецепты {#recipes}
###  Описание переменных окружения в файле {#env-var-static-context}
Отдельные статические переменные окружения контейнера можно описать в Instance Spec. Но если:

* переменных окружения много
* их список должен быть одинаковым для нескольких контейнеров
* в них нужны подстановки вида `PATH=./bin:$PATH`
их может быть удобнее описать в файле:
![img](https://jing.yandex-team.ru/files/sshipkov/2017-06-0519-33-29.4333655.png)

###  Подстановки в переменных окружения {#env-var-expanding}
Бывает нужно выставить переменную окружения контейнера, содержащую значение из контекста инстанса. Пример: `MY_ADDR=0.0.0.0:{BSCONFIG_IPORT}`.
Для этого достаточно:

1. Использовать команду контейнера вида: `env MY_VAR=0.0.0.0:{BSCONFIG_IPORT} ./run.sh`.
![img](https://jing.yandex-team.ru/files/sshipkov/2017-06-0519-26-40.daf4479.png)

###  Ротация логов {#log-rotate}
Описана в отдельном документе: [HOWTO](logrotate.md).

###  Лимиты и гарантии по вычислительным ресурсам {#computing-resource-limits}
Для YP-lite и instancectl>=1.177 в переменные окружения пробрасываются:

* `CPU_LIMIT` в ядрах, пример значения `1.4972c`;
* `CPU_GUARANTEE` в ядрах, пример значения `1.4972c`;
* `MEM_LIMIT` в байтах, пример значения `3221225472`;
* `MEM_GUARANTEE` в байтах, пример значения `3221225472`.

В переменные окружения `CPU_LIMIT` и `CPU_GUARANTEE` передаются реальные значения выделенного CPU на контейнер. В YP есть два вида ядер: виртуальные и реальные. Виртуальные ядра CPU это эталонные ядра, которые указываются при заказе ресурсов. В зависимости от мощности отдельной модели процессора на конкретном сервере, виртуальные ядра умножаются на некий коэффициент (для быстрых процессоров поменьше, для слабых побольше), в результате чего и получаются реальные ядра, которые выдаются на контейнеры сервиса, попавшие на данный хост. Таким образом достигается приблизительное равенство выданной мощности CPU для контейнеров, проживающих на серверах с разной мощностью и годом выпуска процессора.

### Полезные доступные переменные окружения {#useful-env-vars}

* `BACKBONE_IP_ADDRESS` - IP-адрес текущего контейнера (если говорить более строго, то его backbone-адрес). Рекомендуется брать его именно из этой переменной окружения, а не получать через DNS. Это позволяет не делать лишних сетевых запросов и исключает шанс получения из DNS отстающих данных, соответствующих адресу контейнера до его переезда на данный хост. 
