# Запуск шардированных сервисов в YP-lite

##  О чём? {#what}
Опишем, как можно запускать шардированные сервисы в YP-lite:

1. Как можно описать распределение шардов по инстансам сервиса;
1. Как будет происходить эвакуация инстансов для уведения хостов под регламентные работы.

###  Введение {#intro}
Шардмап это файл, содержащий сопоставление инстансов шардам (схема похожа на использовавшуюся в gencfg). [Подробная документация по шардмапам](../reference/settings/shard.md#sandbox-shardmap).

Под YP-lite каждая строчка шардмапа имеет один из форматов:

1. `pod_label:<label_key>=<label_value> rbtorrent:<rbtorrent_url>`
1. `pod_label:<label_key>=<label_value> resourceless_shard_id=<some-shard-id>`

Здесь:

1. `<label_key>` это имя лейбла, в значение которого будут записываться имена шардов;
1. `<label_value>` это имя конкретного шарда;
1. `<some-shard-id>` это произвольная строка, которая будет проброшена в переменную окружения `resourceless_shard_id` в инстансе;
1. `rbtorrent:<rbtorrent_url>` это URL, который будет скачан и помещён в директорию инстанса силами ISS-агента.

###  Как завести шардированный сервис? {#how}
1. При аллокации подов в сервисе заполнить поле `Apply antiaffinity constraints to all pods with the same value of given attribute` значением `/labels/shard_id`.

    ![shards.png](https://jing.yandex-team.ru/files/sshipkov/shards.d81405e.png)

1. Аллоцировать группу подов для каждого шарда, указывая в Labels подов ключ `shard_id` и значение - идентификатор шарда. UI для этого пока нет, т.е. прямо сейчас предполагается делать много кликов.
1. Описать шардмап в указанном выше формате и положить его в sandbox. Пример:

    ```
    pod_label:shard_id=shard1 rbtorrent:e9b55e8ae33fda555c694668e9628b9f918cdfc7
    pod_label:shard_id=shard2 rbtorrent:e9628b9f918cdfc7e9b55e8ae33fda555c694668
    ...
    ```
1. Вписать в сервис аллоцированные поды и созданный шардмап.

###  Как будут переезжать поды шардированного сервиса? {#eviction}

[Подробная документация о способах переездов подов](../reference/yp/replication-policy.md).

1. Для шардированных сервисов предлагается использовать политику репликации `MOVE`, которая будет одновременно удалять старый под и создавать новый с сохранением его ID.
1. При переезде пода будет происходить изменение его IP-адреса, поэтому для сетевых запросов к инстансам такого сервиса **нельзя использовать резолвинг через DNS** за исключением целей ручной отладки.
1. Вместо DNS для получения IP-адреса пода по его ID предлагается использовать механизм YP Service Discovery.
1. Переезды инстансов в YP-lite (за исключением случая выхода из строя железа) могут происходить не чаще, чем раз в установленный пользователем промежуток времени, однако они будут инициироваться по требованию системы, т.е. без явного запроса от владельца сервиса.
1. Из предыдущего пункта следует, что клиентам, которые будут делать запросы в инстансы шардированного сервиса, необходимо поддержать их регулярный резолвинг через YP Service Discovery.

Из вышеприведённого следуют требования к клиентам шардированных инстансов.

###  Что нужно, чтобы поднять шардированный сервис в YP-lite? {#requirements}

1. Нужно настроить политику репликации таким образом, чтобы переезд разрешённого числа подов не приводил к полному даунтайму одного из шардов сервиса. Настраивается параметром `Number of pods per cluster to replace at one time`. В простейшем случае можно выставить значение 1, чтобы среди **всех** инстансов сервиса (не шарда) одновременно выполнялся бы перенос не более одного пода. [Подробно о переездах подов](../reference/yp/replication-policy.md#replication-move).
1. В клиентах шардированного сервиса нужно поддержать резолвинг инстансов через YP Service Discovery: выполнять на клиенте периодическое (без запроса извне) обновление IP-адресов инстансов, в которые он ходит. Для этого можно использовать существующую библиотеку [C++](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_service_discovery/libs/client) и [python](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_service_discovery/python/resolver).
1. Настроить частоту переноса подов параметром `Minimal time period between two sequential evictions (seconds)` так, чтобы за данный промежуток времени перенесённый под гарантированно успел бы подняться, а также клиент успел бы его разрезолвить. Nanny не начнёт перенос активного пода до того, как число мёртвых подов в сервисе не станет меньше порога из пункта (1), однако запас времени между переносами подов лучше иметь (в частности, на случай, если под стал успешно проходить status check, раньше, чем он стал реально активным).
