# HOWTO: Управление Сервисом

В этом документе описан процесс создания и выкладки нового сервиса.

## Вопросы и пожелания {#questions}

С любыми вопросами и пожеланиями можно обращаться по контактам, описанным на главной странице сервиса.

## Доступ {#access}

* [Главная страница сервиса](http://nanny.yandex-team.ru/).
* Для доступа пользователь должен иметь актуальную паспортную Cookie Session_id.

## Создание сервиса {#create-service}

При создании сервиса нужно заполнить поля:

### Id — Идентификатор {#create-service-id}

Уникальный идентификатор сервиса. Требований к именованию сервисов нет, но лучше следовать трём правилам:

1. Использовать только нижний регистр букв, для разделения использовать `_` (подчёркивание).
    Символ `-` (дефис,минус) лучше не использовать. Предыдущее поколение систем деплоя bsconfig использовало дефис как спецсимвол. Мы постарались везде это учесть, но лучше это не проверять и дефис не использовать.

    {% note tip %}

    Идентификатор сервиса используется для формирования пути на диске, если использовать только нижний регистр, то вводить пути удобнее.

    {% endnote %}

2. Примерный шаблон `<tier_type>_<service_type>_<location>_...`.
    Например, `production_setrace_msk`. Это боевая инсталляция сервиса Setrace, установлен он только в Москве.
3. Пользовательский ad-hoc сервис можно именовать по схеме `test_<login>_<service_type>`
    Например, `test_nekto0n_nanny`.

### Category — Категория {#create-service-category}

В Няне создано больше 7000 сервисов. Чтобы в них не запутаться, удобно показывать сервисы в иерархии, как файловую систему.

При создании сервиса лучше сразу его размещать в каталоге по общим правилам:

* (Боевые)/(общие тестовые) сервисы располагаются согласно условной орг. структуре:
    * `/search/sepe/`
    * `/search/mmeta/`
    * `/search/base/`
* Частные пользовательские сервисы аналогично домашним каталогам в Unix:
    * `/users/nekto0n/test_setrace_nekto0n`
* Глубина каталогов не должна превышать 3 (трёх).

### Desc — Описание {#create-service-desc}

В этом поле можно оставить любую информацию про сервис. Это полезно, чтобы потом вспомнить что же это за сервис. Например, "Production instances of setrace.yandex-team.ru".

### Comment — Комментарий первой ревизии {#create-service-comment}

Сервисы или создаются новые или копируются из существующих. Если сервис скопирован, то в это поле можно написать название родительского сервиса. По-умолчанию, подставляется строка "Initial commit".



## Главная страница сервиса {#service-page-structure}

![service](https://jing.yandex-team.ru/files/eldarguseynli/serv.jpg)

Условно страница разделена на три колонки:

* Левая — настройка инстансов (**Runtime**), метасвойства сервиса в Nanny (**Information**), настройка прав по взаимодействию с сервисом. (**Auth**)
* Центральная — текущее состояние сервиса и инструменты для выкладки/отключения.
* Правая — настройка YP подов и соответствующих им endpoint sets для данного сервиса. История производимых аллокаций подов (**YP**). Дополнительные приложения для взаимодействия с сервисом (**Refs**), Политика удаления снапшотов, соответствующим старым конфигураций инстансов (**Aspects -> Cleanup Policies**). Политика репликации подов, находящихся на умерших хостах. (**Aspects -> Replication Policies**)

## Настройка администраторов {#setup-administrators}

Управлять сервисом могут только назначенные администраторы. Управлять ими можно на странице "Administrators" в разделе "Administration" (страница расположена в левом нижнем углу основной страницы сервиса).

Автор сервиса обладает ролями:

* **Owners** — владелец сервиса.
    Владельцы сервиса могут назначать другие роли пользователям и удалять сам сервис, они имеют доступ в контейнеры сервиса. Нельзя удалить всех владельцев сервиса.

* **Operation managers** — управляющие операциями.
    Управляющие операциями могут производить выкладку и отключение сервиса, изменять информационные атрибуты, они имеют доступ в контейнеры сервиса.

* **Configuration managers** — управляющие конфигурацией.
    Управляющие конфигурациями могут изменять информационные и runtime атрибуты, они имеют доступ в контейнеры сервиса.


## Файлы сервиса {#services-files}

Каждый экземпляр сервиса (инстанс) на хосте распаковывается в каталог с набором файлов. Список файлов задается в разделе Files. Файлы скачиваются либо по HTTP(S), либо по rbtorrent: (skynet). Внутри контейнера файл сохраняется под именем из поля `Local Path`.

{% note alert %}

Нельзя сохранять файлы в подкаталоги, все файлы будут скачаны в один каталог.

{% endnote %}

### Статичный текстовый файл {#static-file}

Можно создавать и редактировать простые текстовые файлы прямо в интерфейсе Няни. Файл будет сохранён в кодировке `UTF-8`.

![https://jing.yandex-team.ru/files/altagona/browser_1HDEWFcIRD.png](https://jing.yandex-team.ru/files/altagona/browser_1HDEWFcIRD.png)


### Ресурс с одним файлом из Sandbox {#sandbox-file}

Нужно указать идентификатор ресурса из Sandbox'a или url-адрес страницы с этим ресурсом. Предпочтительный вариант для распространения файлов, т.к. протокол Torrent внутри Sandbox'a оптимизирует нагрузку на сеть.

Можно настроить [интеграцию sandbox + nanny](https://wiki.yandex-team.ru/runtime-cloud/nanny/sandbox-integration/?from=%2Fjandekspoisk%2Fsepe%2Fnanny%2Fsandbox-integration%2F), тогда при создании новой версии ресурса в sandbox, nanny будет автоматически обновлять версию ресурса.

![https://jing.yandex-team.ru/files/altagona/browser_pXWNm8UJL7.png](https://jing.yandex-team.ru/files/altagona/browser_pXWNm8UJL7.png)

{% note warning %}

При первой выкладке sandbox-ресурса Nanny закеширует его rbtorrent в собственном хранилище данных. При последующих выкладках Nanny не будет извлекать метаинформацию об этом ресурсе из sandbox [(мотивация)](https://st.yandex-team.ru/SPI-8020). Отсюда возникает side effect: при удалении ресурса из sandbox его выкладка в Nanny продолжит работать.

{% endnote %}


### Файл доступный по URL {#url-file}

Можно указать URL файла для http(s) или для rbtorrent протоколов. Не рекомендуем использовать http(s) для больших сервисов т.к. при скачивании по URL нельзя проверить целостность файла из-за отсутствия контрольных сумм. Плюс скачивание происходит не так эффективно, как при скачивании по Torrent-протоколу из Sandbox, т.к. скачивание на много хостов ведется всего с одного сервера.

Причины скачивать файл по URL:

* протестировать какую-либо тестовую сборку, доступную только с разработческой машины через skynet;
* файлы раздаются сторонним сервисом, поддерживающим только http.

![https://jing.yandex-team.ru/files/altagona/browser_Wi1kEmiPM2.png](https://jing.yandex-team.ru/files/altagona/browser_Wi1kEmiPM2.png)

### Расширенные свойства (ISS properties) {#file-iss-properties}

* `Is dynamic` — является ли ресурс динамическим [подробнее](https://wiki.yandex-team.ru/iss3/Specifications/configuration/resource/#dinamicheskijjresurs)
* `Download speed limit` — ограничение скорости скачивания ресурса [подробнее](https://wiki.yandex-team.ru/iss3/specifications/configuration/resource/#resurs)
* `Time between resource check` — период перепроверки контрольной суммы ресурса. 0d0h0m – проверить 1 раз после скачивания. Другое значение задаёт периодичность [подробнее](https://wiki.yandex-team.ru/iss3/specifications/configuration/resource/#resurs)
* `Storage for resource` — место хранения ресурса [подробнее](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howtos/move-to-ssd/#resources)
* `Is juggler bundle` — является ли ресурс juggler bundle [подробнее](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howtos/juggler-subagent/)

![nannyisspropertiesplace](_assets/nannyisspropertiesplace.png)

![nannyissproperties](_assets/nannyissproperties.png)

### Дополнительные возможности ISS properties {#extra-iss-properties}

В `ISS properties` есть возможность смонтировать ресурс в формате read-only. Под капотом ISS смонтирует новый вольюм в read-only режиме и положит в него указанный ресурс как слой.

{% note warning %}

Ресурс должен быть tar.gz-архивом, иначе ISS не сможет использовать его как слой! Для этого нужно указать значения для двух полей:
* `Mount volume mode` — для включения read-only монтирования нужно указать `Create new volume and mount in read only`.
* `Path to mount volume`  — путь, по которому нужно смонтировать вольюм.

{% endnote %}

![nannyissproperties](_assets/extranannyissproperties.png)


### InstanceСtl {#instanceсtl}

Непосредственно на хосте управлением контейнерами занимается супервизор. В qloud это [qloud-init](https://wiki.yandex-team.ru/qloud/doc/qloud-init/), в Няне это [instancectl](https://wiki.yandex-team.ru/JandeksPoisk/Sepe/instancectl/).

Когда iss-агент готовится запускать контейнер, на самом деле сначала запускается супервизор, который читает файл конфигурации и дальше сам супервизор уже запускает приложения из конфигурации Няни внутри контейнера. Супервизор отвечает за инициализацию контейнеров, установку системных свойств, взаимодействие с iss-агентом, занимается контролем работы контейнеров. В зависимости от версии instancectl меняется и поведение самого контейнера.

При создании сервиса автоматически устанавливается последняя stable-версия instancectl. Чтобы изменить её, нужно открыть `Instance Spec` сервиса и выбрать соответствующую версию.
![browser_568mBVngob.png](https://jing.yandex-team.ru/files/altagona/browser_568mBVngob.png)

Есть два способа сформировать файл с описанием контейнера для instancectl:

1. loop.conf. Устаревший plain-text формат описания. Формат файла loop.conf [описан здесь](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/).

1. [instancespec](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howtos/structured-instancectl-config-how-to/). Текущий формат описания контейнеров. В нем можно описать поведение контейнера через веб-интерфейс.
   ![https://jing.yandex-team.ru/files/altagona/browser_n1avDHwPhX.png](https://jing.yandex-team.ru/files/altagona/browser_n1avDHwPhX.png)

Также в новых сервисах автоматически настроено оповещение о новых версиях InstanceCtl. Подробнее о нём можно почитать [тут](https://wiki.yandex-team.ru/JandeksPoisk/Sepe/nanny/versioned-instancectl/#autoupdate).

## Настройка расположения инстансов {#instances-placement}

Управление, на какие хосты будет размещен сервис, осуществляется в разделе "Instances".
![uhura_2021-10-20T18%3A13%3A33.206094.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A13%3A33.206094.png)

### Генератор топологий {#topology-gen}

Все ресурсы в поисковом "облаке" распределяет "сервис", называемый **генератором топологий** или **[YP-Lite](https://wiki.yandex-team.ru/yp/)**. По факту, этот сервис совмещает в себе несколько функций:

* Учёт доступных ресурсов
* Выделение ресурсов сервисам/проектам
* Генерация конфигурационных файлов для сервисов, имеющих бекенды в том же облаке

#### Тэги инстансов {#instance-tags}

Для разметки инстансов в облаке используются тэги (также известные как `itags`, `instance_tags`). Разметку инстансов этими тэгами выполняет nanny при деплое на мощности YP. В последствии эти тэги используются для настройки мониторинга инстансов, их фильтрации и группировки. При деплое на YP тэги `itype, ctype, prj` должны быть указаны в UI сервиса.

Каждый инстанс обязательно размечен следующими тэгами:

* `itype` — Тип инстанса, программа. Например - `basesearch`, `alemateworker`, ... . Этот тэг используется [в головане](https://wiki.yandex-team.ru/golovan/faq/) для понимания того, как правильно мониторить данный тип программы (какие логи парсить, в какую HTTP-ручку стучать для сбора статистики, etc). [Подробнее про мониторинг сервиса силами голован](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howto-manage-service/#yasm-monitoring). К этому тэгу привязывается [квота по количеству метрик в головане](https://clubs.at.yandex-team.ru/solomon/680);
* `ctype` — Тип контура. Например, `prod`, `prestable`, `test`.
* `prj` — Проект, например `music`, `web`;
* `metaprj` — метапроект, позволяющий группировать инстансы нескольких проектов;
* `geo` — геолокация, заполняется автоматически силами Nanny; на данный момент возможные значения `msk`, `sas`, `man`, `vla`;
* `dc` — конкретный датацентр, в котором будет запущен инстанс, заполняется автоматически силами Nanny: например, в случае с Москвой: `iva`, `myt`.

#### Изменение rlimits {#ulimit}

Настройки rlimits, с которыми запускается контейнер, определяются следующим образом:

1. Настройки по умолчанию заданы в конфиге iss-agent;
2. Для сервисов под gencfg эти настройки (все или только их часть) можно переопределить в UI сервиса в Nanny.

    ![uhura_2021-10-20T18%3A14%3A01.791896.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A14%3A01.791896.png)

    ![browser_2wFvRqEDEO.png](https://jing.yandex-team.ru/files/altagona/browser_2wFvRqEDEO.png)

3. **Для сервисов под YP-lite** rlimits **уже задраны** на стороне Nanny и силами пользователя их настроить нельзя. Текущие значения вхардкоженные в коде Nanny: `memlock: 549755813888 549755813888; nofile: 102400 1000000;`. Если вам по каким-то причинам не хватает этих значений, пожалуйста, обратитесь в [команду разработки Nanny](https://abc.yandex-team.ru/services/SR).

#### Переопределение sysctl в контейнерах {#sysctl}

В porto есть возможность переопределения значений sysctl в контейнере.
`portoctl exec b net="L3 vlan688" sysctl="net.core.somaxconn:4000;net.ipv4.tcp_retries2:80"`
Требуется изоляция по сети (use_mtn) и изоляция файловой системы (chroot).

![browser_EJyQxOXQxx.png](https://jing.yandex-team.ru/files/altagona/browser_EJyQxOXQxx.png)

##### Список разрешенных параметров {#allowed-params}

Можно переопределить:

* параметр, указанный в whitelist
* параметр, c префиксом из prefix_whitelist, не содержащийся при этом в prefix_blacklist
    Актуальный список можно получить в UI (иконка справа от Sysctl params)

```json
{
    "prefix_blacklist": ["net.ipv4.neigh.default.", "net.ipv6.neigh.default."],
    "whitelist": [
        "net.core.somaxconn",
        "net.unix.max_dgram_qlen",
        "net.ipv4.icmp_echo_ignore_all",
        "net.ipv4.icmp_echo_ignore_broadcasts",
        "net.ipv4.icmp_ignore_bogus_error_responses",
        "net.ipv4.icmp_errors_use_inbound_ifaddr",
        "net.ipv4.icmp_ratelimit",
        "net.ipv4.icmp_ratemask",
        "net.ipv4.ping_group_range",
        "net.ipv4.tcp_ecn",
        "net.ipv4.tcp_ecn_fallback",
        "net.ipv4.ip_dynaddr",
        "net.ipv4.ip_early_demux",
        "net.ipv4.ip_default_ttl",
        "net.ipv4.ip_local_port_range",
        "net.ipv4.ip_local_reserved_ports",
        "net.ipv4.ip_no_pmtu_disc",
        "net.ipv4.ip_forward_use_pmtu",
        "net.ipv4.ip_nonlocal_bind",
        "net.ipv4.tcp_mtu_probing",
        "net.ipv4.tcp_base_mss",
        "net.ipv4.tcp_probe_threshold",
        "net.ipv4.tcp_probe_interval",
        "net.ipv4.tcp_keepalive_time",
        "net.ipv4.tcp_keepalive_probes",
        "net.ipv4.tcp_keepalive_intvl",
        "net.ipv4.tcp_syn_retries",
        "net.ipv4.tcp_synack_retries",
        "net.ipv4.tcp_syncookies",
        "net.ipv4.tcp_reordering",
        "net.ipv4.tcp_retries1",
        "net.ipv4.tcp_retries2",
        "net.ipv4.tcp_orphan_retries",
        "net.ipv4.tcp_fin_timeout",
        "net.ipv4.tcp_notsent_lowat",
        "net.ipv4.tcp_tw_reuse",
        "net.ipv6.bindv6only",
        "net.ipv6.ip_nonlocal_bind",
        "net.ipv6.icmp.ratelimit",
        "net.ipv6.route.gc_thresh",
        "net.ipv6.route.max_size",
        "net.ipv6.route.gc_min_interval",
        "net.ipv6.route.gc_timeout",
        "net.ipv6.route.gc_interval",
        "net.ipv6.route.gc_elasticity",
        "net.ipv6.route.mtu_expires",
        "net.ipv6.route.min_adv_mss",
        "net.ipv6.route.gc_min_interval_ms"
    ],
    "prefix_whitelist": [
        "net.ipv4.conf.",
        "net.ipv6.conf.",
        "net.ipv4.neigh.",
        "net.ipv6.neigh."
    ]
}
```

## Частота проверки живости инстанса {#instance-status-frequency}

Живость инстанса проверяется по схеме:

1. [instancectl](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/) с определённой частотой выполняет проверку живости инстанса и запоминает вычисленное состояние инстанса. Проверка живости инстанса выполняется одним из двух способов в зависимости от настройки сервиса:

    * При использовании `instancectl.conf`: используя [параметр status_script](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/#instance-status-computation) — тогда частота проверки живости настраивается [соответствующими параметрами конфига](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/#instancectl-status-check-frequency);

    * При использовании контейнеров в Instance Spec: используя соответствующие [настройки в UI](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howtos/structured-instancectl-config-how-to/#readiness).

2. ISS-агент на хосте **с другой настраиваемой частотой** запускает `iss_hook_status`, который запрашивает состояние инстанса у instancectl и завершается с соответствующим кодом выхода. Частота запуска `iss_hook_status` [настраивается в UI](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howto-manage-service/#iss-hooks-frequency) так же, как и у других хуков. Значения по умолчанию для частоты запуска `iss_hook_status`:

    ```
    min_restart_period: 30
    max_restart_period: 60
    restart_period_backoff: 2
    max_execution_time: 1800
    restart_period_scale: 1
    ```


    {% note info %}

    Не следует выставлять частоту рестарта `iss_hook_status` слишком высокой. Например, если выставить `max_restart_period = 5` секунд, то:

    * Если на машине нет активной выкладки, то `iss_hook_status` будет запускаться всё равно **раз в минуту**;
    * Даже если на хосте идёт активная выкладка, достаточно высокая частота (например, 5 секунд) недостижима из практических соображений: есть накладные расходы на создание контейнеров, выполнение синхронизации и т.п. и бороться с ними не целесообразно, т.к. на практике нет никакой необходимости так часто вычислять статус, вместо этого нужно использовать правильно настроенные экспоненциально растущие перерывы;
    * Приведёт к бессмысленному расходу CPU и прочим лишним операциям.

    {% endnote %}

## Частота запуска ISS хуков {#iss-hooks-frequency}

Настраивается через UI:

![browser_pCYPhuuIg8.png](https://jing.yandex-team.ru/files/altagona/browser_pCYPhuuIg8.png)

## Настройка рецептов {#recipes-config}

Выкладка сервиса делится на 3 этапа:

* создание "конфигурации" (которая соответствует ревизии сервиса) в системе выкладки
* подготовка "конфигурации" на машинах (стадия `PREPARE`)
* активация "конфигурации" на машинах (стадия `ACTIVATE`)

    Все стадии делегированы сервису Кубики (Alemate). Описание процесса - это рецепт в терминах alemate. Рецепт в свою очередь оперирует конфигурацией в понятиях CMS/bsconfig (в дальнейшем ISS). Стадия создания конфигурации не доступна для кастомизации пользователям. Остальные - доступны.

Для выкладки вам понадобится 1 или 2 рецепта. Возможны следующие варианты:

1. Рецепт, который занимается одновременно и подготовкой и активацией конфигурации.

2. Рецепты разделены: один занимается подготовкой, другой - активацией.
   При выборе любого варианта, рецепт, запускаемый Системой, должен соотвествовать соглашению, описанному [здесь](https://wiki.yandex-team.ru/runtime-cloud/nanny/service-repo-design/#configuration-prepare-activate).
   Для первого вариант для удобства создан универсальный рецепт, который подойдёт большинству пользователей - [\_activate_service_configuration.yaml](http://nanny.yandex-team.ru/ui/#/alemate/recipes/_activate_service_configuration.yaml/). Его надо указать в списке "Activate Recipes". Prepare Recipes при этом **нужно** не указывать.
   **Во втором** варианте необходимо указать 2 рецепта: один в разделе "Activate Recipes", другой - "Prepare Recipes". Так же, для удобства, созданы 2 рецепта, которые подойдут большинству пользователей: [\_repo_prepare_snapshot.yaml](http://nanny.yandex-team.ru/ui/#/alemate/recipes/_repo_prepare_snapshot.yaml/) и [\_repo_activate_snapshot.yaml](http://nanny.yandex-team.ru/ui/#/alemate/recipes/_repo_activate_snapshot.yaml/).

Для добавления рецепта переходим в раздел "Recipies", нажимаем на кнопку "Add" и описываем рецепт(ы).
![https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A11%3A58.150351.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A11%3A58.150351.png)

* Identifier
    Уникальное название рецепта и его параметров (контекста) в рамках данного сервиса. Предполагается, что мы можем использовать один и тот же рецепт с разными настройками. Например, "common" и "fast". Этот идентификатор будет использоваться в дальнейшем при нажатии кнопки "Deploy".

* Recipe filename
    Название файла рецепта. Например, описанный выше `_activate_service_configuration.yaml`.

* Short description
    Человеко читаемое описание, например, `Common deploy script`.

* Recipe context
    Параметры, которые необходимо прокинуть в рецепт.
    Т.к. рецепты находятся в разделе информационных атрибутов (блок **Information**), то для сохранения изменений необходимо нажать соотвествующую кнопку "Save" и описать изменения.

## Настройка политики очистки старых конфигураций {#cleanup-policy-setup}

Каждая ревизия (snapshot) runtime атрибутов при выкладке порождает конфигурацию в системе выкладки (CMS/ISS). После очередного обновления сервиса, текущая активная конфигурация переводится в состояние `PREPARED`, т.е. остаётся как на машинах, так и в CMS/ISS. Эта картина отражена на главной странице сервиса в виде списка конфигураций. Для того, чтобы пользователям не приходилось вручную удалять старые конфигурации (которых в день может быть несколько десятков) созданы [политики очистки старых конфигураций](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/cleanuppolicy/).

## Настройка shard'а {#shard-settings}

### Что это такое {#what-is-shard}

Shard (шард) — это понятие системы выкладки (т.е. bsconfig).
Прямое назначение шарда - это хранение и распространение куска поисковой базы. Так у каждого инстанса базового может быть разный шард.
Каждый инстанс сервиса может иметь 1 _шард_. На диске шард представляет собой каталог и (опционально) скрипт, который необходимо запустить для установки шарда (например, распаковать какие-либо файлы). Ввиду ограничений системы, (почти) единственный способ доставить для инстанса каталог - это:

* Позвать на каталоге команду `bsconfig shard_init` (например, при сборке в Sandbox).

* Указать его в качестве шарда для требуемого инстанса.
    Система поддерживает такой механизм, позволяя для удобства указывать атрибуты ресурса в Sandbox, которые она самостоятельно преобразует в нужный идентификтор шарда и укажет системе выкладки доставить его на машину при подготовке инстанса.

Рассмотрим доступные типы шардов, которые можно назначить сервису. Все изменения в UI производятся на странице Shard. После изменения необходимо нажать кнопку Save в разделе Runtime.
![https://jing.yandex-team.ru/files/altagona/browser_Q0BXILu1cs.png](https://jing.yandex-team.ru/files/altagona/browser_Q0BXILu1cs.png)

#### Локальный путь к шарду {#shard-local-path}

При использовании bsconfig в качестве системы выкладки шард всегда находится в определённом каталоге, вне каталога инстанса. Например, `/db/BASE/primus-Tur0-8-23-1431890942`. Это позволяло использовать один шард в нескольких инстансах.
При использовании ISS в качестве системы выкладки шард - это тип ресурса, который вместе с остальными проецируется (через символьные ссылки) в каталог инстанса. Путь можно указать в поле **Local path**. При использовании bsconfig это поле будет игнорироваться.

### Ресурс Sandbox — SANDBOX_SHARD {#sandbox-shard}

В выпадающем списке выбираем `SANDBOX_SHARD` и с помощью интерактивной подсказки указываем нужные параметры:

* Task Type — типа задачи в Sandbox
* Task Id — идентификатор задачи (предлагается выбор из нескольких самый свежих)
* Resource type — тип ресурса задачи (задача может породить несколько ресурсов)

    {% note alert %}

    Система рассчитывает, что при выполнении кода задачи шард был проинициализирован в выбранной системе выкладки - Bsconfig или ISS.

    {% endnote %}

### Идентификатор шарда — REGISTERED_SHARD {#registered-shard}

Позволяет указать произвольный идентификатор шарда, созданный не в Sandbox. Система рассчитывает, что шард был создан пользователем самостоятельно.

### Ресурс Sandbox с shardmap'ом — SANDBOX_SHARDMAP {#sandbox-shardmap}

Shardmap - в поиске это способ описать поколение поисковой базы. В общем виде содержит список строк вида:

```
<instance_info> <shard_info> < [...] shard_tags>
```

1. Instance info может быть как парой хост:порт, так и виртуальным шардом:

    * Если в начале идёт указание `host_port`, то структура должна быть `host_port:<host>:<port>`
    * Если в начале идёт указание `pod_id`, то структура должна быть `pod_id:<pod_id>`
    * Если в начале идёт указание `pod_label`, то структура должна быть `pod_label:<label_key>=<label_value>`
    * В остальных случаях весь `<instance_info>` воспринимается как virtual shard (виртуальный шард — идентификатор шарда без указания поколения базы).
    
    Примеры:

    ```
    host_port:vla1-1414.search.yandex.net:2184
    pod_id:kggwuqefk6zlmfgq
    pod_label:awesome_label=some_value
    imgfidx-000-00000000-000000
    ```
    
2. Shard info может быть указан или с помощью rbtorrent_url, или как shard_id из шардтрекера (идентификатор шарда в указанном поколении базы). Также это может быть resourceless_shard_id, который не приносит ресурc на машину, а служит только для разметки.

    * Если в начале идёт `rbtorrent`, то структура должна быть `rbtorrent:<rbtorrent_url>`

       Также можно опционально указать local path файла: `rbtorrent:<rbtorrent_url>(local_path=<local_path>)`

    * Если в начале идёт `resourceless_shard_id`, то структура должна быть `resourceless_shard_id=<id>`.

    * В остальных случаях `<shard_info>` воспринимается как `shard_id`.
    
    В этом случае также опционально можно указать source_host: `<shard_id>(srchost=<source_host>)`
    
    Примеры:

    ```
    rbtorrent:12345567789sdf
    rbtorrent:agfosi87235jbh(local_path=some_local_path)
    resourceless_shard_id=not_a_resource_1
    primus-Rus-1-3-5-1431890942
    imgfidx-000-20151015-151602(srchost=pi00)
    ```

3. Shard tags состоит из любого количества тэгов, разделенных пробелами. Тэг шарда — это строка, описывающая тип шарда (например, шард турецкой базы).

## Управление состоянием сервиса на машинах {#service-state-management}

Состояние сервиса на кластере можно описать набором кортежей `(snapshot_id, current_state, target_state)`:

* **snapshot_id** — идентификатор ревизии runtime атрибутов;
* **current_state** — текущее состояние ревизии на машинах;
* **target_state** — целевое состояние ревизии на машинах.

![https://jing.yandex-team.ru/files/altagona/browser_atht0SKwjp.png](https://jing.yandex-team.ru/files/altagona/browser_atht0SKwjp.png)

### Целевое состояние {#service-target-state}

Существуют следующие целевые состояния:

* **DESTROYED** - ревизия не должна присутствовать на хостах и в системе выкладки (CMS/ISS).
    Это состояние используется только в командах API, в результате выполнения команды ревизия удаляется из набора кортежей целевого состояния.

* **CREATED** - ревизия должна быть создана в системе выкладки (CMS/ISS).
    
    На практике это означает приводит к следующим действиям:
    
    * Генерируется конфигурация в терминах CMS/ISS, если ещё не создана.
    * Если конфигурация приготовлена на машинах, в CMS/ISS отдаётся команда, что конфигурация на машинах не требуется. Агенты на машинах могут её удалить в случае необходимости.

* **PREPARED** - ресурсы ревизии должны присутствовать на хостах.
    Это состояние включает в себя состояние **CREATED**, т.е. сначала конфигурация будет создана, затем подготовллена.

* **ACTIVE** - инстансы этой ревизии должны быть активны на хостах
    В этом состоянии может находиться только одна ревизия (snapshot). При переводе ревизии в это состояние, текущая активная неявно переводится в состояние **PREPARED**.

### Текущее состояние {#service-current-state}

Существуют следующие текущие состояния:

* **GENERATING** - создаётся конфигурация в CMS/ISS

* **ACTIVATING** - конфигурация активируется на хостах.
    В этом состоянии может находится только одна ревизия.

* **DEACTIVATING** - конфигурация деактивируется.

* **ACTIVE** - конфигурация активна.
    Т.к. в общем случае в один момент времени могут быть активны инстансы разных ревизий (если несколько выкладок подряд не завершались успехом), то для избежания разночтений в этом состоянии может находится только одна ревизия.

* **BROKEN** - (так же PARTIALLY_ACTIVE) конфигурация может быть активна на части инстансов.
    Возникает, когда одна выкладка/активация была прервана. Например, таскгруппа активации завершилась аварийно, либо новая ревизия была активирована в процессе.

* **PRERARING** - конфигурация подготовливается на хостах.

* **PARTIALLY_PREPARED** - конфигурация может быть подготовлена на части инстансов.
    Возникает, когда одна выкладка/активация была прервана. Например, таскгруппа активации завершилась аварийно, либо новая ревизия была активирована в процессе.

* **PREPARED** - конфигурация была подготовлена на хостах.

* **REMOVING** - конфигурация удаляется с хостов.
    В CMS/ISS с инстансов снимается флаг PREPARED.

* **DESTROYING** - конфигурация удаляется из CMS/ISS

* **PARTIALLY_CREATED** - конфигурация может быть частично создана в CMS/ISS.
    На практике такое может быть только с CMS. Конфигурация в ISS создаётся атомарно.

* **CREATED** - конфигурация создана в CMS/ISS.
    При этом на хостах ресурсов для конфигурации нет (может не быть).

* **DEACTIVATE_PENDING** - (служебное) Конфигурация неявно деактивируется активацией другой ревизии.
    Это служебное состояние указывает внутреннему автомату системы, что действий предпринимать не надо.
    В этом состоянии может находиться **несколько** ревизий, в случае если несколько выкладок подряд не были доведены до конца.
    После активации это текущее состояние сменится на **BROKEN** и будет запущен процесс деактивации.

* **DESTROYED** - (служебное) Конфигурация удалена из CMS/ISS.
    Используется внутри системы, пользователи не должны видеть.

* **ACTIVATION_MUST_BE_CANCELLED** - (служебное) Активация должна быть отменена и переведа в состояние **DEACTIVATE_PENDING**.
    В API не используется, пользователям не возвращается, в базу не сохраняется.

### Управление состояниями через UI {#service-states-ui}

Обладая описанными выше знаниями про модель состояний сервиса можно перейти к её управлению.
В UI на главной странице представлены ревизии сервиса и их состояния:

![https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A10%3A12.165138.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A10%3A12.165138.png)

Каждый элемент списка ревизий отображает следующую информацию:

* Верхняя строчка: информация о ревизии (snapshot'е): идентификатор, автор, дата, комментарий. **У старых ревизий** эти поля могут отсутствовать.
* Левый столбец: информация о текущем состоянии: время, таскгруппа, конфигурация.
* Центральный столбец: информация о целевом состоянии: дата, автор изменений, (опционально) тикет.
* Правый столбец: Кнопки действий над snapshot'ом.

Рассмотрим пример.

* Первой в списке всегда отображается текущая ревизия runtime атрибутов. В данном примере конфигурация не создана, на хостах не присутствует, поэтому поля _current_ и _target_ пусты.
* Вторым в списке на скриншоте представлен текущий активный.

    Кнопка действий над текущим активным снэпшотом недоступна. Для отключения сервиса можно воспользоваться кнопкой "Stop service" вверху страницы. Для активации другого snapshot'а, надо **явно** активировать другой. Такой подход к UI может быть не очень удобным, но позволяет минимизировать ошибки оператора.

* Третьим в списке представлен снэпшот, который в данный момент помечен как **PREPARED** на хостах.

**Целевое** состояние снэпшота можно изменить по клику на кнопку "Change". После клика откроется следующее диалоговое окно.

![https://jing.yandex-team.ru/files/altagona/browser_s0zRIXuSLp.png](https://jing.yandex-team.ru/files/altagona/browser_s0zRIXuSLp.png)

В нём можно выбрать новое целевое состояние снэпшота и нажать "Apply". После этого на сервер отправится команда, которая будет сохранена в очереди и затем асинхронно обработана.

### Управление состояниями инстансов {#instance-states-ui}

У ревизии сервиса можно посмотреть список инстансов (**1**). У каждого инстанса указано текущее(**2**) и целевое(**3**) состояние. Целевое состояние можно поменять, нажав на кнопку с изображением шестеренки (**4**).

![https://jing.yandex-team.ru/files/altagona/browser_oemX6lxWFg.png](https://jing.yandex-team.ru/files/altagona/browser_oemX6lxWFg.png)

Откроется диалоговое окно.

![https://jing.yandex-team.ru/files/altagona/browser_77k2Y8zsrA.png](https://jing.yandex-team.ru/files/altagona/browser_77k2Y8zsrA.png)

В нем можно выбрать новое целевое состояние инстанса и нажать "Apply".
Есть следующие ограничения:

* Состояние всей ревизии при этом отслеживаться Няней не будет. Т.е. если пользователь перевёл руками все инстансы из состояния `PREPARED` в `ACTIVE`, то Няня по-прежнему будет отображать состояние всей ревизии как `PREPARED`.
* При выкладке/откате ручные изменения теряются.

### Ограничения в управлении состояниями YpLite-инстансов {#instance-states-yplite-restrictions}

Инстансы **YpLite**-сервисов могут находиться в состоянии `UNKNOWN` -> `UNKNOWN`.

![browser_IRW6NJZ9bd.png](https://jing.yandex-team.ru/files/altagona/browser_IRW6NJZ9bd.png)

Это значит, что в инстансах ещё нет необходимой конфигурации, поэтому выполнять действия над ними ещё нельзя. В таком состоянии инстансы находятся до тех пор, пока на них не начала выполняться стадия `PREPARING` или `ACTIVATING`.

Это поведение можно поменять — тогда конфигурация в инстансы будет приноситься ещё до стадии `PREPARING`/`ACTIVATING`. Для этого есть флаг `Fill pods configuration`, который можно выставить при переводе снэпшота в состояние `Present in YP/ISS only`.

![https://jing.yandex-team.ru/files/altagona/browser_Ds2ZGHikVQ.png](https://jing.yandex-team.ru/files/altagona/browser_Ds2ZGHikVQ.png)

### Подробнее про текущие состояния инстансов {#iss-states-definitions}

| **Старое название**                                  | **Новое название**                     | **Описание**                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ---------------------------------------------------- | -------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| **`ACTIVE`**                                         | **`Active`**                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`PREPARED`**                                       | **`Prepared`**                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`REMOVED`**                                        | **`Removed`**                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **Сборка инстанса**                                  |                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`ENTITY_RESOURCES_NOT_READY`**                     | **`Downloading`**                      | В процессе скачивание файловых ресурсов, слоёв файловой системы и других запчастей инстанса.                                                                                                                                                                                                                                                                                                                                                           |
| **`DOWNLOAD_FINISHED`**                              | **`Downloaded`**                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`ISS_HOOK_INSTALL_JUST_SCHEDULED`**                | **`Install scheduled`**                |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`ISS_HOOK_INSTALL_IN_PROGRESS`**                   | **`Installing`**                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`SHARD_SETUP_SUCCESS`**                            | **`Shard installed`**                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`RESOURCE_CHECKSUM_INVALID`**                      | **`Invalid checksum`**                 | Не сошлась чексумма одного из скачанных ресурсов.                                                                                                                                                                                                                                                                                                                                                                                                      |
| **Запуск инстанса**                                  |                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`SLOT_LOCKED`**                                    | **`Pending`**                          | Ожидаем выключения старой конфигурации инстанса, чтобы запустить текущую новую. Например, в предыдущей конфигурации выполняется `stop_script` или `Stop Policy`, как только они завершатся, мы начнём запускать новую конфигурацию.                                                                                                                                                                                                                    |
| **`HOOK_SEMI_FAILED`**                               | **`Activating`**                       | Контейнеры инстанса созданы, instancectl запущен, но внутри контейнеров пока не удалось корректно запустить пользовательские процесы. Популярные причины: 1) падает один из запускаемых процессов пользователя; 2) Все процессы запущены, но не может успешно завершиться проверка живости инстанса или `status_script`                                                                                                                                |
|                                                      |                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`PREVENT_STARTING_DAEMON_ON_BANNED_NODE `**        |                                        | Означает, что ноду забрали в работу, поэтому система забанила её. Как вариант, подождать пока она вернётся в строй. Возможно в wall-e есть дополнительная информация.                                                                                                                                                                                                                                                                                  |
| **`DAEMON_EXITED`**                                  | **`Exited`**                           | instancectl завершился. Это происходит как в случае штатного выключения инстанса, так и из-за проблем с инстансом, вызвавшим завершение instancectl, например, если из-за проблем с porto был разобран контейнер инстанса.                                                                                                                                                                                                                             |
| **`DAEMON_CANCELLED`**                               | **`Cancelled`**                        | Запуск инстанса был отменён. Например, запуск конфигурации был отменён в пользу более свежей конфигурации.                                                                                                                                                                                                                                                                                                                                             |
| **Общие статусы**                                    |                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`DAEMON_WAS_TERMINATED_EXTERNALLY`**               | **`Killed`**                           | Контейнер инстанса был убит внешним сигналом. В большинстве случаев это OOM, т.е. убийство контейнера из-за превышения лимита потребляемой памяти.                                                                                                                                                                                                                                                                                                     |
| **`PORTO_CONSTRAINTS_ERROR`**                        | **`Resource overcommit`**              | Поселенным на хост инстансам роздано ресурсов больше, чем на хосте есть по факту, из-за чего не удаётся собрать контейнер инстанса.                                                                                                                                                                                                                                                                                                                    |
| **`UNKNOWN`**                                        | **`Unknown`**                          | Информации о состоянии инстанса нет. В большинстве случаев это означает, что с хоста, где был запущен инстанс, давно не поступало никакой информации. Возможные причины: 1) хост выключен 2) хост находится в неуправляемом состоянии из-за проблем с железом или операционной системой или критичной поломкой ISS-agent                                                                                                                               |
| **`HOOK_FAILED`**                                    | **`Failing`**                          | Некорректно завершился хук инстанса. В большинстве случаев это проблема на `PREPARE`-фазе: 1) Не отрабатывает init-контейнер или `prepare_script`; 2) Не удалось извлечь секреты, указанные в сервисе: они удалены из секретницы или в секрете не выдан доступ на сервис в случае Nanny Vault                                                                                                                                                          |
| **`HOOK_IN_PROGRESS`**                               | **`Hook in progress`**                 | Идёт исполнение одного из хуков инстанса, например, `iss_hook_stop` для остановки инстанса, или `iss_hook_uninstall` для его разбора.                                                                                                                                                                                                                                                                                                                  |
| **`HOOK_CANCELLED`**                                 | **`Hook cancelled`**                   | Исполнение одного из хуков инстанса было отменено (в контейнер хука прилетел SIGKILL). Например, после начала `PREPARE`-фазы она была отменена.                                                                                                                                                                                                                                                                                                        |
| **`TIME_LIMIT_VIOLATION`**                           | **`Timed out`**                        | Превышено время выполнения одного из хуков. В большинстве случаев это означает один из вариантов: 1) превышено время выполнение init-контейнера или `prepare_script` 2) не удалось извлечь секреты, указанные в сервисе: они удалены из секретницы или в секрете не выдан доступ на сервис в случае Nanny Vault 3) проблема с выполнением одного из хуков или instancectl из-за того, что хост-машина перегружена или не хватает ресурсов в контейнере |
| **`INVOCATION_FREQUENCY_LIMIT`**                     | **`Retrying`**                         | Предыдущий запуск хука (или другого рутинного действия) закончился неуспешно, выжидаем перерыв перед следующим повтором действия или запуска хука.                                                                                                                                                                                                                                                                                                     |
| **Обновление динамических ресурсов**                 |                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`ACTIVATED_INSTANCE_DYNAMIC_RESOURCES_NOT_READY`** | **`Downloading dynamic resource`**     | Инстанс запущен и идёт скачивание динамических ресурсов.                                                                                                                                                                                                                                                                                                                                                                                               |
| **`NOTIFY_HOOK_FAILURE_STATE_INTERCEPTED`**          | **`Notify failed`**                    | Некорректно завершился `notify_script` или `Notification action`, они будут перезапущены до тех пор, пока не завершатся успешно.                                                                                                                                                                                                                                                                                                                       |
| **`DYNAMIC_RESOURCE_NOTIFY_EXECUTION`**              | **`Notifying`**                        | В процессе выполнения `notify_script` или `Notification action`.                                                                                                                                                                                                                                                                                                                                                                                       |
| **`DYNAMIC_RESOURCE_PREPARATION_FAILURE`**           | **`Dynamic resource prepare failed `** | Не удалось вмонтировать скачанные динамические ресурсы в контейнер инстанса.                                                                                                                                                                                                                                                                                                                                                                           |
| **Проблемы с хостовой инфраструктурой**              |                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`PORTO_FAILURE`**                                  | **`Porto failure`**                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`PORTO_UNAVAILABLE`**                              | **`Porto unavailable`**                |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`SKYNET_FAILURE`**                                 | **`Skynet failure`**                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`SKYNET_TIMEOUT`**                                 | **`Skynet timeout`**                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **`VOLUME_LINKING_FAILED`**                          | **`VOLUME_LINKING_FAILED`**            | Не удалось выполнить запрос к Porto примонтировать вольюм к контейнеру                                                                                                                                                                                                                                                                                                                                                                                 |

### Управление реакциями на события {#service-pause-resume}

Каждое изменение состояния сервиса обрабатывается асинхронно и может быть описано следующим алгоритмом:

* Сохранение события в базе данных.
* Обработка события: пересчёт текущего и/или целевого состояния ревизий (snapshot'ов) сервиса на хостах.
* Выполнение действий для приведения сервиса к целевому состоянию: запуск, останов рецептов.

    Система поддерживает возможность установить сервис "на паузу", при этом все события будут обрабатываться, но действия выполняться не будут, до получения события "продолжить выполнение действий". Управление данным функционалом осуществляется через UI:

    ![service_pause](https://wiki.yandex-team.ru/runtime-cloud/nanny/howto-manage-service/.files/service_pause_resume.png)

* Если сервис установлен "на паузу", то будет доступна кнопка "Resume actions", а информация о постановке "на паузу" будет отображаться рядом с текущим состоянием сервиса.
* Если сервис реагирует на события, то будет доступна кнопка "Pause actions".

{% note alert %}

Авторизация: выполнять указанные действия могут пользователи с ролью `operations manager`.

{% endnote %}

### Отключение сервиса {#stop-service}

Если сервис находится в любом состоянии, кроме Offline, то при клике на кнопку "Stop service" на главной странице - Система поставит в очередь событие с требованием отключить сервис. Для текущего активного снэпшота будет выставлено целевое состояние **PREPARED**. При этом все активные snapshot'ы будут деактивированы с помощью зашитого в исходном коде рецепта. Все таскгруппы alemate, которые выполняют действия над этим snapshot'ом - будут отменены.

## Удаление сервиса {#service-removal}

**Владелец** сервиса может его удалить, нажав на кнопку **Remove Service** в разделе **Administration**. При этом к сервису выдвигаются следующие требования:

* Сервис при этом должен находиться в состоянии Offline.
    Перед удалением сервис необходимо отключить. Например, кнопкой "Stop service".

* Ревизий сервиса не должно быть на хостах и в системе выкладки (CMS/ISS).
    Все ревизии необходимо удалить. Например, в UI у каждого выбрать "Change" -> "Removed Completely". После этого дождаться окончания процесса удаления.

* Сервис не должен быть прописан в l7fast или сервисном балансере.
    В настройках балансеров необходимо удалить все связанные с удаляемым сервисом записи.
    Если какой-то из указанных пререквизитов не выполняется - система сообщает об ошибке и удаление не производится.

Ревизии сервиса удалены не будут. Есть возможность пересоздать сервис с тем же идентификатором заново - все предыдущие ревизии сервиса будут доступны в его истории. Удаление сервиса удаляет его основную запись, вся история при этом сохраняется. Это мера защиты от случайного удаления такого критичного компонента.

{% note alert %}

Если необходимо удалить сервис, оставив его конфигурации на хостах и/или в системах выкладки, то данная процедура может быть выполнена вручную администраторами Nanny после письма на рассылку [nanny@](https://staff.yandex-team.ru/nanny).

{% endnote %}

## Изменение текущего снэпшота при активации (HEAD) {#set-as-current}

В модели снэпшотов nanny присутствует понятие **HEAD** (**current**) снэпшота. HEAD это:

1. Указатель на снэпшот, поверх содержимого которого будут применяться изменения, вносимые в UI;
1. Это **не обязательно активный** снэпшот;
1. При создании нового снэпшота он автоматически помечается как **HEAD**;
1. По умолчанию при активации снэпшота он **не помечается** как **HEAD**.

Логику пункта (4) можно поменять, воспользовавшись флажком `Set snapshot as current upon activation` в `Info attrs` сервиса. Если установить этот флажок (выставить в `true`), то при старте активации снэпшота он автоматически будет помечен как **HEAD**.

## Мониторинг через yasm/golovan {#yasm-monitoring}

[Основной HOWTO для настройки мониторинга](https://wiki.yandex-team.ru/golovan/golovan-howto/).
[Я всё сделал, но у меня нет сигналов, что делать?!](https://wiki.yandex-team.ru/golovan/no-signals-checklist/)

Ниже описаны шаги, необходимые для мониторинга через yasm (golovan):

1. Метрик потребления ресурсов инстансами: CPU, RAM, network, etc.

2. С помощью [unistat-ручки](https://wiki.yandex-team.ru/golovan/stat-handle/#format) и числа возвращаемых сигналов **меньше 1000**;

3. С помощью [unistat-ручки](https://wiki.yandex-team.ru/golovan/stat-handle/#format) и произвольного числа возвращаемых сигналов (на самом деле есть некая большая константа в головане, в которую вы вряд ли упрётесь).

Ключевой момент в настройке мониторинга — выбор `itype` и `prj` инстанса. `itype` определяет способ, которым yasm-agent на конкретном хосте кластера будет получать метрики инстанса. Возможные варианты того, что может делать yasm-agent: собирать метрики потребления контейнера, обращаться к unistat-ручке инстанса по HTTP, парсить логи инстанса и т.п. Типичные значения для `itype`: `mongo`, `zookeeper`, `basesearch`, т.е. обычно это типы программ.

При деплое на YP_LITE `itype` указывается в сервисе Nanny. Если вам достаточно мониториться дефолтным способом (через [стат-ручку](https://wiki.yandex-team.ru/golovan/stat-handle/) с количеством сигналов не более 1000 или [push api](https://wiki.yandex-team.ru/golovan/push-api/) + стандартные метрики потребления ресурсов контейнером), то больше ничего делать не надо. В противном случае необходимо завести в [репозитории голована](https://bb.yandex-team.ru/projects/SEARCH_INFRA/repos/yasm/browse/CONF/) конфиг с настройками вашего мониторинга (подробнее про его формат - [здесь](https://doc.yandex-team.ru/Search/golovan-quickstart/concepts/agent-config.html)).

Важно помнить, что при наличии нескольких инстансов с одинаковыми значениями всех тэгов `itype`, `ctype`, `prj` и других на одном хосте, значения их сигналов будут сагрегированны (например, просуммированы) и посмотреть их по отдельному инстансу не удастся, т.к. yasm обязательно агрегирует все сигналы при совпадении всех тэгов. Поэтому для того, чтобы избежать склеивания значений своих сигналов с соседями, достаточно указать своё уникальное значение тэга `prj`, чтобы сигналы инстанса гарантированно не были сагрегированны с сигналами соседей, у которых выставлено дефолтное значение `prj = none`.

### Мониторинг потребления ресурсов контейнером через yasm/golovan {#yasm-monitoring-container}

Рядом с инстансом нажать ссылку YASM что бы увидеть графики потребления ресурсов.

### Мониторинг с помощью unistat с малым числом сигналов {#yasm-monitoring-rtcsmall}

Если вас не интересует никакой мониторинг кроме потребления ресурсов и unistat-ручки или посылки сигналов через push api Голована, и число сигналов unistat-ручки **меньше 1000**, то для их включения достаточно:

1. В Няне во вкладке Инстансы поставить необходимые теги;

2. Создать пустой контейнер **с именем существующей секции в instancectl.conf** или использовать существующий [подробнее об использовании контейнеров)](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howtos/structured-instancectl-config-how-to/#how-to), добавить в нем YASM unistat endpoint. Можно указать несколько адресов.
   ![https://jing.yandex-team.ru/files/altagona/browser_o96XX6JNlm.png](https://jing.yandex-team.ru/files/altagona/browser_o96XX6JNlm.png)

3. Указать `port` (обязательно) и `path`.
   Итоговый url будет выглядеть `http://{container_ip}:{port}/{path}`, где

    * `container_ip` — если используется mtn, backbone ip контейнера, иначе `localhost`
    * `port` — можно указывать цифры или алиасы вида `{BSCONFIG_IPORT}`, `{BSCONFIG_IPORT_PLUS_...}`
      ![https://jing.yandex-team.ru/files/altagona/browser_JOdLyd0BtP.png](https://jing.yandex-team.ru/files/altagona/browser_JOdLyd0BtP.png)

4. Настроить в сервисе unistat-ручку, отвечающую по данному URL в соответствии с [форматом](https://wiki.yandex-team.ru/golovan/stat-handle/#format);

5. Перевыкатить сервис.

### Мониторинг с помощью unistat с произвольным числом сигналов {#yasm-monitoring-unistat-full}

В данном случае необходимо будет завести собственный `itype` с коммитом в репозиторий yasm и ожиданием выкладки yasm-агента на кластер. [Подробный HOWTO](https://wiki.yandex-team.ru/golovan/golovan-howto/).
Крупноблочно нужно сделать следующее:

1. Закоммитить конфиг для своего `itype` в репозиторий yasm-агента со своими настройками (возможные настройки стат-ручки описаны [здесь](https://wiki.yandex-team.ru/golovan/stat-handle/#unistat-options)), пройдя процедуру ревью кода, указав в нём:

    ```
    [sources]
    unistat = unistat

    [options_unistat]
    max_sig_count = 2000
    url_from_iss = yasmUnistatUrl
    keep_url_port = true
    ```

2. Дождаться выкатки yasm-agent с новым `itype` на кластер.

3. Вписать созданный `itype` в сервисе;

4. Создать пустой контейнер **с именем существующей секции в instancectl.conf** или использовать существующий [подробнее об использовании контейнеров)](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howtos/structured-instancectl-config-how-to/#how-to), добавить в нем YASM unistat endpoint. Можно указать несколько адресов.
   ![https://jing.yandex-team.ru/files/altagona/browser_pH6vyW6I1k.png](https://jing.yandex-team.ru/files/altagona/browser_pH6vyW6I1k.png)

5. Указать `port` (обязательно) и `path`.
   Итоговый url будет выглядеть `http://{container_ip}:{port}/{path}`, где

    * `container_ip` – если используется mtn, backbone ip контейнера, иначе `localhost`
    * `port` – можно указывать цифры или алиасы вида `{BSCONFIG_IPORT}`, `{BSCONFIG_IPORT_PLUS_...}`
      ![https://jing.yandex-team.ru/files/altagona/browser_oOYqQMTn6v.png](https://jing.yandex-team.ru/files/altagona/browser_oOYqQMTn6v.png)

6. Настроить в сервисе unistat-ручку, отвечающую по данному URL в соответствии с [форматом](https://wiki.yandex-team.ru/golovan/stat-handle/#format);

7. Перевыкатить сервис.

## Выставление дисковых квот в сервисе {#quotas}

Каждому инстансу изолированного сервиса выделяется ограниченная квота под размещение данных на диске (hdd или ssd).
Квоты выделяются на:

1. **Persistent volumes**. Это вольюмы, которые сохраняются при перевыкладке инстансов. Если инстанс запишет в этот вольюм какие-то данные, а потом будет перевыкачен с новой версией бинарника, то данный вольюм будет присутствовать в новой версии инстанса без потерь данных (\*). Обычно такие вольюмы маунтятся по пути `/persistent` или `/logs` в инстансе (в его mountnamespace). Все эти вольюмы изначально пусты, заполнить их можно только изнутри самого инстанса.

1. **Root volume**. Это вольюм с корнем файловой системы (т.е. его mount point это `/`). В этом вольюме будут присутствовать файлы, приносимых в слоях файловой системы (`FS layers`). При этом файлы, принесённые в слое и в виде sandbox-ресурсов сервиса, не будут учитываться в квоте (занимают место бесплатно, не квотируются). Квотируются только те файлы, которые инстанс создаст в процессе своей работы.

1. **Work dir volume**. Это вольюм с директорией инстанса (`cwd`). Он маунтится в `/db/iss3/instances/<some_instance_hash>`. В ней запускаются отдельные секции из конфига `instancectl.conf` инстанса, хуки ISS (`iss_hook_start`, `iss_hook_stop`, ...). В ней **не хранятся** ресурсы сервиса, а лежат только симлинки на них.
   Поэтому обычно в этой директории лежат только:

   * логи instancectl `loop.log[.full]` и его `state`-файлы;
   * файлы, в которые перенаправляются `stdout`, `stderr` секций сервиса;
   * файлы, которые секции сервиса сами создают на диске, например, результаты распаковки архивов, приносимых в ресурсах сервиса.

   Все файлы, созданные инстансом в текущей рабочей директории, будут входить в квоту на work dir.

   `Root volume` и `work dir volume` у каждой ревизии инстанса свои. То есть при перевыкладке сервиса с новой версией бинарника, этой новой версии не будут доступны файлы, созданные в рабочей директории или в `/` предыдущей версией.

### Потеря данных volume'ов {#volumes-data-loss}

Данные вольюмов будут потеряны как минимум в следующих случаях:

1. При плановых переналивках сервера;
1. При внеплановых отказах железа.
1. Данные **root volume / work dir volume** будут удалены с диска, как только соответствующая ревизия инстанса получит целевое состояние `REMOVED` (удаление произойдёт не обязательно сразу же, но может случиться в любой момент, начиная с перевода инстанса в `REMOVED`).
1. Данные, записанные в **persistent volume**, будут удалены с диска, как только на хосте не останется ни одной ревизии инстанса в состояниях `PREPARED/ACTIVE`, в которых был указан этот volume.

    **Пример**

    1. В сервисе есть активный снэпшот `A` и новый снэпшот `B`;
    2. В обоих снэпшотах указан один и тот же persistent volume;
    3. Если запустить выкладку снэпшота `B` и сразу же удалить снэпшот `A`, то:
    4. Данные persistent-вольюмов будут потеряны на тех инстансах, на которых новая ревизия (снэпшота `B`) не успела перейти в состояние `PREPARED` [Пример из реальной жизни](https://st.yandex-team.ru/RTCSUPPORT-1132#1528883250000).
    5. Ещё одна особенность **persistent volumes** в gencfg, которая может привести к потере данных: при изменении любого параметра вольюма, включая дисковую квоту, точку монтирования и других, при выкладке его новой версии будет создан новый volume, без переноса данных, данные же старого вольюма **не будут доступны** из новой ревизии инстанса.

### Как выставить дисковые квоты на сервис до 10GB? {#how-to-set-relaxed-quotas}

Ослабленные квоты реализованы в рамках тикета [SWAT-4142](https://st.yandex-team.ru/SWAT-4142) и **работают только для gencfg**, под YP-lite их нет.
Если под ревизию (снэпшот) инстанса сервиса суммарно требуется:

1. Не больше `10GB` суммарно на work dir и root volume на каждый снэпшот;

1. Требуется хранить не больше 5 ревизий (в cleanup policy указано суммарно не больше пяти хранящихся снэпшотов)
   То квоты на root volume и work dir **достаточно указать только в Nanny**. Квоты на root volume / work dir из gencfg учитываться не будут.
   Квоты на persistent volumes всё равно нужно выставлять в gencfg.

    ![uhura_2021-10-20T18%3A06%3A31.703115.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A06%3A31.703115.png)

    О том, что ослабленные квоты включились, можно узнать по наличие сообщения:

    ![https://jing.yandex-team.ru/files/altagona/browser_ENG4Is4lh1.png](https://jing.yandex-team.ru/files/altagona/browser_ENG4Is4lh1.png)

### Как выставить дисковые квоты на сервис больше 10GB? {#how-to-set-not-relaxed-quotas}

Если условия из предыдущего пункта не выполняются, то квоты на work dir и root volume нужно указывать в двух местах:

1. В Nanny нужно указать квоту на отдельный снэпшот:
   ![uhura_2021-10-20T18%3A05%3A54.670309.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A05%3A54.670309.png)

1. В gencfg нужно указать сумму квот по всем снэпшотам на root volume и work dir.
   При этом на стадии генерации конфигурации будет проверка того, что сумма квот всех снэпшотов сервиса не превосходит квоту на rootfs и рабочую директорию, выделенную в gencfg.

## Как попасть в контейнер? {#shell-into-container}

В контейнер можно попасть несколькими способами:

1. Через `sky portoshell`. Работает с любой машины, где есть одновременно:

    * `skynet`;
    * Дырки до порта `10045` **железного хоста**, на котором живёт инстанс (например до `SEARCHPRODNETS`);
    * В `ssh-agent` проброшены ключ пользователя, который есть на staff.

2. Через `ssh -p 10046 ...`. Работает с любой машины, где есть одновременно:

    * Дырки до порта `10046` **железного хоста**, на котором живёт инстанс (например до `SEARCHPRODNETS`);
    * В `ssh-agent` проброшены ключ пользователя, который есть на staff.

3. Через `ssh`. Работает для сервисов, изолированных по сети (т.е. с включенным MTN). Работает с любой машины, где есть одновременно:

    * Дырки до 22 порта контейнера (доступ до сетевого макроса указанного при аллокации подов подойдёт);
    * В `ssh-agent` проброшены ключ пользователя, который есть на staff.

4. С железной машины.

Ниже описаны способы (1-3):

1. Открыть список инстансов в UI:
   ![uhura_2021-10-20T18%3A04%3A57.751664.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A04%3A57.751664.png)

2. Скопировать команду для входа в контейнер:
   ![browser_axNivdl8JR.png](https://jing.yandex-team.ru/files/altagona/browser_axNivdl8JR.png)

### Возможные проблемы {#shell-into-container-troubleshooting}

При невозможности зайти в контейнер, нужно сделать следующее:

1. Посмотреть, как выглядит сообщение об ошибке. Если оно имеет вид `Auth failure: Authentication as login failed`, то это проблема аутентификации, а не авторизации, это значит, в ssh-agent не проброшены никакие ключи пользователя со стаффа. Для решения этой проблемы нужно выполнить следующий пункт.

2. Проверить, что в ssh-agent проброшен хотя бы один ключ со стаффа. Для этого на машине, с которой пользователь пытается зайти в контейнер, этот же пользователь должен позвать `ssh-add -L`. В выводе должен присутствовать ключ, лежащий на [staff](http://staff.yandex-team.ru/) данного пользователя. [Подробнее](https://wiki.yandex-team.ru/diy/common-ssh/#chtotakoessh-agentiagentforwarding). [Как исправить](https://wiki.yandex-team.ru/diy/common-ssh/#instrukciiponastrojjkessh-klientov).

3. Проверить через [puncher](https://puncher.yandex-team.ru/), что с машины, с которой пользователь пытается зайти в контейнер, есть дырка до требуемого сетевого макроса:

    * В случае (1-2) до железной машины;
    * В случае (3) до сетевого макроса инстансов.

## Как выключить хостовый skynet ssh в сетевом namespace контейнера {#ssh-instance-net}

Нужно выставить соответствующую опцию в `disabled`:
![browser_o6HHp9RQkx.png](https://jing.yandex-team.ru/files/altagona/browser_o6HHp9RQkx.png)

## Как пробросить устройство в контейнер {#host-devices}

На данный момент доступны устройства:

1. `/dev/kvm`;
2. `/dev/net/tun`, доступ к которому выдаётся по аппруву команды Nanny.

Для проброса устройства в контейнер, необходимо:

1. При деплое на YP выставить соответствующий флажок при аллокации:
   ![uhura_2021-10-20T18%3A03%3A27.332606.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A03%3A27.332606.png)

2. Создать пустой контейнер или использовать существующий (если в сервисе используется `loop.conf`, контейнер должен называться, как существующая секция `loop.conf`, [подробнее об использовании контейнеров](https://wiki.yandex-team.ru/jandekspoisk/sepe/nanny/howtos/structured-instancectl-config-how-to/#how-to)) и выставить нужные галки в `Host devices`.
   ![uhura_2021-10-20T18%3A03%3A49.811853.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A03%3A49.811853.png)

## Как запустить процесс из-под другого пользователя? {#run-as-user}

Функционал доступен только при полной изоляции сервиса.
При использовании Instance Spec достаточно указать **UID** в секции Security Context запускаемого контейнера. Username будет резолвится неправильно: https://st.yandex-team.ru/RTCSUPPORT-15794.
При использовании instancectl.conf нужно добавить в Instance Spec контейнер с именем соответствующей секции из instancectl.conf, в котором также задать пользователя в Security Context.
![uhura_2021-10-20T18%3A18%3A34.516609.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A18%3A34.516609.png)

## Как запустить подконтейнер/секцию инстанса с лимитами по ресурсам {#subcontainer-limits}

Возможность доступна только при использовании Instance Spec и **не доступна с loop.conf/instancectl.conf**.
![uhura_2021-10-20T18%3A19%3A00.621963.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A19%3A00.621963.png)

## Как включить NAT64 в контейнере {#nat64}

Из контейнеров можно ходить во внешние IPv4-only сервисы через NAT64. Для этого необходимо:

1. Включить опцию `NAT64_LOCAL` в настройках сервиса (описано ниже)

2. Запросить доступ до Интернет в [https://puncher.yandex-team.ru/,](https://puncher.yandex-team.ru/,) в качестве приёмника нужно указать слово `Интернет`.

    После включения этой опции в новой ревизии инстансов в `/etc/resolv.conf` первым будет записан адрес локального резолвера, кеширующего данные из NAT64-nameserver. [Подробнее о NAT64.](https://wiki.yandex-team.ru/iaas/nat64/)

    {% note info %}

    Старый способ настройки `NAT64` (без `LOCAL`) признан deprecated, см. детали в [https://st.yandex-team.ru/SPPROBLEM-202](https://st.yandex-team.ru/SPPROBLEM-202)

    {% endnote %}

![uhura_2021-10-20T18%3A19%3A24.787624.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A19%3A24.787624.png)


## Как использовать секреты в контейнере {#secrets}

См. [гайд по доставке секретов ](https://wiki.yandex-team.ru/runtime-cloud/nanny/secrets/)

## Что такое динамические ресурсы и как их настроить {#dynamic-resources}

Динамические ресурсы позволяют решить следующую проблему пользователя. Допустим у меня в сервисе есть данные, которые я хочу регулярно обновлять, но делать это без рестарта моих процессов. Например, в моём сервисе есть бинарник, который стартует 15 минут, и один из видов данных, которыми он отвечает, это курсы валют. Курсы валют это файлик размером 10 килобайт, то есть он очень маленький. Я бы хотел обновлять его в своём сервисе раз в 5 минут, но при этом не рестартить сервис целиком, т.к. сам рестарт моего сервиса это уже слишком долгий процесс на протяжении которого ещё и часть инстансов моего сервиса находится в недоподнявшемся состоянии, т.е. сервис частично деградирован. Как мне это настроить в Nanny?

Обычные файловые ресурсы не подходят для этой задачи, ведь их обновление всегда выполняется с рестартом. То есть если я просто положу файл с курсами валют в свой сервис и обновлю его, то это обязательно случится с рестартом всех процессов моего сервиса. Чтобы решить эту проблему в ISS-agent и Nanny были поддержаны динамические ресурсы. Динамический ресурс, это обычный ресурс сервиса, который помечен специальным флажком `Is dynamic`:
![https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A21%3A20.096513.png](https://jing.yandex-team.ru/files/altagona/uhura_2021-10-20T18%3A21%3A20.096513.png)

Отличие динамических ресурсов от обычных в том, что при их обновлении не происходит рестарт процессов сервиса.

Как же система выкладки понимает, нужно ли выполнять обновление старой ревизии сервиса на новую с рестартом процессов или без? Ответ такой: она вычисляет, какие именно файловые ресурсы поменялись между двумя ревизиями сервиса, и если поменялись только динамические, то рестарта процессов не происходит.

### Как начать использовать динамические ресурсы в своём сервисе? {#howto-enable-dyn-resources}

1. Нужно пометить ресурсы, обновление которых должно происходить без рестарта флагом `Is dynamic`, скриншот о котором есть выше.

2. Однако как мой процесс узнает о том, что в его контейнере был обновлён динамический ресурс если его просто принести и положить? Для этого нужен механизм уведомления процесса, и такой механизм есть в ISS и Nanny. Он называется `Notify action` и включается в секции `Instance Spec` сервиса. [Документация о нём](https://wiki.yandex-team.ru/runtime-cloud/nanny/howtos/structured-instancectl-config-how-to/#notify-action). `Notify action` позволяет выполнять запрос на HTTP-интерфейс моего инстанса в ту ручку, в которую мне было бы удобно сделать запрос, чтобы оповестить мой инстанс о новых динамических ресурсах. Альтернативно `Notify action` позволяет для оповещения запустить произвольную команду в контейнере.

Указанная выше документация по настройке `Notify action` предполагает, что в сервисе используется запуск процессов [через Instance spec](https://wiki.yandex-team.ru/runtime-cloud/nanny/howtos/structured-instancectl-config-how-to/). Помимо него есть ещё старый legacy-способ запуска пользовательских процессов в контейнере: через конфиг instancectl.conf или loop.conf. Если вы всё ещё используете его, крайне рекомендуем переехать на Instance spec. Однако при желании настроить нотификации инстансов об обновлении дин.ресурсов можно и при старом способе запуска инстансов, однако [документация](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/#notifyscript) об этом способе находится в плачевном состоянии, поэтому просим использовать её только на свой страх и риск.

### Какие проблемы могут возникнуть при использовании динамических ресурсов? {#danger-dyn-resources}

Хотя динамические ресурсы и очень похожи на обычные (или статические, что то же самое), их механика довольно сильно отличается и содержит много подводных камней и способов выстрелить себе в ногу. Например, динамические ресурсы могут быть опасны сценарием, когда один пользователь обновил в сервисе статический ресурс, но не выкатил его, а другой обновил после этого ещё и динамический ресурс и покатил его вместе с изменением статического ресурса предыдущего пользователя. Но поскольку он думал, что катится только его динамический ресурс, то он ожидал, что его обновление будет без рестарта сервиса, поэтому выставил у выкладки окно в 100. Но поскольку реально между старой запущенной конфигурацией и новой поменялся ещё и статический ресурс, который забыл выкатить пользователь, вносивший изменения в сервис ранее, то выкладка всё же случится с рестартом. В результате 100 инстансов сервиса одновременно уйдут в даунтайм и сервис синхронно включится, а трафик с него прольётся и внешние пользователи получат неответы.

Помимо этой проблемы есть особенности, которые возникают при обработке дин.ресурсов на хосте. О них крайне рекомендуем почитать про то, [как обрабатываются динамические ресурсы с точки зрения ISS-агента](https://wiki.yandex-team.ru/iss3/specifications/configuration/resource/#dinamicheskijjresurs).

Все проблемы динамических ресурсов должны быть починены их новой механикой, внедрение которой сейчас происходит в Яндекс.Деплое, а eventually в пользу них будут закопаны и старые динамические ресурсы.

### Я настроил `notify action` для динамических ресурсов, а оно не работает {#troubleshooting}

Нужно убедиться, что при обновлении динамического ресурса не случалось обновления ещё и статического. Если тут всё хорошо, то нужно почитать в контейнере логи ISS-agent и instancectl. Это файлы `anamnesis.log` и `loop.log`. В момент обновления динамического ресурса в них должна быть информация о том, что был выполнен notify инстанса о новой версии ресурса.

### Как пометить сервис тестовым? {#mark-as-testing}

Для сервисов, в которых Nanny обнаруживает сломанные поды, в недалёком будущем будет внедрена система уведомлений пользователя о проблемах. Для того, чтобы отключить данные уведомления достаточно пометить сервис как тестовый.

![https://jing.yandex-team.ru/files/bromigo/Screen%20Shot%202021-11-02%20at%2015.34.11.png](https://jing.yandex-team.ru/files/bromigo/Screen%20Shot%202021-11-02%20at%2015.34.11.png)
![https://jing.yandex-team.ru/files/bromigo/Screen%20Shot%202021-11-02%20at%2015.38.17.png](https://jing.yandex-team.ru/files/bromigo/Screen%20Shot%202021-11-02%20at%2015.38.17.png)

### Проброс cgroupfs в контейнер {#cgroupfs }

Сервера облака имеют десятки, а иногда и сотни ядер процессора (на новых серверах по 256 физических ядер CPU). И обычно в контейнере доступна лишь небольшая часть процессорного времени этих ядер, соответствующая заказанному CPU для пода. При этом нередко многопоточные приложения опираются на число доступных процессорных ядер, например, создают такое же количество тредов для выполнения. Поэтому им для корректной работы нужно узнавать это число доступных ядер из своего окружения. Аналогично приложение (особенно на java) может опираться на доступный ему объём памяти, чтобы преаллоцировать некоторый её объём.

Чтобы приложение могло узнать число доступных ему ядер и памяти, нужно:

1. Убедиться, что приложение умеет получать доступное для выполнения число ядер из cgroupfs и донастроить его при необходимости. Как это сделать для [java](https://clubs.at.yandex-team.ru/infra-cloud/2135), для [C++ и go](https://clubs.at.yandex-team.ru/infra-cloud/2211).
2. Убедиться, что приложение читает доступный объём памяти из `/sys/fs/cgroup/memory/memory.anon.limit` , а не `/sys/fs/cgroup/memory/memory.limit_in_bytes`. Иначе оно может упасть пытаясь выделить анонимной памяти больше, чем есть в контейнере.
3. Включить проброс cgroupfs в контейнер:

    ![img](https://jing.yandex-team.ru/files/alonger/cgroupfs.png)

{% cut "Зачем вообще пробрасывать cgroupfs?" %}

Многие приложения по дефолту берут число доступных ядер из `/proc/cpuinfo`, где указывается подробная инфа про все физические ядра процессора. Это приводит к тому, что приложение создаёт 256 тредов для выполнения, при доступном для выполнения в контейнере процессорном времени всего, например, четырёх ядер. На практике это часто приводит к тому, что приложение начинает тормозить, т.к. узким местом становится аллокатор памяти, детали можно найти в [KERNEL-653](https://st.yandex-team.ru/KERNEL-653).
Аналогичную проблема имеет место с ожиданиями программы про доступную в контейнере память.

{% endcut %}
