# L7-fast Balancer Administrator Interface

Документ описывает [интерфейс управления L7-fast балансером](https://nanny.yandex-team.ru/ui/#/l7fast/config/).

## Немного технических деталей
Админка L7-fast состоит из двух вкладок: интерфейса редактирования конфига и интерфейса редактирования весов.

Интерфейс редактирования конфига является обёрткой над обычным сервисом Няни. Он предоставляет удобную форму для редактирования специального типа ресурсов сервиса — L7-fast balancer config file, а также производит дополнительную валидацию данных и авторизацию пользователей.

Структура формы редактирования весов определяется текущим конфигом L7-fast. Сами веса хранятся отдельно от конфига и доставляются до инстансов балансера с помощью ITS исключительно по команде пользователя.

## Как с этим работать
Измененный конфиг можно сохранить, нажав кнопку «Submit». В появившемся модальнике будет две кнопки — «Save» и «Save and Deploy».
Первая просто изменяет runtime атрибуты сервисы, а вторая также выставляет получившемуся снапшоту target state `ACTIVE`.

Остальные действия над балансером производятся через интерфейс сервисов. Посмотреть или изменить, на какой сервис «ссылается» админка L7-fast, можно используя кнопку «Edit Pointer».

Изменение конфига балансера может повлечь изменение текущих весов в базе данных, однако, выкатка балансера не означает выкатку весов. Веса выкатываются _только_ по нажатии на кнопку «Push weights to ITS». Это стоит учитывать при работе с балансером.

## Конфиг балансера
Конфиг имеет иерархическую структуру: section — traffic slice — backend.

В **секции** задаются:

* уникальный идентификатор;
* префикс для роутинга по URL;
* настройки балансировки (balancing options), которые будут унаследованы всеми бэкендами.

На уровне секций происходит авторизация. Менеджером секции считается любой, кто является менеджером любого из вложенных бэкендов.

Секция может содержать один или более трафик слайсов.

В **трафик слайсе** задаются:

* уникальный идентификатор, который будет использоваться в интерфейсе редактирования весов;
* список доменов.

Трафик слайс может содержать один или более бэкендов.

В **бэкенде** задаются:

* локация (sas, msk, ...);
* идентификатор сервиса и его конкретного снапшота, задающего список инстансов бэкенда. Все инстансы должны иметь IPv6-адрес.
* опционально — настройки балансировки, которые переопределят те, что указаны в секции.

Опции балансировки описаны в [документации на балансер](https://beta.wiki.yandex-team.ru/JandeksPoisk/Sepe/balancer/Cookbook/#balansiruemnagruzku).

## Веса балансера
Веса имеют иерархическую структуру: traffic slice — location.

Каждая локация имеет два веса: актуальный (weight) и дефолтный (default weight). До балансера доставляются только актуальные веса; дефолтные веса отражаются только в интерфейсе.

Структура весов всегда соответствуют последней сохранённой версии конфига:

* если из конфига удаляется бэкенд, веса оставшихся локаций автоматически нормализуются так, чтобы в сумме было 100;
* если в конфиг добавляется бэкенд, добавляется локация с нулевым весом;
* если в конфиг добавляется трафик слайс, его локациям присваиваются равные веса.

## API
RESTful JSON API живёт по адресу `http://nanny.yandex-team.ru/v2/l7/fast/`.

Автоматически сгенерированная документация доступна в Няне: [http://nanny.yandex-team.ru/ui/#/l7fast-api-docs](http://nanny.yandex-team.ru/ui/#/l7fast-api-docs). Она описывает структуру запросов и ответов всех доступных методов API.

Аутентификация точно такая же, [как и в остальном API Няни](../api/rest.md#authz).

