# Общая информация

##  Интро {#intro}
В данном разделе попробуем описать, что такое сервис HQ, мотивацию его создания и то, как он устроен.
Приступим.

##  Мотивация {#motivation}
Nanny предоставляет пользователям инструмент для запуска приложений пользователей в различных "облачных" решениях внутри Яндекса. В терминах Няни - это _engine_. Первоначально был только один движок - [bsconfig](https://wiki.yandex-team.ru/jandekspoisk/skynet/bsconfig/). Но время не стоит на месте и появилось новое решение - [ISS](https://wiki.yandex-team.ru/iss3/). Был поддержан и он. Затем помимо одной большой инсталляции ISS, растянутой на все хосты, появились локационные инсталляции. В самом ближайшем будущем появится поддержка новой технологии - [ClusterAPI](https://wiki.yandex-team.ru/clusterapi/).
Методов выделения ресурсов (_allocation_) для запуска в них приложений так же поддерживается несколько:

* [Gencfg](https://wiki.yandex-team.ru/jandekspoisk/sepe/gencfg/)
* внутренний аллокатор Няни для быстрого предоставления пользователям ресурсов

По мере развития системы, перед командой встали следующие проблемы:

* Поддержка большого количества похожих реализаций систем управления кластером - сложная и трудозатратная задача.
При этом модель каждой из систем не полностью отражает физическую реальность того, как выделяются ресурсы и запускаются приложения.
* Необходимо было предоставить пользователям системы функциональность, которой не будет (например, bsconfig не развивается) или может появиться очень не скоро в самих системах управления "облаками".
Таким примером на данный момент является доставка секретных данных.

Но любую проблему можно решить, введя дополнительный уровень абстракции. Для решения этих задач была сформулирована и реализована модель того, как работают наши приложения. Реализацией такой модели и стал сервис HQ.

##  Модель {#model}
Попробуем рассмотреть модель bottom-up, т.е. начнём с уровня инстанса конкретного приложения пользователя, поднимаясь выше.

###  Модель процессов {#model-processes}
Жизнь инстанса приложения начинается с запуска процесса-супервизора [instancectl](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/) внутри выделенных ему ресурсов. Ограничения и изоляция обеспечивается [porto](https://wiki.yandex-team.ru/porto/) контейнером.
Далее instancectl в свою очередь запускает процессы пользователя (опционально, в разных подконтейнерах).

```
+-------+-----------------------------------------------------------+
| porto |                                                           |
+-------+    +------------+  instancectl   +-------------+          |
|            |                    +                      |          |
|            |                    |                      |          |
|   +--------v--------+    +------v------------+  +------v-------+  |
|   |                 |    |                   |  |              |  |
|   | search-instance |    |    push-client    |  |     ...      |  |
|   |                 |    |                   |  |              |  |
|   +-----------------+    +-------------------+  +--------------+  |
|                                                                   |
|                                                                   |
+-------------------------------------------------------------------+
```
###  Модель ресурсов {#model-resources}
Поднимемся чуть выше уровня контейнера. Для запуска инстанса в контейнере - контейнер необходимо подготовить и создать. Для создания необходимо выделить ресурсы. Т.е. для запуска каждый инстанс должен быть:

* аллоцирован
Т.е. ему должны быть выделены ресурсы.
* подготовлен
Т.е. ресурсы (пакеты, файлы) должны быть скачаны и установлены, volume'ы выделены (смонтированы) и т.д.
Таким образом мы ввели новые объекты - аллокация (физически представлена в виде porto контейнера) и состояние (подготовлен, запущен).

###  Действия над объектами {#model-actions}
Осталось рассмотреть, какие действия можно выполнять с инстансом.

* `Create` - инстанс можно создать, указав ресурсы и т.д.
* `Delete` - инстанс можно удалить, тогда освободятся ресурсы хоста.
* `Update` - инстанс можно изменить, возможно, это будет изменение бинарника, его настроек и т.д.
Необходимо подробней остановиться на изменении (`Update`) инстанса, т.к., кажется, это действие будет определять то, как мы должны описывать инстанс.

####  Обновление инстанса {#model-actions-update}
Модель сервиса такова, что есть несколько ревизий сервиса (т.е. описания всего сервиса целиком) и каждая ревизия может быть в одном из состояний:

* `Ready (Active)` - ревизия должна быть запущена
* `Installed` - ревизия должна быть установлена на машине
Мотивация такой модели сервиса заключается в том, что пользователю необходимо:
* иметь в любой момент быстро и максимально надёжно откатиться на предыдущую стабильную версию.
Так мы исключаем необходимость скачивания и установки предыдущей версии.
* без подключения шедулера иметь возможность выполнять действия внутри выделенных ресурсов
Если инстанс не изменяемый, то для запуска каждой новой версии программы необходимо выделять ресурсы.

###  Инстанс на хосте {#model-instance-layout}
Таким образом то, как выглядить инстанс на машине можно изобразить как:

```
+------------------------+
| host: ws35-035.s.y.net |
+----------------------------------------------------------------------------+
| +---------------------------------+                                        |
| | instance: prod-nanny-3w87d      |                                        |
| +---------------------------------+--------------------------------------+ |
| |resources:                                                              | |
| |  cpu: 2                                                                | |
| |  mem: 4gb                                                              | |
| |                                                                        | |
| | +--------------------+     +-----------------------+                   | |
| | | version: 823adf4   |     | version: 139f4ab      |                   | |
| | +--------------------+---+ +-----------------------+---+               | |
| | |  state: Active         | |  state: Installed         |               | |
| | |                        | |                           |               | |
| | |  cmd: basesearch-1     | |  cmd: basearch-2          |               | |
| | |                        | |                           |     ...       | |
| | |  ...                   | |  ...                      |               | |
| | |                        | |                           |               | |
| | +------------------------+ +---------------------------+               | |
| +------------------------------------------------------------------------+ |
+----------------------------------------------------------------------------+
```

Т.е. сверху вниз у нас есть:

* физический хост (`node`)
На нём запущены агенты систем управления кластером и porto. Он предоставляет ресурсы для запуска в них инстансов.
* инстанс пользователя (`instance`)
Это именовая сущность, которая включает в себя аллокацию (`allocation`), файловые и дисковые ресурсы _ревизий_ инстанса.
* ревизия инстанса (`instance revision`)
Описывает, что конкретно должно быть подготовлено (`installed`) и запущено (`ready`) внутри инстанса (в рамках выделенных ресурсов).

###  Определение инстанса {#model-instance-definition}
Попробуем теперь уложить описанную модель в физическое описание. В качестве конкретного языка описания возьмём `protobuf`:

```
message Instance {
    InstanceMeta meta = 1;
    InstanceSpec spec = 2;
    InstanceStatus status = 3;
}
```
Разделим описание инстанса на три части:

* `meta` - мета информация, включает в себя время создания, уникальный идентификатор и т.д.
* `spec` - спецификация инстанса - запрошенные и выделенные ресурсы, ревизии и их требуемое состояние.
* `status` - статус, включает в себя общее состояние инстанса и состояния отдельных ревизий.
Рассмотрим spec и status детальней.

#### Instance Spec {#model-instance-definition-spec}
```
/* Instance specification */
message InstanceSpec {
    ResourceRequest resource_request = 1; // Resources requested by this instance (used in scheduler)
    ResourceAllocation allocation = 2; // Allocated resources (set by scheduler)
    // Host on which instances will be started (set by scheduler)
    // We use term "node" to specify that it is physical machine name (opposed to host, if we use IP per instance)
    string node_name = 3; // To be used by node
    repeated InstanceRevision revision = 4; // Revisions present on host
}
```
* `resource_request` - запрошенные инстансом ресурсы
Включает в себя CPU, MEM, порты.
* `allocation` - реально выделенные шедулером ресурсы.
CPU, MEM и конкретные номера выделенных портов.
* `node_name` - имя физического хоста, на котором шедулер выделил ресурсы.
* `revision` - определение ревизий инстанса.
Описание пакетов, файлов, образов, которые необходимы для запуска ревизии.

####  Instance Status {#model-instance-definition-status}
```
/* Observed status of particular instance revision */
message RevisionStatus {
    string id = 1; // Revision identifier
    Condition installed = 2;  // True if revision is installed
    Condition ready = 3;  // True if revision is ready
    repeated ContainerStatus container = 4;
}

/* Observed instance status */
message InstanceStatus {
    google.protobuf.Timestamp last_heartbeat_time = 1;
    Condition ready = 2;  // Condition is "True" if any revision is ready
    repeated RevisionStatus revision = 3;
}
```
Статус инстанса складывается из статусов отдельных ревизий. Для простоты работы, например, в целях service discovery - общее состояние готовности вынесено на уровень всего инстанса.

* `installed` - установлена ли ревизия.
В случае использования instancectl - это результат работы `prepare_script` секций.
* `ready` - ревизия инстанса запущена и готова обслуживать запросы.
* `container` - статусы конкретных подконтейнеров.
В случае instancectl - это статусы отдельных секций.
* `last_heartbeat_time` - дата последнего получения хартбит сообщения от instancectl
Отправляются каждые 3 минуты. Если по прошествии 10 минут обновления не было - HQ переведёт ревизию в `ready=False` самостоятельно.

##  Реализация {#implementation}
Рассмотрим реализацию HQ с нескольких точек зрения:

* реализация самого сервиса
* реализация взаимодействия Nanny => HQ
* реализация взаимодействия instancectl => HQ
Приступим.

###  Реализация самого сервиса {#implementation-hq}
Каждая инсталляция:

* HQ - это реплицированный сервис с хранилищем данных в [etcd](https://github.com/coreos/etcd) (используется протокол v3).
* Хранит в формате protobuf.
* При запуске подключается к хранилищу, подписывается на все изменения инстансов и поддерживает в памяти актуальную картину кластера.
* Предоставляет HTTP API, принимая POST запросы в формате JSON или Protobuf, возвращая ответы так же в одном из указанных форматов.
* Внутренняя логика ограничена валидацией запросов и поддержкой перевода инстансов, которые не рапортуют статус в `ready=False`.
В остальном - это API над хранилищем данных.
Сервис в целом:
* Представлен тремя инсталляциями по 5 реплик в каждой.
Так обеспечивается баланс между доступностью (одна реплика может быть на плановом ремонте, одна аварийно упасть) и производительностью (для кворума необходимо 3 реплики).
* Каждая инсталляция независима и ничего не знает о других.
Так достигается отказоустойчивость сервиса в целом. Авария в одной локации не сказывается на работе других.
Для облегчения работы с тремя инсталляциями (а в будущем с большим количеством) реализован простой сервис [federated](/jandekspoisk/sepe/nanny/federated/).

###  Взаимодействие Nanny => HQ {#implementation-nanny-hq}
Nanny использует HQ для двух целей:

* В рамках реализации плана абстрагирования от различных систем управления кластером (bsconfig/ISS/ClusterAPI)
* Для реализации задач доставки секретных данных

Во время процедуры выгрузки всех конфигурации в систему управления кластером параллельно происходит выгрузка описания инстансов и их ревизий в HQ. Таким образом все инстансы доступны пользователям для целей service discovery.

###  Взаимодействие instancectl => HQ {#implementation-instancectl-hq}
`instancectl` взаимодействует с HQ для двух целей:

* получение описания секретных данных, которые необходимо доставить до запуска приложения пользователя
* рапорт текущего состояния

Рапорт отправляется при изменении состояния или раз в 3 минуты.

