# Руководство пользователя

##  О чём это? {#disclaimer}
На этой странице попробуем описать сценарии, в которых HQ может быть полезен пользователю и как этим пользоваться.

##  Подключаем свой сервис {#enable-reporting}
Для того, чтобы инстансы сервиса начали отправлять своё состояние в HQ пользователю надо выполнить 3 простые операции:

* В разделе `Runtime Attrs -> Files` проверяем, что мы используем _instancectl_ версии не ниже `1.2.92`.
Более старые версии, к сожалению, не умеют рапортовать.
* Запускаем выкладку новой версии сервиса.
Либо совмещаем приятное с полезным и просто выкатываем совместно с другими изменениями. **Но помним**, что внесение нескольких изменений затрудняет диагностику в случае, если что-то пошло не так.

##  UI в сервисе {#hq-view}

Если мы включили рапорт о состоянии инстанса в HQ, то в UI сервиса мы можем посмотреть, что происходит с нашим сервисом. Начнём с того, что перейдём со страницы сервиса в раздел HQ, который прячется за кнопкой с изображением глобуса

![img](https://jing.yandex-team.ru/files/sshipkov/hq-service-link.0c4e512.png)

##  Раздел Stats {#hq-view-stats}

Первый раздел - это _Stats_.

![img](https://jing.yandex-team.ru/files/sshipkov/hq-service-stats.8d11629.png)

В этом разделе представлены друг за другом все инсталляции HQ (по одной в каждой локации) и самая базовая статистика по инстансам сервиса в каждой:

* Ready - количество поднятый инстансов (готовых выполнять задания)
* Total - общее количество инстансов.

##  Раздел Instances {#hq-view-instances}

Если кликнуть на таб _Instances_ то мы увидим полную картину (по версии HQ)

![img](https://jing.yandex-team.ru/files/sshipkov/hq-service-instances.36599dd.png)

Мы видим состояние всех известных HQ ревизий инстансов сервиса в каждой локации друг за другом. Каждый квадрат - это ревизия конкретного инстанса, цвет отражает текущее состояние:

* Зелёный - ревизия инстанса в данный момент в состоянии `ready`.
* Синий - ревизия - `installed`, то подготовлена и готова к старту.
* Серый - ревизия только описана в HQ (и ISS/bsconfig), но на хосте не присутствует (например, установка завершилась неудачей).
* `42` - число внутри квадрата означает количество перезапусков/падений ревизии.

Если запускается несколько процессов - отображается суммарное количество.

##  Страница инстанса {#hq-view-instance-page}

Если мы кликнем на любой квадрат на странице _Instances_, то мы попадём на страницу конкретного инстанса

![img](https://jing.yandex-team.ru/files/sshipkov/hq-instance-page.cdb0d18.png)

На этой странице представлена вся информация об инстансе, которой владеет HQ. Рассмотрим по пунктам сверху вниз.
Сверху представлена общая информация:

* **Id** - идентификатор инстанса
* **Service** - идентификатор сервиса
* **Last Heartbeat** - дата последнего рапорта о состоянии инстанса
Чуть ниже описано `Ready` состояние.
Далее представлен раздел спецификации инстанса:
* **Allocation** - аллокация инстанса, выделенные ему ресурсы
**Внимание:** на данный момент в HQ выгружаются только выделенные порты, что позволяет использовать HQ для целей service discovery.
* **Node** - хост, на котором выделены ресурсы
На нём будет запущен инстанс.
* **Walle-E Status** - статус хоста по версии [Walle-E](https://wiki.yandex-team.ru/wall-e/)
Это позволяет быстро понять, если проблемы инстанса вызваны проблемами хоста.
* **{configuration_id}** - список определений ревизий инстанса
Файловые ресурсы, образы контейнеров и т.д. **Внимание:** в данный момент выгрузка не производится.
В самом низу описаны состояния конкретных ревизий сервиса:
* Ready - ревизия активна и готова обслуживать запросы
* Installed - ревизия присутствует на хосте и подготовлена

##  HQ Panel в dashboard {#hq-dashboard-panel}

Если мы оперируем большим количеством сервисов (или просто несколькими связанными), то удобным будет создать _dashboard_ и разместить сервисы в нём. После этого мы можем получить панель с агрегированными данными по всем сервисам по версии HQ.

Для этого надо перейти по ссылке `HQ Panel` рядом с названием dashboard'а:

![img](https://jing.yandex-team.ru/files/sshipkov/hq-panel-link.bada424.png)

После этого мы попадём на страницу самой панели, которая может выглядеть примерно так:

![img](https://jing.yandex-team.ru/files/sshipkov/hq-panel-small.888bc80.png)

в случае, если у нас сервис находится в нескольких локациях, то панель будет выглядеть уже вот так:

![img](https://jing.yandex-team.ru/files/sshipkov/hq-panel-multi-dc.ad4ab72.png)

если в dashboard много сервисов, то панель будет выглядеть так

![img](https://jing.yandex-team.ru/files/sshipkov/hq-panel-big.6a7f6d5.png)

##  Легенда {#hq-dashboard-panel-legend}
Разберём, что изображено на панели.

* Каждый _box_ - это сервис, его название написано вверху каждого элемента.
Внутри может быть от нуля (если мы не включили интеграцию с HQ или пока не выкатили сервис) до 3х (по количеству локации) квадратов.
* Каждый _квадрат_ - это состояние сервиса в конкретной локации.
    * `12/12` - это количество активных (`ready`) инстансов / общее количество инстансов сервиса в данной локации.
    * `MSK prod` - это название инсталляции HQ. В данном случае это production HQ в локации `MSK`.
    * Цвет заливки призван помочь беглым взглядом увидеть проблемные сервисы:
        * Зелёная заливка - более 90% инстансов находятся в состоянии `ready`.
        * Жёлтая заливка - более 70% инстансов - `ready`.
        * Красная заливка - мнее 70% инстансов - `ready`

##  HQ API {#hq-api}
Сервис предоставляет API. Рассмотрим, чем он может быть полезен пользователям.

###  Service Discovery {#hq-api-service-discovery}
С точки зрения API HQ можно использовать для service discovery - нахождения актуального расположения инстансов сервисов. Пример можно посмотреть на [странице API](api.md#python-client-list-all-example).

