##  Частота проверки живости инстанса {#instance-status-frequency}

Живость инстанса проверяется по схеме:

1. [instancectl](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/) с определённой частотой выполняет проверку живости инстанса и запоминает вычисленное состояние инстанса. Проверка живости инстанса выполняется одним из двух способов в зависимости от настройки сервиса:

    * При использовании `instancectl.conf`: используя [параметр status_script](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/#instance-status-computation) -- тогда частота проверки живости настраивается [соответствующими параметрами конфига](https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/#instancectl-status-check-frequency);
    * При использовании контейнеров в Instance Spec: используя соответствующие [настройки в UI](../../how-to/structured-instancectl-config.md).

1. ISS-агент на хосте **с другой настраиваемой частотой** запускает `iss_hook_status`, который запрашивает состояние инстанса у instancectl и завершается с соответствующим кодом выхода. Частота запуска `iss_hook_status` [настраивается в UI](#iss-hooks-frequency) так же, как и у других хуков. Значения по умолчанию для частоты запуска `iss_hook_status`:

    ```
    min_restart_period: 30
    max_restart_period: 60
    restart_period_backoff: 2
    max_execution_time: 1800
    restart_period_scale: 1
    ```

    {% note info %}
    
    Не следует выставлять частоту рестарта `iss_hook_status` слишком высокой. Например, если выставить `max_restart_period = 5` секунд, то:

    * Если на машине нет активной выкладки, то `iss_hook_status` будет запускаться всё равно **раз в минуту**;
    * Даже если на хосте идёт активная выкладка, достаточно высокая частота (например, 5 секунд) недостижима из практических соображений: есть накладные расходы на создание контейнеров, выполнение синхронизации и т.п. и бороться с ними не целесообразно, т.к. на практике нет никакой необходимости так часто вычислять статус, вместо этого нужно использовать правильно настроенные экспоненциально растущие перерывы;
    * Приведёт к бессмысленному расходу CPU и прочим лишним операциям.

    {% endnote %}

##  Частота запуска ISS хуков {#iss-hooks-frequency}

Настраивается через UI:

![iss-hooks-frequency](https://jing.yandex-team.ru/files/sshipkov/2017-11-07_14-29-31.6cf13ae.png)
