# Администрирование

##  Тестовый сервис {#test-service}
Тестовая версия [prestable_its](https://nanny.yandex-team.ru/ui/#/services/catalog/prestable_its/):

* для отладки работы с API и т.д.
* не нужно использовать для load testing'а
* доступ через балансер `http(s)://dev-its.yandex-team.ru`
* UI через [dev-nanny.yandex-team.ru](https://dev-nanny.yandex-team.ru/)

##  Боевой сервис {#production}
* Боевая версия: [stable_its](https://nanny.yandex-team.ru/ui/#/services/catalog/stable_its/)
* UI через [nanny.yandex-team.ru](https://nanny.yandex-team.ru/)
* доступ через балансеры (см. ниже):
    * `http(s)://its.yandex-team.ru`
    * `http(s)://ext.its.yandex-team.ru`
* Панели YASM:
    * [Основная](https://yasm.yandex-team.ru/panel/its)

##  Балансировщики {#balancers}

* В ДЦ SAS, VLA, MAN подняты IPVS балансировщики от TT, которые смотрят в L7(HTTP) балансировщики.
На запросы keepalived отвечают L7 балансировщики, т.е. эффективно анонс не снимается никогда, если в локации работоспособна сеть.
* L7 балансировщики подняты в AWACS по отдельному сервису в каждом ДЦ:
    * [man.its.search.yandex.net](https://nanny.yandex-team.ru/ui/#/awacs/namespaces/list/man.its.search.yandex.net/)
    * [sas.its.search.yandex.net](https://nanny.yandex-team.ru/ui/#/awacs/namespaces/list/sas.its.search.yandex.net/)
    * [vla.its.search.yandex.net](https://nanny.yandex-team.ru/ui/#/awacs/namespaces/list/vla.its.search.yandex.net/)
* Вопросы можно и нужно задавать: кому:romanovich.

##  Балансировщики {#balancing-policy}

Сервис должен быть максимально доступным. При этом мы разделяем 2 типа пользователей:

* запросы на получение значений, хранящихся ITS
Т.е. "ручек", за которым обычно ходит `instancectl`.
* запросы на изменения значений
Обычно во время аварий пользователи изменяют настройки сервисов, веса балансировщиков
Запросы на чтение характеризуются:
* Большой RPS, ~10k в каждой локации
* Клиенты находятся **внутри** ДЦ - т.к. запущены на машинах наших кластеров
* В случае проблем в сети ДЦ нет большого смысла "сливать" часть трафика в другие локации.
Если нет сети, то изменять настройки сервисов бессмысленно, плюс нештатной нагрузкой можно "уложить" другие локации
Запросы на запись характеризуются:
* Малый RPS, десятки запросов в сутки суммарно
* Клиенты находятся **снаружи** ДЦ - могут быть во офисной сети, могут быть сервисами в произвольной локации.
* Мы должны приложить все усилия для обслуживания таких запросов

Т.е. перезадать в случае проблем запрос по всем failure domain (локациям).

В результате настроено **две** точки входа в сервис, которые по-разному балансируются на уровне HTTP (по заголовку `Host`):
* `its.yandex-team.ru` - оставляет запросы в той же локации
Обслуживает запросы на чтение.
* `ext.its.yandex-team.ru` - использует [двухуровневую балансировку](https://wiki.yandex-team.ru/CPLB/balancer-default-policy/) для перезапросов в несколько локаций.

Используется для записи и запросов из произвольных локаций и офиса. Доменное имя - это alias к its.yandex-team.ru.

###  Настройки двухуровневой балансировки {#ext-balancing}

Настройки двухуровневой балансировки для `ext.its.yandex-team.ru` описаны в виде [набора шаблонов](https://a.yandex-team.ru/arc/trunk/arcadia/infra/awacs/templates/its.search.yandex.net). Имеющиеся настройки были получены после обсуждения в [SWAT-3818](https://st.yandex-team.ru/SWAT-3818). Их описание и мотивация приведены здесь:

* Все бэкенды разбиты на три группы по числу DC: SAS, VLA, MAN.
* На верхнем уровне перебираются данные группы бэкендов, при этом делается **три** попытки обработки запроса (по числу ДЦ). Общего таймаута на выполнение запросов в конкретной группе нет;
* Внутри группы выполняется одна попытка обработки запроса, ограниченная таймаутом в 10 секунд на запрос. Такой большой таймаут нужен для запросов, в которых производится валидация всего yaml-конфига для ITS.

###  Вопросы и ответы {#balancing-policy-qa}

**Вопрос:** Почему не поднять отдельные IPVS для ext.its.yandex-team.ru?
**Ответ:** Мы решили не поднимать отдельные IPVS в предположении, что при авариях:
* Если условному Сасово плохо, но анонс снаружи виден и трафик из офиса долетает до IPVS в Сасово - это равносильно тому, что он скорей всего сможет достучаться до условно хорошего ДЦ Man.
* Если условному Сасово плохо настолько, что и анонсы не видны - это равносильно это тому, что анонс снят.
Т.е. мы считаем, что отдельных сценариев, когда нам нужно раздельно управлять анонсами нет.

