# Runtime атрибуты сервисов

## Файловые ресурсы {#file-res}

### Static Files {#static-files}

* Содержимое файлов, которое будет доставлено в рабочий каталог контейнеров, хранится непосредственно в описании runtime атрибутов.
* При выкладке содержимое копируется во внутреннее хранилище.
* В систему выкладки (ISS/bsconfig) передаётся URL, по которому система сможет скачать содержимое файла.

### Url Files {#url-files}

Этот тип файлов позволяет указать, что необходимый файл доступен по указанному URL'у и должен быть доставлен в каталог инстанса, используя указанный URL.

Имеет следующие атрибуты:
* `local_path` — название файла, которое должен иметь ресурс в каталоге инстанса на хосте.
* `url` — непосредственно URL для доступа к ресурсу. Конечные системы поддерживают схемы HTTP(S) и rbtorrent.
* `is_dynamic` — является ли ресурс динамическим (применимо только к ISS).
* `chksum` — опциональное поле с указанием чексуммы ресурса.
    По-умолчанию, при создании конфигурации в системе выкладки, репозиторий сервисов скачивает ресурсы по HTTP(S) схемам, вычисляет md5 и подклеивает к описанию ресурса для системы выкладки. Для того, чтобы минимизировать время создания конфигурации и уменьшить нагрузку на раздающие сервера, пользователь может указать чексумму в следующих форматах:
      * **MD5:<chksum>** — md5.
      * **EMPTY:** — чексумму вычислять и проверять на конечных хостах не надо.


### Sandbox Files {#sandbox-files}

![img](https://jing.yandex-team.ru/files/sshipkov/20180319103537.94e14ca.png)

В поле `Local path` нужно указать имя файла, под которым загруженный из sandbox ресурс будет доставлен в инстанс.
Чтобы указать ссылку на ресурс, нужно нажать на неприметную синюю кнопочку справа, тогда появится поле, куда нужно вписать ID ресурса из sandbox.
В секции `ISS properties` можно указать, что ресурс динамический и некоторые другие свойства ресурса.
При каждом новом релизе снэпшота будет скачиваться последняя версия ресурса.

Об этом можно прочитать ещё:
* [как поднять свой сервис с ресурсами](https://wiki.yandex-team.ru/JandeksPoisk/Sepe/nanny/howto-manage-service/#resurssodnimfajjlomizsandbox);
* [ISS Properties](https://wiki.yandex-team.ru/JandeksPoisk/Sepe/nanny/howto-manage-service/#file-iss-properties);
* [Sandbox Integration](https://wiki.yandex-team.ru/JandeksPoisk/Sepe/nanny/sandbox-integration/).


### Template Set Files {#template-set-files}

Этот тип файла предоставляет возможность описывать сложные конфигурационные и прочие в файлы путём разбиения их на части и объединения с помощью методов языка шаблонов [Jinja2](http://jinja.pocoo.org/). Генерация итогового файла происходит для каждого инстанса в отдельности, поэтому этот тип файла дает возможность генерировать разные ресурсы для разных инстансов.

Набор файлов состоит из корневого шаблона и опционального списка шаблонов, которые можно включать в корневой. При создании конфигурации произойдёт следующее:

1. Для каждого инстанса шаблоны будут проинтерпретированы движком Jinja2 шаблонов, результатом будет множество строк: под одной на каждый инстанс;
1. Инстансы будут сгруппированы по одинаковым сгенерированным строкам (для того, чтобы не плодить ресурсы с одинаковым содержимым);
1. Строки будет перекодированы в набор байт в кодировке `UTF-8`.
1. Байты будут помещены в файловое хранилище GridFS.
1. Http ссылки на ресурсы GridFS будут записаны как URL для данного ресурса у нужных инстансов в конфигурации bsconfig/ISS.

#### Root template {#root-template}

Корневой шаблон, который может включать в себя другие шаблоны с помощью директивы `{% include "<template name>" %}`.

![img](https://jing.yandex-team.ru/files/sshipkov/templatessetroot.5084c9f.png)

#### Список шаблонов {#template-list}

Опциональный список шаблонов, каждый из которых имеет:

* **Название** - строка без пробелов, которой можно адресовать шаблон для включения в корневой.
* **Тело** - содержимое шаблона. Произвольная текстовая строка, которая будет интерпретирована Jinja.

![img](https://jing.yandex-team.ru/files/sshipkov/templatessetfile.3e1c275.png)

####  Доступные параметры шаблонизации {#template-set-variables}

* **instance** — объект, описывающий свойства инстанса, для которого происходит генерация данного экземпляра ресурса. Объект имеет следующие поля, часть которых, в зависимости от способа генерации инстансов сервиса, может быть пустой:
* **host** — хост инстанса;
* **port** — порт инстанса;
* **power** — мощность инстанса (в терминах gencfg);
* **tags** — список тегов инстанса;
* **gencfg_group** — имя группы gencfg, в которую входит инстанс (при условии генерации инстансов из группы gencfg);
* **annotated_ports** — словарь аннотированных портов инстанса; доступен при задании инстансов с помощью аллокации; ключи словаря -- имена портов, каждое значение -- структура, имеющая поля: name -- строка, содержащая имя порта, port -- число, protocol  -- строка, содержащая TCP или UDP;
* **conf** — имя создаваемой конфигурации;
* **dc** — имя датацентра инстанса.


* **service_id** — идентификатор сервиса;
* **snapshot_id** -—идентификатор снэпшота сервиса (который выкатывается в данный момент).

####  Функции, доступные в шаблоне {#template-set-functions}

* `get_service_instances(service_id, snapshot_id, only_groups=None)`
Возвращает iterable инстансов сервиса для указанной ревизии.
Опциональный параметр `only_groups` (список строк) позволяет отбросить некоторые группы, с помощью которых описаны экземпляры сервиса. Так, если сервис описан двумя группами в gencfg, но балансировать нагрузку надо только на некоторые из них - следует использовать этот параметр.

![img](https://jing.yandex-team.ru/files/sshipkov/perinstancetemplates.e73af70.png)

##  Версионирование {#versioning}

###  Модель {#versioning-model}

Все изменения runtime атрибутов версионируются и сохраняются ревизиями (_snapshots_) в базу данных. При этом у каждого такого объекта есть следующие атрибуты:

* данные
Это непосредственно описание, доступное для редактирования пользователю. Включает всё, что отражается на состоянии сервиса на кластере.
* мета информация
Приоритет ревизии и прочее, что не отражается на том, что будет присутствовать на кластере.
* уникальный идентификатор
* дата создания
* автор изменения
* идентификатор родительской ревизии
Вся история изменений runtime атрибутов доступна в API и UI.

###  Процедура сохранения {#versioning-procedure}

При нажатии кнопки **Save** в UI, внесении изменений из тикета, изменении через API система выполняет следующие действия:

* Формирует новый документ с описанием runtime атрибутов.
* Вычисляет на основе содержимого идентификатор.
* Сохраняет в базе данных новый документ.
* Этот документ копируется в документ описания сервиса.
* Документ описания сервиса обновляется в базе данных (с Compare-And-Swap семантикой).

```
                                                  +---------------------------------------------+
                                                  |        service: production_mmeta_sas        |
                                                  |                                             |
                                                  |     runtime attrs    +---------------+      |
                                    UPDATE        |                      |               |      |
                        +----------------------------------------------> |               |      |
                        |                         |                      +---------------+      |
                        |                         |     info attrs       +---------------+      |
                        |                         |                      |               |      |
                        |                         |                      |               |      |
                        |                         |                      +---------------+      |
                        |                         |                                             |
                        |                         +---------------------------------------------+
                        |
                        |
+-----------------------+-----+                   +---------------------------------------------+
|       runtime attrs         |                   |              snapshots history              |
|                             |                   |                                             |
|  id: 234bfde97eaa           |      INSERT       |  +----------------------------------------+ |
|  parent: 987abc32fd98       +------------------->  |           id: 987abc32fd98             | |
|  data: {...}                |                   |  +----------------------------------------+ |
|  meta: {...}                |                   |  |                                        | |
|                             |                   |  +----------------------------------------+ |
+-----------------------------+                   |  |                                        | |
                                                  |  +----------------------------------------+ |
                                                  |  |                                        | |
                                                  |  +----------------------------------------+ |
                                                  |                                             |
                                                  |                                             |
                                                  +---------------------------------------------+
```
Модельно можно описать эту процедуру как:

* Запись ревизии
* Установка указателя `HEAD` на новую ревизию.
Такая модель очень похожа на систему контроля версий.

```
                +--------------+
HEAD  +-------> |    rev: 5    |
                +-------+------+
                        |
                        |
                +-------v------+     +--------------+
                |    rev: 4    |     |     rev: 3   |
                +----------+---+     +-+------------+
                           |           |
                           |           |
                          +v-----------v-+
                          |     rev: 1   |
                          +------+-------+
                                 |
                                 |
                          +------v-------+
                          |     rev: 0   |
                          +--------------+
```

{% note warning %}

Все изменения (в UI или API) применяются к той ревизии, на которую указывает `HEAD`.

{% endnote %}

###  Откат изменений {#versioning-rollback}

Познакомившись с моделью, мы теперь можем предложить вариант того, как откатить внесённые изменения. Есть два варианта:

1. Создать новую ревизию с содержимым идентичным предыдущей, на которую ходим откатиться.
1. Переставить `HEAD` так, чтобы он указывал на нужную нам ревизию.
Давайте рассмотрим их.

####  Создание новой ревизии {#versioning-rollback-new-rev}

![img](https://jing.yandex-team.ru/files/sshipkov/rollback-new-rev.eccfadf.png)

На странице интересующей на ревизии (снэпшота) есть кнопка "Checkout". После её нажатия:

* в UI подтянется описание этой ревизии, так будто это пользователь руками внёс изменения
* кнопка **Save** в Runtime атрибутах станет активна
* при внесении изменений старые данные будут сохранены в новой ревизии
Задача решена.

####  Перестановка HEAD {#versioning-rollback-move-head}

![img](https://jing.yandex-team.ru/files/sshipkov/rollback-move-head.a5bc7ad.png)

На странице ревизии в UI есть кнопка **Set as current**, при нажатии на которую:

* Система поднимет из базы данных описание ревизии.
* Обновит документ с описанием сервиса, тем самым переставив `HEAD`.
Все дальнейшие изменения будут накладываться уже на эту ревизию.

UI предоставляет ту же функциональность при активации ревизии != `HEAD`. Например, мы внесли изменения, выкатили ревизию, увидели проблемы, хотим откатиться, но так, чтобы другие изменения вносились уже поверх той ревизи, на которую откатываемся. Это полезно, если у нас есть автоматизированные выкладки. Для этого в диалоговом окне активации ревизии достаточно установить галочку `Set as current`. При этом система:

* Переставит `HEAD` на указанную ревизию, как описано выше.
* Начнёт процедуру активации этой ревизии.

![img](https://jing.yandex-team.ru/files/sshipkov/rollback-move-on-activate.34d9156.png)

Если такой кейс достаточно частый, то можно настроить UI, чтобы эта галочка устанавливалась автоматически. Для этого надо перейти **Information -> General Info -> UI Settings**. Внизу страницы будет доступна специальная настройка.

![img](https://jing.yandex-team.ru/files/sshipkov/rollback-set-as-current-ui.dd56401.png)
