# Автоматизированная выкладка

Автоматизация любых процессов позволяет сэкономить силы, время и нервы людей. Рассмотрим базовые механизмы автоматизации выкладки сервисов, которые доступны в репозитории сервисов.

## Service scheduler {#service-scheduler}

В репозитории сервисов есть фоновые процесс(ы), который, согласно заданным в сервисе политикам производит действия по выкладке новых ревизий сервиса.
Процесс работает в цикле каждые несколько секунд.
Рассмотрим имеющиеся настройки, доступные в разделе **Info -> Scheduling Policy**.

![img](https://jing.yandex-team.ru/files/sshipkov/service_scheduling_policies.4ce29c2.png)

## Автовыкладка новых релизов {#release-auto-deploy}

Настроив правила обработки релизов и включив автоматический коммит релизов в сервис, можно добиться полностью автоматической выкладки новых релизов. Подробнее можно посмотреть на странице [Интеграции с Sandbox](../how-to/sandbox-integration.md#auto-deploy-setup).

## No policy {#no-policy}

Значение по умолчанию. Никаких политик автоматизации не применяется. Этот пункт необходимо выбрать **для отключения** автоматизации.

## Maintain active trunk {#maintain-active-trunk}

**Поддержка транка активным** — активируется последняя ревизия (snapshot) runtime атрибутов, если:
* сервис находится в ONLINE — т.е. никаких выкладок не производится.
* текущий активная ревизия **!=** текущей ревизии в описании сервиса.

Таким образом пользователи могут вносить изменения в описание сервиса с любой частотой, а планировщик будет поддерживать всегда активной **одну** выкладку.

### Use Case {#maintain-active-trunk-use-case}

Подходит для тестовых контуров, когда необходимо автоматизировать выкладку, но при этом поддерживать активной не более одной выкладки. Например, если изменения в сервисе производятся через Sandbox или Teamcity и отдельные задачи сборки ресурсов не могут между собой согласовать очередность.

### Параметры {#maintain-active-trunk-parameters}

В качестве опции принимает имя рецепта, которым необходимо активировать снэпшот.

### Примечание {#maintain-active-trunk-remark}

Изменение в целевое состояние сервиса (выкладка) производятся от имени пользователя "nanny-robot", поэтому ему необходимо выдать права **Operations Manager**.

##  Force active trunk {#force-active-trunk}

### Use Case {#force-active-trunk-use-case}

Система ожидает появления нового снэпшота в сервисе и начинает выкладку, не дожидаясь завершения предыдущей (т.е. перехода сервиса в состояние ONLINE).
Может быть актуально для тестовых контуров.

### Параметры {#force-active-trunk-parameters}

В качестве опции принимает имя рецепта, которым необходимо активировать снэпшот.

### Примечание {#force-active-trunk-remark}

Изменение в целевое состояние сервиса (выкладка) производятся от имени пользователя "nanny-robot", поэтому ему необходимо выдать права **Operations Manager**.

## Activate snapshots sequentially {#activate-snapshots-sequentially}

### Логика {#activate-snapshots-sequentially-logic}

* Система ожидает перехода сервиса в состояние `ONLINE`.
* После этого пробегает последовательно по всем ревизиям сервиса от старших к более свежим, начиная с текущего активного, до тех пор, пока не будет найдена ревизия, которая ещё не была выложена автоматически.
* Эта ревизия будет отправлена на активацию.

### Use Case {#activate-snapshots-sequentially-use-case}

Подходит в ситуации, когда необходимо выкладывать ревизии сервиса автоматически, но при этом последовательно. Например, если в ревизиях шарды меняются инкрементально. Или необходимо выложить и проверить работоспособность каждой ревизии.

### Параметры {#activate-snapshots-sequentially-parameters}

В качестве опции принимает имя рецепта, которым необходимо активировать снэпшот.

###  Примечания {#activate-snapshots-sequentially-remarks}

{% note warning %}

Для избежания бесконечных циклов в случае ошибки, система проверят только 20 ревизий сервиса. Т.е. если после текущего активного было порождено 20 более свежих ревизий, то автоматическая выкладка производиться не будет.

{% endnote %}

* Изменение в целевое состояние сервиса (выкладка) производятся от имени пользователя "nanny-robot", поэтому ему необходимо выдать права **Operations Manager**.

## Based On Snapshot Priority {#based-on-snapshot-priority}

**Согласно приоритету ревизии** — в качестве входных данных система берёт мета информацию о ревизиях сервиса и на их основе принимает решение о том, какая ревизия должна быть активирована следующей.
Основное обсуждение было в тикете: [SWAT-2409](https://st.yandex-team.ru/SWAT-2409).

Политика работает на основании **приоритетов** ревизий. Приоритеты записываются в мета информацию о ревизии. Выставить приоритет можно:

* При внесении изменений в UI — через опцию в диалоговом окне сохранения runtime атрибутов.
* Из интерфейса можно настроить установку приоритетов в правилах обработки новых релизов (раздел "Tickets Integration"). См. [правила обработки релизов](../how-to/sandbox-integration.md#release-rules-matching-service).
* Через API при внесении изменений в runtime атрибуты сервиса.

### Логика {#based-on-snapshot-priority-logic}

Политика работает над сервисами, которые подходят под следующие условия:

* Сервис не выключен. Т.е. хотя бы одна из ревизий указана, как "должна быть активной".
* В сервисе выбрана политика "Based On Snapshot Priority".

Логика следующая:

* Получаем текущую ревизию сервиса, если она имеет (согласно данным из `.meta_info`) подходящий приоритет — запускаем выкладку.
    * Если у ревизии нет приоритета или приоритет `NONE` — ревизия игнорирутеся.
    * Если приоритет `NORMAL` **и** сервис находится в состоянии **(зел)ONLINE** — ревизия активируется.
        Т.е. применяется, если сейчас не идёт никаких других активаций и сервис не выключен.
    * Если приоритет `CRITICAL` — ревизия активируется.
* Иначе — переходим к предыдущему.
    До тех пор, пока не встретим ревизию, которая присутствует на хостах или ревизия была уже автоматически активирована.
* Повторяем цикл.
* Ведём счётчик повторов цикла — не более 20.

### Use Case {#based-on-snapshot-priority-use-cases}

Сервис пользователя (администратора) состоит из различных компонентов, которые создаются различными командами и релизы производятся независимо. Администратор хочет настроить различные политики того, что и как выкладывается автоматически. Например,

* новая версия основной компоненты (исполняемый файл демона) — выкладывать вручную, но получать уведомления о новой версии.
    Таким изменениям можно назначить приоритет `NONE`.
* новая версия init процесс (initctl) — выкладывать автоматически со следующей выкладкой, немедленная выкладка нежелательна;
* новая версия данных для сервиса (шарды) — выкладываться автоматически сразу после появляения новой версии.

### Параметры {#based-on-snapshot-priority-parameters}

Политика принимает следующие параметры:

* **Recipe to prepare snapshot** — рецепт, которым нужно выполнить подготовку (скачивание) ревизии, если эти стадии для сервиса разделены.
* **Recipe to activate snapshot** — рецепт, которым нужно выполнить активацию ревизии.

![basedonsnapshotpriorityui.png](https://jing.yandex-team.ru/files/sshipkov/based_on_snapshot_priority_ui.cea2aaa.png)

### Примечания {#based-on-snapshot-priority-remarks}

* Ограничение глубины — 20.

Рассмотрим следующую ситуацию: последние 20 ревизий сервиса — это изменения `instancectl`, которые не надо катить. 21ая — это ревизия, которую надо катить. Т.е. каждые `N` секунд, система смотрит на состояние сервиса, если он "ONLINE" — она начинает описанный в вики цикл. Если текущую ревизию не надо выкатывать, т.е. стоит посмотреть на предыдущую, может надо выкатить её. Чтобы в цикле постоянно не обходить все ревизии сервиса (и в результате ничего не найти), предлагается ограничить глубину просмотра истории изменения сервиса.
Для пользователя может быть неожиданным, что, несмотря на настройки политики выкладки сервиса, старая (21ая от текущей) ревизия никуда не выехала, хотя она соответствует правилам.

