# О чём это

Каждая ревизия (__snapshot__) `runtime` атрибутов при выкладке порождает конфигурацию в системе выкладки (CMS/ISS). После очередного обновления сервиса, текущая активная переводится в состояние `PREPARED`, т.е. остаётся как на машинах, так и в CMS/ISS. Такой механизм позволяет быстро и максимально надёжно (без выкачивания данных по сети) откатиться на предыдущую версию.
Состояние всех ревизий, которые присутствуют в системе выкладки отражены на главной странице сервиса в виде списка конфигураций. Для того, чтобы пользователям не приходилось вручную удалять старые конфигурации (которых в день может быть несколько десятков) созданы политики очистки старых конфигураций.

## Внутреннее устройство {#internals}

Подсистема политик удаления ревизий сервиса выполнена согласно [Cleanup Policy RFC](https://wiki.yandex-team.ru/infra-cloud/rfc/nanny/cleanup-policy-rfc/) с незначительными деталями реализации.
`CleanupPolicy` — объект в хранилище, в котором описаны правила удаления конфигураций. В качестве хранилища используется Zookeeper.
Отдельный демон запущен и подписан на изменения политик и состояния сервисов. При изменениях, согласно политике, выполняются действия по поддержанию необходимого количества ревизий сервиса в система выкладки/на хостах.

## Авторизация {#authz}

Действия над политиками могут выполнять только администраторы сервиса, которые имеют роль `Configuration manager`.

## Интерфейс пользователя {#ui}

Настройки политик доступны для настройки по клику на раздел **Cleanup policies** в разделе **Aspects** справа на странице сервиса.

![aspectscleanuppolicies](https://jing.yandex-team.ru/files/sshipkov/aspects_cleanup_policies.77403f8.png =500x)

При первом открытии система может показать сообщение, что политика не создана и на странице будет информационное сообщение: `Policy does not exists, it will be created.` Это означает, что политика отсутствует и при сохранении будет создана.

Если для сервиса настроена предыдущая версия политик, система также укажет на это, предложив отключить их: `Old style policy is set, please disable it first.` Для отключения предыдущей версии политик надо перейти к ней по ссылке и поменять тип политики на `No policy`.
Далее необходимо:

* Выбрать тип политики.
* Задать её параметры.
* Нажать `Save`.
После этого система сразу начнёт применять политику. Рассмотрим доступные политики.

### Simple count limit {#ui-simple-count-limit}

![cleanup-simple](https://jing.yandex-team.ru/files/sshipkov/cleanup-simple.9104d4d.png)

Это политика принимает следующие параметры:

* `Number of (PREPARED, CREATED) snapshots`: Количество "обычных" ревизий.
    Границы диапазона каждого параметра от **0 до 30** включительно.
* `Number of (PREPARED, CREATED) disposable snapshots`: Количество "disposable" ревизий.
    Это ревизии, у которых при создании был указан флаг `is_disposable` (используется в некоторых сервисах).
    Границы диапазона каждого параметра от **0 до 30** включительно.
* `Snapshot is stalled after (e.g PT24H, P30D)`: Через какой период времени после смены состояния считать ревизию "залипшей".
    Ревизия считается_ stalled_, если больше указанного времени она не достигла своего целевого состояния (только PREPARED и CREATED).
    Задаётся в формате [ISO 8601 Duration](https://en.wikipedia.org/wiki/ISO_8601#Durations), например:
    * `PT24H` — 24 часа
    * `P30D` — 30 дней


Логика работы:
При одном из событий:

* изменилось состояние сервиса
* изменились настройки политики
* периодически — несколько раз в час
работает следующая логика:
* Если указана настройка `stalled after` — то удаляются старые ревизии, вне зависимости от текущего состояния сервиса.
* Если сервис не находится состоянии `ONLINE` или `OFFLINE`, то работа политики завершается.
Это необходимо для того, чтобы не удалить лишние ревизии в случае параллельных выкладок.
* Сортирует их в порядке убывания времени указания целевого состояния.
Т.е. самые старые ревизии будут в хвосте списка.
* Пробегает по списку, считая количество ревизий, у которых целевое состояние одно из `(PREPARED, CREATED)`.
* Как только количество ревизий превысило параметр — выполняет запрос на удаление всех последующих.

> Пример:
> Если Вам нужно что бы в сервисе хранилось 3 снэпшота, в CleanUp Policies нужно указать — 2, т.к. не учитывается снэпшот ACTIVE.
> Но при этом в настройках квоты для RootFS нужно указать из расчета 4 снэпшотов, т.к. будет учитываться новый, который сгенерируется.

### Resource type count {#ui-resource-type-count}

![resourcecountlimit](https://jing.yandex-team.ru/files/sshipkov/resource_count_limit.a5e53e7.png)

Это политика принимает следующие параметры:

* `Resource type` — тип ресурса, ограничения на который необходимо накладывать (будет разобрано ниже).
* `Max number of unique resource snapshots` — максимально допустимое количество снэпшотов с различающимися ресурсами.
* `Max number of snapshots with same resource` — максимально допустимое количество снэпшотов с одним и тем же ресурсом.

Логику работы можно представить следующим образом:
`Для ревизии вычисляется идентификатор bucket'а, если количество бакетов превышено — удаляем, если количество ревизий в bucket'е превышено — удаляем`.
Разберём немного детальней.
Подготовительный этап: ревизии (снэпшоты) сортируются по убыванию времени перевода в текущее целевое состояние (`target_state`).
Для каждой ревизии последовательно выполняются следующие действия:

* Извлекается идентификатор bucket'а согласно указанному типу ресурса.
    Сейчас в этом качестве используется идентификатор таска Sandbox (либо `None`, если такого ресурса в ревизии нет).
* Если у нас есть bucket с таким идентификатором, то мы проверяем — можно ли поместить в него ревизию.
    В качестве ограничения на размер выступает значение `Max number of snapshots with same resource`. Если поместить нельзя — ревизия удаляется.
* Если bucket'а нет, то мы проверяем, можем ли мы его создать.
    Максимальное количество bucket'ов ограничено значением `Max number of unique resource snapshots`. Если создать нельзя — ревизия удаляется.
* Увеличиваем счётчик ревизий в bucket'е на 1.

Работы по реализации были проведены в рамках тикета [SWAT-3191](https://st.yandex-team.ru/SWAT-3191).

### Статус политики {#ui-status}

![cleanup-policy-status](https://jing.yandex-team.ru/files/sshipkov/cleanup-simple.9104d4d.png)

Система отображает текущий статус политики и информационное сообщение. Статус может быть одним из следующих:

* `Idle` — политика в данный момент не активна, т.к. состояние системы не предполагает действий.
* `Error` — при применении политики произошла ошибка.
* `Active` — политика в данный момент выполняет какие-либо действия.

### Удаление политики {#ui-remove-policy}

В любой момент политику можно удалить, нажав на кнопку **Remove**. При этом система удалит соответствующий объект в хранилище и прекратит все действия, связанные с автоматическим удалением ревизий сервиса.

## API {#api}

Для управления политиками через API можно воспользоваться [API репозитория сервисов](../rpc/repoapi.md).
