# Управление состоянием сервиса на машинах

Состояние сервиса на кластере можно описать набором кортежей `(snapshot_id, current_state, target_state)`:

* **snapshot_id** - идентификатор ревизии runtime атрибутов;
* **current_state** - текущее состояние ревизии на машинах;
* **target_state** - целевое состояние ревизии на машинах.

![snapshotstatesexample](https://jing.yandex-team.ru/files/sshipkov/snapshot_states_example.8b65527.png)

##  Изменение текущего снэпшота при активации (HEAD) {#set-as-current}
В модели снэпшотов nanny присутствует понятие **HEAD** (**current**) снэпшота. HEAD это:

1) Указатель на снэпшот, поверх содержимого которого будут применяться изменения, вносимые в UI;
1) Это **не обязательно активный** снэпшот;
1) При создании нового снэпшота он автоматически помечается как **HEAD**;
1) По умолчанию при активации снэпшота он **не помечается** как **HEAD**.

Логику пункта (4) можно поменять, воспользовавшись флажком `Set snapshot as current upon activation` в `Info attrs` сервиса. Если установить этот флажок (выставить в `true`), то при старте активации снэпшота он автоматически будет помечен как **HEAD**.

##  Целевое состояние {#service-target-state}
Существуют следующие целевые состояния:

* **DESTROYED** - ревизия не должна присутствовать на хостах и в системе выкладки (CMS/ISS).
Это состояние используется только в командах API, в результате выполнения команды ревизия удаляется из набора кортежей целевого состояния.
* **CREATED** - ревизия должна быть создана в системе выкладки (CMS/ISS).
На практике это означает приводит к следующим действиям:
    * Генерируется конфигурация в терминах CMS/ISS, если ещё не создана.
    * Если конфигурация приготовлена на машинах, в CMS/ISS отдаётся команда, что конфигурация на машинах не требуется. Агенты на машинах могут её удалить в случае необходимости.
* **PREPARED** - ресурсы ревизии должны присутствовать на хостах.
Это состояние включает в себя состояние **CREATED**, т.е. сначала конфигурация будет создана, затем подготовллена.
* **ACTIVE** - инстансы этой ревизии должны быть активны на хостах
В этом состоянии может находиться только одна ревизия (snapshot). При переводе ревизии в это состояние, текущая активная неявно переводится в состояние **PREPARED**.

##  Текущее состояние {#service-current-state}
Существуют следующие текущие состояния:

* **GENERATING** - создаётся конфигурация в CMS/ISS
* **ACTIVATING** - конфигурация активируется на хостах.
    В этом состоянии может находится только одна ревизия.
* **DEACTIVATING** - конфигурация деактивируется.
* **ACTIVE** - конфигурация активна.
    Т.к. в общем случае в один момент времени могут быть активны инстансы разных ревизий (если несколько выкладок подряд не завершались успехом), то для избежания разночтений в этом состоянии может находится только одна ревизия.
* **BROKEN** - (так же PARTIALLY_ACTIVE) конфигурация может быть активна на части инстансов.
    Возникает, когда одна выкладка/активация была прервана. Например, таскгруппа активации завершилась аварийно, либо новая ревизия была активирована в процессе.
* **PRERARING** - конфигурация подготовливается на хостах.
* **PARTIALLY_PREPARED** - конфигурация может быть подготовлена на части инстансов.
    Возникает, когда одна выкладка/активация была прервана. Например, таскгруппа активации завершилась аварийно, либо новая ревизия была активирована в процессе.
* **PREPARED** - конфигурация была подготовлена на хостах.
* **REMOVING** - конфигурация удаляется с хостов.
    В CMS/ISS с инстансов снимается флаг PREPARED.
* **DESTROYING** - конфигурация удаляется из CMS/ISS
* **PARTIALLY_CREATED** - конфигурация может быть частично создана в CMS/ISS.
    На практике такое может быть только с CMS. Конфигурация в ISS создаётся атомарно.
* **CREATED** - конфигурация создана в CMS/ISS.
    При этом на хостах ресурсов для конфигурации нет (может не быть).
* **DEACTIVATE_PENDING** - (служебное) Конфигурация неявно деактивируется активацией другой ревизии.
    Это служебное состояние указывает внутреннему автомату системы, что действий предпринимать не надо.
    В этом состоянии может находиться **несколько** ревизий, в случае если несколько выкладок подряд не были доведены до конца.
    После активации это текущее состояние сменится на **BROKEN** и будет запущен процесс деактивации.
* **DESTROYED** - (служебное) Конфигурация удалена из CMS/ISS.
    Используется внутри системы, пользователи не должны видеть.
* **ACTIVATION_MUST_BE_CANCELLED** - (служебное) Активация должна быть отменена и переведа в состояние **DEACTIVATE_PENDING**.
    В API не используется, пользователям не возвращается, в базу не сохраняется.

##  Управление состояниями через UI {#service-states-ui}
Обладая описанными выше знаниями про модель состояний сервиса можно перейти к её управлению.
В UI на главной странице представлены ревизии сервиса и их состояния:

![service_states_mgmt](https://jing.yandex-team.ru/files/sshipkov/service_states_mgmt.5663731.png)

Каждый элемент списка ревизий отображает следующую информацию:

* Верхняя строчка: информация о ревизии (snapshot'е): идентификатор, автор, дата, комментарий. **У старых ревизий** эти поля могут отсутствовать.
* Левый столбец: информация о текущем состоянии: время, таскгруппа, конфигурация.
* Центральный столбец: информация о целевом состоянии: дата, автор изменений, (опционально) тикет.
* Правый столбец: Кнопки действий над snapshot'ом.

Рассмотрим пример.

* Первой в списке всегда отображается текущая ревизия runtime атрибутов. В данном примере конфигурация не создана, на хостах не присутствует, поэтому поля _current_ и _target_ пусты.
* Вторым в списке на скриншоте представлен текущий активный.
Кнопка действий над текущим активным снэпшотом недоступна. Для отключения сервиса можно воспользоваться кнопкой "Stop service" вверху страницы. Для активации другого snapshot'а, надо **явно** активировать другой. Такой подход к UI может быть не очень удобным, но позволяет минимизировать ошибки оператора.
* Третьим в списке представлен снэпшот, который в данный момент помечен как **PREPARED** на хостах.

**Целевое** состояние снэпшота можно изменить по клику на кнопку "Change". После клика откроется следующее диалоговое окно.

![service_state_change](https://jing.yandex-team.ru/files/sshipkov/service_state_change.474c163.png)

В нём можно выбрать новое целевое состояние снэпшота и нажать "Apply". После этого на сервер отправится команда, которая будет сохранена в очереди и затем асинхронно обработана.

##  Управление состояниями инстансов {#instance-states-ui}
У ревизии сервиса можно посмотреть список инстансов (**1**). У каждого инстанса указано текущее(**2**) и целевое(**3**) состояние. Целевое состояние можно поменять, нажав на кнопку с изображением шестеренки (**4**).

![snapshotinstances](https://jing.yandex-team.ru/files/sshipkov/snapshot_instances.01b84b9.png)

Откроется диалоговое окно.

![instancetargetstatemodal](https://jing.yandex-team.ru/files/sshipkov/instance_target_state_modal.897626b.png)

В нем можно выбрать новое целевое состояние инстанса и нажать "Apply".
Есть следующие ограничения:

* Состояние всей ревизии при этом отслеживаться Няней не будет. Т.е. если пользователь перевёл руками все инстансы из состояния `PREPARED` в `ACTIVE`, то Няня по-прежнему будет отображать состояние всей ревизии как `PREPARED`.
* При выкладке/откате ручные изменения теряются.

##  Ограничения в управлении состояниями YpLite-инстансов {#instance-states-yplite-restrictions}
Инстансы **YpLite**-сервисов могут находиться в состоянии `UNKNOWN` -> `UNKNOWN`.

![state](https://jing.yandex-team.ru/files/sshipkov/Выделение_046.9ae6b31.png)

Это значит, что в инстансах ещё нет необходимой конфигурации, поэтому выполнять действия над ними ещё нельзя. В таком состоянии инстансы находятся до тех пор, пока на них не начала выполняться стадия `PREPARING` или `ACTIVATING`.

Это поведение можно поменять - тогда конфигурация в инстансы будет приноситься ещё до стадии `PREPARING`/`ACTIVATING`. Для этого есть флаг `Fill pods configuration`, который можно выставить при переводе снэпшота в состояние `Present in YP/ISS only`.

![screenshot](https://jing.yandex-team.ru/files/sshipkov/Screen%20Shot%202021-03-18%20at%205.22.44%20PM.c39329c.png).

##  Подробнее про текущие состояния инстансов {#iss-states-definitions}

 **Было** | **Станет** | **Описание** 
 :--- | :--- | :---
 _Инстанс находится в целевом состоянии_ | | 
 **`ACTIVE`** | **`Active`** | 
 **`PREPARED`** | **`Prepared`** | 
 **`REMOVED`** | **`Removed`** | 
 _Сборка инстанса_  | | 
 **`ENTITY_RESOURCES_NOT_READY`** | **`Downloading`** | В процессе скачивание файловых ресурсов, слоёв файловой системы и других запчастей инстанса. 
 **`DOWNLOAD_FINISHED`** | **`Downloaded`** | 
 **`ISS_HOOK_INSTALL_JUST_SCHEDULED`** | **`Install scheduled`** | 
 **`ISS_HOOK_INSTALL_IN_PROGRESS`** | **`Installing`** | 
 **`SHARD_SETUP_SUCCESS`** | **`Shard installed`** | 
 **`RESOURCE_CHECKSUM_INVALID`** | **`Invalid checksum`** | Не сошлась чексумма одного из скачанных ресурсов. 
 _Запуск инстанса_  | | 
 **`SLOT_LOCKED`** | **`Pending`** | Ожидаем выключения старой конфигурации инстанса, чтобы запустить текущую новую. Например, в предыдущей конфигурации выполняется `stop_script` или `Stop Policy`, как только они завершатся, мы начнём запускать новую конфигурацию.
 **`HOOK_SEMI_FAILED`** | **`Activating`** | Контейнеры инстанса созданы, instancectl запущен, но внутри контейнеров пока не удалось корректно запустить пользовательские процесы. Популярные причины: падает один из запускаемых процессов пользователя;  все процессы запущены, но не может успешно завершиться проверка живости инстанса или `status_script`
 **`DAEMON_EXITED`** | **`Exited`** | instancectl завершился. Это происходит как в случае штатного выключения инстанса, так и из-за проблем инстансом, вызвавшим завершение instancectl, например, если из-за проблем с porto был разобран контейнер инстанса. 
 **`DAEMON_CANCELLED`** | **`Cancelled`** | Запуск инстанса был отменён. Например, запуск конфигурации был отменён в пользу более свежей конфигурации.
 _Общие статусы_  | |  
 **`DAEMON_WAS_TERMINATED_EXTERNALLY`** | **`Killed`** | Контейнер инстанса был убит внешним сигналом. В большинстве случаев это OOM, т.е. убийство контейнера из-за превышения лимита потребляемой памяти. 
 **`PORTO_CONSTRAINTS_ERROR`** | **`Resource overcommit`** | Поселенным на хост инстансам роздано ресурсов больше, чем на хосте есть по факту, из-за чего не удаётся собрать контейнер инстанса. 
 **`UNKNOWN`** | **`Unknown`** | Информации о состоянии инстанса нет. В большинстве случаев это означает, что с хоста, где был запущен инстанс, давно не поступало никакой информации. Возможные причины: Хост выключен; Хост находится в неуправляемом состоянии из-за проблем с железом или операционной системой или критичной поломкой ISS-agent.
 **`HOOK_FAILED`** | **`Failing`** | Некорректно завершился хук инстанса. В большинстве случаев это проблема на `PREPARE`-фазе: Не отрабатывает init-контейнер или `prepare_script`; Не удалось извлечь секреты, указанные в сервисе: они удалены из секретницы или в секрете не выдан доступ на сервис в случае Nanny Vault. 
 **`HOOK_IN_PROGRESS`** | **`Hook in progress`** | Идёт исполнение одного из хуков инстанса, например, `iss_hook_stop` для остановки инстанса, или `iss_hook_uninstall` для его разбора. 
 **`HOOK_CANCELLED`** | **`Hook cancelled`** | Исполнение одного из хуков инстанса было отменено (в контейнер хука прилетел SIGKILL). Например, после начала `PREPARE`-фазы она была отменена. 
 **`TIME_LIMIT_VIOLATION`** | **`Timed out`** | Превышено время выполнения одного из хуков. В большинстве случаев это означает один из вариантов: Превышено время выполнение init-контейнера или `prepare_script`; Не удалось извлечь секреты, указанные в сервисе: они удалены из секретницы или в секрете не выдан доступ на сервис в случае Nanny Vault; Проблема с выполнением одного из хуков или instancectl из-за того, что хост-машина перегружена или не хватает ресурсов в контейнере.
 **`INVOCATION_FREQUENCY_LIMIT`** | **`Retrying`** | Предыдущий запуск хука (или другого рутинного действия) закончился неуспешно, выжидаем перерыв перед следующим повтором действия или запуска хука. 
 _Обновление динамических ресурсов_ | |  
 **`ACTIVATED_INSTANCE_DYNAMIC_RESOURCES_NOT_READY`** | **`Downloading dynamic resource`** | Инстанс запущен и идёт скачивание динамических ресурсов. 
 **`NOTIFY_HOOK_FAILURE_STATE_INTERCEPTED`** | **`Notify failed`** | Некорректно завершился `notify_script` или `Notification action`, они будут перезапущены до тех пор, пока не завершатся успешно. 
 **`DYNAMIC_RESOURCE_NOTIFY_EXECUTION`** | **`Notifying`** | В процессе выполнения `notify_script` или `Notification action`. 
 **`DYNAMIC_RESOURCE_PREPARATION_FAILURE`** | **`Dynamic resource prepare failed **`** | Не удалось вмонтировать скачанные динамические ресурсы в контейнер инстанса. 
 _Проблемы с хостовой инфраструктурой_  | |  
 **`PORTO_FAILURE`** | **`Porto failure`** | 
 **`PORTO_UNAVAILABLE`** | **`Porto unavailable`** | 
 **`SKYNET_FAILURE`** | **`Skynet failure`** | 
 **`SKYNET_TIMEOUT`** | **`Skynet timeout`** | 

##  Управление реакциями на события {#service-pause-resume}
Каждое изменение состояния сервиса обрабатывается асинхронно и может быть описано следующим алгоритмом:

* Сохранение события в базе данных.
* Обработка события: пересчёт текущего и/или целевого состояния ревизий (snapshot'ов) сервиса на хостах.
* Выполнение действий для приведения сервиса к целевому состоянию: запуск, останов рецептов.
Система поддерживает возможность установить сервис "на паузу", при этом все события будут обрабатываться, но действия выполняться не будут, до получения события "продолжить выполнение действий". Управление данным функционалом осуществляется через UI:

![service_pause_resume](https://jing.yandex-team.ru/files/sshipkov/service_pause_resume.b4aade1.png)

* Если сервис установлен "на паузу", то будет доступна кнопка "Resume actions", а информация о постановке "на паузу" будет отображаться рядом с текущим состоянием сервиса.
* Если сервис реагирует на события, то будет доступна кнопка "Pause actions".

**Авторизация:** выполнять указанные действия могут пользователи с ролью _operations manager_.

##  Отключение сервиса {#stop-service}
Если сервис находится в любом состоянии, кроме Offline, то при клике на кнопку "Stop service" на главной странице - Система поставит в очередь событие с требованием отключить сервис. Для текущего активного снэпшота будет выставлено целевое состояние **PREPARED**. При этом все активные snapshot'ы будут деактивированы с помощью зашитого в исходном коде рецепта. Все таскгруппы alemate, которые выполняют действия над этим snapshot'ом - будут отменены.