# Инструкция YP-lite

В Няне появилась поддержка выделения ресурсов через YP — YP.Lite.

## YP.Lite {#yp-lite}

YP управляет ресурсами кластера: выделяет требуемые мощности среди доступных ресурсов.
Няня заказывает мощности в YP, деплоит сервисы с учетом деградации и живости инстансов. Пользователи (сервисы) запрашивают у Няни информацию о местонахождении сервисов.

YP.Lite позволяет разворачивать контейнеры под управлением YP.

Ограничения:
* изменять параметры запрошенных мощностей нельзя, можно только добавлять-удалять новые;
* не учитывается диск при поиске хоста для выделения ресурсов.

## Как выделить ресурсы в YP-lite {#allocate-resources}

### Изолируем сервис {#service-isolating}

Изоляция и квотирование в YP имеют принципиальное значение. В YP можно использовать только сервисы с квотами, изоляцией и в MTN-сетях.

#### Указываем квоты на Workdir и RootFS {#quotas-workdir-rootfs}

Нужно установить правильные значения квот на RootFS и на Workdir в рамках одного снепшота.

![img](https://jing.yandex-team.ru/files/sshipkov/2018-03-1914-22-27.4957a7d.png)

### Указываем ABC-сервис {#abc}

Квотирование вычислительных ресурсов в YP будет происходить на базе модели [ABC](https://abc.yandex-team.ru/). Поэтому в Nanny-сервисе нужно указать ссылку на ABC-сервис, чтобы было понятно, из чьей квоты брать вычислительные ресурсы. Вписать его сможет только человек, обладающий хотя бы какой-то ролью в ABC-сервисе.

### Указываем Deploy Engine и Instances {#deploy-engine}

Нужно выбрать для **Deployment engine type** значение `YP_LITE`, для типа аллокации инстансов `YP pods`.

![img](https://jing.yandex-team.ru/files/sshipkov/Image_2018-02-16_19-18-54.e8441c7.png)

![img](https://jing.yandex-team.ru/files/sshipkov/2018-03-19_14-22-27.4957a7d.png)

### Создаем аллокацию {#create-allocation}

В терминах YP выделение ресурсов называется аллокацией. Указываем требования к инстансам (подам). Параметры аллокаций (процессор, память, диск) изменять нельзя, можно только создавать-удалять новые аллокации. Для простоты можно считать, что аллокация - близкая аналогия группы Gencfg.

![img](https://jing.yandex-team.ru/files/sshipkov/Monosnap_2018-03-23_19-45-07.dd355aa.png)

#### Выбираем кластер {#cluster}

YP является локационным, поэтому нужно явно указать кластер, где выделяются ресурсы.

#### Указываем число реплик {#replicas}

Количество инстансов. Количество реплик не может превышать число хостов. Если число реплик сервиса указано больше, чем хостов в YP, то ресурсы не будут выделены никогда. Когда все хосты переедут под управление YP это станет не критичным, но на период тестирования лучше не заказывать больше 50 реплик.

#### Указываем гарантии и лимиты на процессор {#cpu}

Гарантии и лимиты CPU, рассчитываются по модели Gencfg. При выборе места размещения инстансов учитываются только гарантии на процессор и память.

#### Указываем гарантии и лимиты на памяти {#memory}

Гарантии и лимиты на память.

#### Выбираем сетевой макрос из Racktables {#macros}

Сетевой макрос из Racktables. YP работает только в MTN сетях, где IP-адрес выделяется на основе сетевых макросов. Поэтому необходимо явно указывать сетевой адрес при создании контейнера. Если вы создаете сервис в дополнение к GenCfg, то лучше всего взять сетевой макрос оттуда.

![img](https://jing.yandex-team.ru/files/sshipkov/Monosnap_2018-03-19_14-07-21.9fc15bd.png)

Макрос можно создать самостоятельно в Racktables [Создание макроса в racktables](https://wiki.yandex-team.ru/NOC/newnetwork/hbf/projectid/project-id-allocation/#opisanieformy).

Однако если создавать макрос в racktables, то надо будет самостоятельно заказывать все доступы к этому макросу ("дырки").
Можно также создать макрос через интерфейс gencfg [создать макрос в gencfg](https://gencfg.yandex-team.ru/create_macros), тогда у макроса будут стандартные доступы searchprodnet.

#### Указываем персистентные тома, которые нужно замонтировать {#volumes}

Точка монтирования постоянных томов, как в Gencfg (volumes.json). Эти тома являются персистентными и не зависят от текущего снепшота.
В этом поле укажите точку монтирования и дисковую квоту по каждому тому.

#### По желанию изменяем тип именования подов {#pod-names}

По-умолчанию подам присваиваются имена в виде случайной последовательности символов. Можно изменить это на пронумерованные поды. Для этого при аллокации надо выбрать в списке **How to name pods**: `Enumerated replicas` вместо `Random string`.

Расположение раскрывающегося списка:

![img](https://jing.yandex-team.ru/files/sshipkov/2019-04-01_14-16-15.9aa0447.png)

Следует учитывать, что при эвакуации пода его порядковый номер изменится на +1 от максимального. [https://st.yandex-team.ru/SWAT-4599#5ca1f3c2a2e448001edc4a04](https://st.yandex-team.ru/SWAT-4599#5ca1f3c2a2e448001edc4a04)

#### Смотрим список подов {#pods-list}

В сервисе может быть много аллокаций, их можно увидеть в этом разделе.
Удалить аллокацию можно только если нет снепшотов, работающих на ней, т.е. аллокация должна быть пустая.

В YP у каждого пода есть два fqdn:

* переменный. Зависит от местоположения, нужен для ответа на вопрос: что за IP-адрес ко мне пришел;
* постоянный. Сохраняется у пода на всем его времени жизни.

В списке подов показывается постоянный fqdn.

Картинка, хосты не выделены
![img](https://jing.yandex-team.ru/files/sshipkov/YP_Pods__slonnn-yp-test2__Services__Home_2018-02-16_19-30-16.2671d50.png)

Картинка, хосты выделены
![img](https://jing.yandex-team.ru/files/sshipkov/YP_Pods__slonnn-yp-test2__Services__Home_2018-02-16_19-40-40.96fb5cc.png)

### Добавляем поды к сервису и перевешиваем itypes {#pods-itypes}

Выбираем в поле **Chosen type of instances** значение YP pods. С помощью **Add YP pods allocation** добавляем выделенные ранее ресурсы.
Теги инстансов (itypes) раньше указывались в Gencfg, теперь их нужно указать в Няне.

![img](https://jing.yandex-team.ru/files/sshipkov/Instances__slonnn-yp-test2__Services__Home_2018-05-23_09-31-39.6446820.png)

## Наполняем сервисы {#fill-services}

Стандартным способом добавляем файлы в поды и активируем снепшоты.

Сервис активируется на выделенных ресурсах.

![img](https://jing.yandex-team.ru/files/sshipkov/slonnn-yp-test__Services__Home_2018-02-16_20-15-24.1e55662.png)

### Отличия от Gencfg {#gencfg-diff}

#### BSCONFIG_IPORT {#bsconfig-iport}

В MTN сетях можно использовать полный диапазон портов, поэтому `BSCONFIG_IPORT` всегда равен `80`.
[Подробнее.](https://wiki.yandex-team.ru/yp/yp-iss-environment/)

