# Replication Policy

## О чём это? {#intro}

Для `YP-lite`-сервисов в Няне реализована поддержка репликации подов, находящихся на умерших хостах. Политика недоступна для сервисов на gencfg-группах. Для сервисов на `YP-lite` созданных после 22.03.2019 она включена по умолчанию.

### Как поменять настройки политики репликации {#settings-update}

Зайти в раздел Replication Policies сервиса:

![img](https://jing.yandex-team.ru/files/sshipkov/2019-03-11_14-22-55.5915ce8.png)

## Методы переноса подов {#pods-move}

Доступно два способа переноса подов, описанные ниже.

### Копирование пода с последующим удалением {#pods-remove}

{% note warning %}

Это legacy-политика переселения с рядом критических недостатков, главный из которых - она не может работать при наличии невыкаченных ревизий сервиса. Крайне не рекомендуется к использованию, вместо неё следует использовать политику [Move pod](https://docs.yandex-team.ru/nanny/reference/yp/replication-policy#replication-move).

{% endnote %}


Включается политикой `Create new pod and delete old pod`. Поддерживает возможность переноса пода в полуручном режиме.

Коротко:
* Создаётся копия старого пода, требующего переноса (при этом сам старый под не будет удалён);
* Выкладывается новый снэпшот сервиса на свежесозданную копию пода;
* Только после этого старый под будет удалён.

Подробно:
1. Происходит поиск подов сервиса на умерших хостах (прикреплённых к HEAD-снэпшоту сервиса). Реплицироваться будут только эти поды;

    {% note warning %}

    Последний снэпшот сервиса должен быть активен, иначе репликация не начнётся (если это не подходит, можно использовать эвакуацию типа [Move pod](#replication-move)).

    {% endnote %}

1. Создаются реплики для N или менее умерших подов (число задаётся в настройках политики). Под-реплика является точной копией умершего пода по потребляемым ресурсам. При этом под-реплика зашедуллен на работающем хосте.
1. Происходит замена умерших подов на соответствующие поды-реплики. Старые поды при этом не удаляются сразу же, а только после того, как перестанут быть активными.
1. Если в сервисе есть закоммиченные, но не выкаченные изменения, то ждём, пока они не будут выкачены.
1. Выполняется создание нового снэпшота сервиса с заменёнными подами.
1. Выполняется его активация.
1. Возвращаемся к п. 2 до тех пор, пока в HEAD-снэпшоте есть умершие поды.
1. После того, как заменённые поды деактивируются (но в них могут остаться PREPARED-ревизии), они удаляются из YP.

Создание политики репликации триггерит процесс удаления реплицированных подов (чистка).

Реплицированный под подлежит удалению, если:
1. Для пода есть аллоцированная реплика.
2. Реплицированный под НЕ находится в HEAD-снэпшоте И НЕ находится в снэпшоте с одновременно активными текущим и целевым состояниями.
3. Сервис находится в состоянии **ONLINE** или **OFFLINE**

{% note warning %}

Важно отметить, что после удаления реплицированного пода не будет возможности откатиться на снэпшот с этим подом.

{% endnote %}

#### Ручное подтверждение переноса {#manual-move}

Поддержана возможность ожидания ручного подтверждения в рецепте активации снэпшота, содержащего новый под. Для этого необходимо отметить соответствующие опции политики репликации:

![img](https://jing.yandex-team.ru/files/sshipkov/Screenshot%20from%202019-05-24%2017-45-37.c933f7d.png)

Включить уведомления о выкладках сервиса (в том числе при эвакуации): [инструкция](../../how-to/deploy-notifications-howto.md).
При наличии флага `Wait for manual confirmation before new pod activation`:
1. После создания нового пода и запуска рецепта активации он будет находиться в состоянии ожидания ручного подтверждения. Чтобы запустить его, достаточно выполнить команду старт на первой задаче в таскгруппе активации.
    При наличии флага `Wait for manual confirmation before old replace pod shut down`:
2. После активации нового пода рецепта будет находиться в состоянии ожидания ручного подтверждения. Чтобы завершить его, нужно выполнить команду старт на последней задаче в таскгруппе активации.

![img](https://jing.yandex-team.ru/files/sshipkov/Screenshot%20from%202019-05-24%2017-51-57.4c7a450.png)

![img](https://jing.yandex-team.ru/files/sshipkov/Screenshot%20from%202019-05-24%2018-08-19.1dd4188.png)

![img](https://jing.yandex-team.ru/files/sshipkov/Screenshot%20from%202019-05-24%2018-08-19%20%281%29.f6cd381.png)

### Одновременное удаление и создание пода с сохранением ID {#replication-move}

Включается политикой `Move pod`. Также, как и `Create new pod and delete old pod`, не работает во время деплоя сервиса.

Алгоритм:
1. Под удаляется со старого хоста;
2. Запускается поиск нового хоста для размещения пода (хост подбирается не мгновенно и может вообще не быть найден, если на кластере кончились ресурсы);
3. После аллокации пода на новый хост, происходит его запуск на нём;
4. Поды переносятся не чаще, чем указано в параметре `Minimal time period between two sequential evictions (seconds)`.

Достоинства:
1. Не происходит оверкоммит квоты для создания копии уносимого пода;
2. Сохраняется pod id, это позволяет на новом хосте поду подниматься с теми же данными, что можно использовать для шардированных сервисов;
3. Перенос происходит в обход снэпшотов сервиса и не отражается в истории снэпшотов. Если эвакуация произойдёт после выкладки релиза, который захочется откатить, то не случится отката на старый под (такая проблема актуальна для эвакуации через копирование подов).

Недостатки:
1. Доступ к поду по его FQDN становится возможным только для ручной отладки, т.е. делать запросы в поды по их FQDN в продакшн нельзя. Вместо DNS для получения IP-адреса пода нужно использовать YP Service Discovery. Для этого можно использовать существующую [библиотеку C++](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_service_discovery/libs/client) и [python](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_service_discovery/python/resolver). 
    Мотивация: поскольку при переносе меняется IP-адрес пода, какое-то время запросы DNS-запросы по данному поду будут возвращать старый неактуальный IP-адрес.
2. Перенос происходит в обход снэпшотов сервиса и не отражается в истории снэпшотов. Это снижает observability. В дальнейшем это будет починено или с использованием истории объектов в YP, или введением дополнительной истории в Nanny. Тикеты: [YP-863](https://st.yandex-team.ru/YP-863) и [SWAT-5682](https://st.yandex-team.ru/SWAT-5682).


#### Эвакуация шардированных сервисов {#shards}

В YP-lite [поддержан запуск шардированных сервисов](../../how-to/yp-lite-shards.md). Пошардовый бюджет эвакуации поддержан в политике `MOVE pod`. Настраивается с помощью двух свойств:
* `Group pods by value of given attribute` — по значению какого лейбла группировать поды. В нём нужно указать путь до того `label`, который одинаков для подов шарда и был указан при создании подов в `Apply antiaffinity constraints to all pods with the same value of given attribute`.
* `Max number of unavailable pods within a group` — бюджет на эвакуацию в пределах группы

### Ручное подтверждение эвакуации с сохранением fqdn пода {#manual-keep-fqdn}

Сделано по мотивам [тикета](https://st.yandex-team.ru/SWAT-7666).


[Пример использования](https://okkk.at.yandex-team.ru/777).

Политика выключает перенос подов сервиса для дефрагментации кластера и замедляет проведение работ на железе, т.к. для их части будет требоваться участие человека. Поэтому она **доступна только для stateful-сервисов и права на её использование выдаются по запросу в команду Nanny**.
Политика будет соглашаться на проведение недеструктивных коротких работ на хостах (с учётом простейшего бюджета) без призыва человека. А для длинных работ или полного вывода хостов, а также при эвакуации из-за поломки хостов будет срабатывать призыв человека.

После получения прав на использование политики, её можно включить на вкладке `Replication policies`:
![img](https://jing.yandex-team.ru/files/sshipkov/Screenshot%20from%202021-02-09%2018-01-22.fc38da3.png)

После этого поды будут соглашаться на короткие maintenance (такие, как ребуты хостов) без призыва пользователя. Но пробовать эвакуироваться будут только с разрешеня пользователя.

#### Как подтверждать eviction? {#eviction-accept}

Данная политика `Manual move` появилась для того, чтобы облегчить процесс переноса подов кворумных сервисов, чувствительных к появлению фантомных реплик. Её отличие от других политик в том, что она позволяет:
1. Сохранять fqdn и ID подов при их эвакуации так же, как обычная политика `Move`, и при этом:
1. При участии человека избежать появления фантомных реплик: подов, для которых уже поднята замена на новом хосте, но при этом старый под тоже продолжает функционировать, оставшись на неуправляемой машине.

Чтобы эвакуировать под с гарантией его выключения на старом хосте, нужно проделать следующие шаги:
1. Перевести эвакуируемый под в состояние `PREPARED` через [UI инстансов сервиса](../state-managment.md#instance-states-ui)
1. Убедиться, что инстанс выключился и его текущее состояние тоже стало `PREPARED`
1. Если этого не происходит, **следующие шаги выполнять не нужно**, иначе, если у вас кворумный stateful-сервис, то в кворуме появится две реплики с одинаковым ID, что может привести к потере или повреждению реплицируемых данных. Вместо этого нужно обратиться в [rtc-support](https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q), чтобы убедиться, что старая машина или выключена и или переналита, или не будет больше включена, чтобы на ней больше никогда не могла ожить старая реплика.
1. Подтвердить переезд пода можно [через API](https://a.yandex-team.ru/arc/trunk/arcadia/infra/nanny/yp_lite_api/proto/pod_sets_api.proto?rev=r7843312#L603) или на вкладке с подами кнопкой `Acknowledge pod eviction`:

    ![img](https://jing.yandex-team.ru/files/sshipkov/Screenshot%20from%202021-02-09%2018-02-19.7bc9860.png)

1. Дождаться пока под будет перенесён на новую ноду. Убедиться в переносе можно, проверив, что на вкладке `View pods` у переносимого пода поменялся атрибут `Node`.
1. Перевести эвакуируемый под в состояние `ACTIVE` через [UI инстансов сервиса](../state-managment.md#instance-states-ui)

##### Планы развития политики {#plans}

По-хорошему призывать человека не нужно, если мы сами смогли выключить реплику на хосте, с которого её нужно эвакуировать. А призывать только в том случае, если нода неуправляемая и выключить реплику на ней не удаётся. Тогда участие человека было бы сведено к минимуму и ограничивалось только случаями поломок машин, приводящих к их переходу в неуправляемое состояние. Про это есть цель <https://goals.yandex-team.ru/filter?goal=89517>.

### Информирование о репликации подов {#notification-policy}

Можно включить нотификацию о перезеде подов чекбоксом "Enable notification policy"

{% note info %}

При включении ручного подтверждения репликации автоматически включается и Notification policy.

{% endnote %}

![img](https://jing.yandex-team.ru/files/sshipkov/Screenshot_2020-02-27%20Replication%20Policies%20rtcbutler%20Services%20Home.6f43406.png)

Механизм оповещения следующий:
1. Для всех подов в состоянии `eviction requested` проверяется состояние флага `Enable notification policy`.
2. Если флаг активирован — то заводится тикет об эвакуации в очередь [https://st.yandex-team.ru/YPCLOUDMAINTEN](https://st.yandex-team.ru/YPCLOUDMAINTEN)
3. Исполнителем назначается дежурный из abc-сервиса, к которому приписан nanny-сервис, или один из владельцев nanny-сервиса в панели Administrators, если календаря дежурных у привязного abc-сервиса нет.
4. В случае включенного ручного подтверждения и отсутствия активности в тикете ответственный призывается в него раз в 2 дня.

### Регламентные работы без переноса подов {#kind-of-maintenances}

Существует возможность переживать ребуты и другие _потенциально безопасные_ работы без переноса подов. Для этого нужно перевести флажок `Kind of maintenances available for service` в состояние `All`.

![img](https://jing.yandex-team.ru/files/sshipkov/Снимок%20экрана%20от%202020-07-22%2013-30-38.b173f82.png)

В сервисе нужно указать максимальную длительность даунтайма, которую поды сервиса могут пережить. Если на их хостах запланирована более короткая работа, то поды будут не эвакуироваться, а уходить в даунтайм на время работы. Если за указанное время работы завершить не удалось, под переедет в другое место.

Максимальную допустимую длительность даунтайма имеет смысл выставлять хотя бы в 30 минут (1800 секунд), потому что самые короткие работы в Wall-e (в т.ч. ребуты хостов) имеют ожидаемую длительность от получаса.

В случае метода репликации Move, работы будут выполняться на числе подов не больше указанного в политике репликации (параметр `Number of pods in all clusters to replace at one time`).
В случае метода Copy&Replace — за это отвечает отдельный параметр `Max number of pods may be unavailable during the maintenance`.

### Общее число недоступных подов {#pods-down-count}

В обоих типах политик репликации есть параметр, отвечающий за максимальное число подов, которое может одновременно быть недоступно. Поддержана возможность настраивать его, как абсолютное число:

![img](https://jing.yandex-team.ru/files/sshipkov/Снимок%20экрана%20от%202021-01-19%2014-09-59.e25be41.png)

или в процентах:

![img](https://jing.yandex-team.ru/files/sshipkov/Снимок%20экрана%20от%202021-01-19%2014-10-10.bbc85b3.png)

Не всем удобно настраивать себе бюджет в процентах, при этом часто пользователь увеличивает число подов в сервисе, оставляя бюджет прежним (например, в 1 под). Такие ситуации приводят к тому, что один недоступный под блокирует эвакуацию всех остальных подов в сервисе.

Для этого мы поддержали "компромиссный" режим, в котором число недоступных подов настраивается абсолютно, но не может быть меньше 5% от общего числа подов в сервисе:

![img](https://jing.yandex-team.ru/files/sshipkov/Снимок%20экрана%20от%202021-01-19%2014-05-59.ce6ecbc.png)

### Тушение подов перед эвакуацией {#shutdown-pod-policy}

Бывают ситуации, когда сервер в облаке уже сломан, но не до конца, и продолжает частично функционировать. Например, контейнеры на нём продолжают работать и обслуживать запросы, а инфраструктурные программы уже сломались. В такой ситуации сервер становится **неуправляемым**. Система деплоя не может выключить под на таком неуправляемом сервере. Поэтому если попытаться переселить такой под, **его контейнеры продолжат работать на этом сервере** одновременно с новыми контейнерами, которые система деплоя развернула для переселения. Что ещё неприятнее: старый и новый под будут иметь одинаковый hostname и делая сетевые запросы во внешние системы будут представляться одинаково. Не всякая внешняя система способна различить такие поды.

Поэтому появление неуправляемых фантомных подов может быть проблемой. Особенно эта проблема актуальна в stateful-сервисах, где появление фантомных членов кворума может привести к повреждению данных при репликации.

Чтобы избежать этой проблемы, политика `Move pod` позволяет **попытаться выключить под** перед эвакуацией и проверить, удалось ли это. Для этого:
* текущая активная конфигурация выключается: переводится в `PREPARED`.
* если она успешно перешла в `PREPARED` (выключилась), то под эвакуируется.
* после успешного заселения на новую ноду, под заново включается.

Это поведение задается в `Advanced settings -> Shutdown pod policy`:

![image](https://jing.yandex-team.ru/files/i-dyachkov/2021-10-04T12:03:42Z.c887c24.png)

Рассмотрим, какие варианты поведения возможны в случае, если под выключить не удалось.

#### Обработка подов на неуправляемых серверах {#uncontrollable-pod-policy}

Если в течение часа не удалось потушить под, то может быть применено одно из 3 действий:
* `EVICT` — под будет всё равно эвакуирован, пусть даже при этом останутся старые неуправляемые контейнеры.
* `HANDSUP` — переселение будет остановлено, система будет ждать действий от пользователя. Пользователь может руками подтвердить эвакуацию на странице со списком подов. Этот вариант может привести сервис в состояние, в котором ребут хостов зависит от прихода определенных пользователей, поэтому включается он вручную командой няни (можно проконсультироваться в очереди [RTCSUPPORT](https://st.yandex-team.ru/RTCSUPPORT/)).

    ![image](https://jing.yandex-team.ru/files/i-dyachkov/2021-10-04T12:31:36Z.4af3cd2.png)


* `REPLACE` — под заменяется на новый (с новым ID), с перевыкаткой нового снапшота (фактически происходит фоллбек на политику `Create new pod and delete old pod`).

Выбор варианта поведения (`EVICT`, `HANDSUP` или `REPLACE`) задается в `Advanced settings -> Uncontrollable pod policy`.

![image](https://jing.yandex-team.ru/files/i-dyachkov/2021-10-04T12:11:32Z.9917602.png)

#### Замечания {#shutdown-notes}

* Если на момент начала процесса эвакуации под не был запущен (не было `ACTIVE` снэпшота) то после переселения под будет оставлен в выключенном состоянии.
* Выключение подов происходит в рамках бюджета (в том числе и шардированного).
