package hq

import (
	"a.yandex-team.ru/infra/nanny2/pkg/rpc"
	hqpb "a.yandex-team.ru/yp/go/proto/hq"
	"strings"
)

type Config struct {
	Clusters map[string]*rpc.ClientConfig `yaml:"clusters"`
}

type Client struct {
	URL string
	hqpb.InstanceServiceClient
}

type ClientFactory struct {
	clients map[string]*Client
}

func NewClientFactoryFromConfig(cfg *Config) *ClientFactory {
	rv := &ClientFactory{
		clients: make(map[string]*Client, len(cfg.Clusters)),
	}
	for cluster, c := range cfg.Clusters {
		rv.clients[strings.ToLower(cluster)] = &Client{
			URL:                   c.RPCURL,
			InstanceServiceClient: hqpb.NewInstanceServiceClient(rpc.NewClient(c)),
		}
	}
	return rv
}

func (f *ClientFactory) Get(cluster string) (*Client, bool) {
	c, found := f.clients[strings.ToLower(cluster)]
	return c, found
}
