package nanny

import (
	internalpb "a.yandex-team.ru/infra/nanny/go/proto/nanny_internal"
	repopb "a.yandex-team.ru/infra/nanny/go/proto/nanny_repo"
	"a.yandex-team.ru/infra/nanny2/pkg/rpc"
)

type NannyRPCClient struct {
	RepoURL     string
	InternalURL string
	repopb.RepoServiceClient
	internalpb.InternalServiceClient
}

func NewNannyRPCClient(repoConfig rpc.ClientConfig, internalConfig rpc.ClientConfig) *NannyRPCClient {
	c := &NannyRPCClient{}
	c.RepoURL = repoConfig.RPCURL
	c.RepoServiceClient = repopb.NewRepoServiceClient(rpc.NewClient(&repoConfig))
	c.InternalURL = internalConfig.RPCURL
	c.InternalServiceClient = internalpb.NewInternalServiceClient(rpc.NewClient(&internalConfig))
	return c
}
