import argparse

import infra.nanny.hq_get_instances.lib as hq


def parse_args():
    parser = argparse.ArgumentParser(description='Получаем список инстансов Nanny-сервиса. За подробностями: ' +
                                                 'https://wiki.yandex-team.ru/JandeksPoisk/Sepe/nanny/hq/api/ и ' +
                                                 'https://wiki.yandex-team.ru/JandeksPoisk/Sepe/nanny/',
                                     formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('-s', '--nanny-service', help='Имя Nanny-сервиса', required=True, nargs='+')
    parser.add_argument('-a', '--filter-by-active-revisions', action='store_true',
                        help='Оставить только инстансы (в любом состоянии) из активных ревизий')
    parser.add_argument('-w', '--filter-by-active-instances', action='store_true',
                        help='Оставить только активные инстансы')
    parser.add_argument('-t', '--filter-by-tag', help='Оставить только инстансы с данным тегом')
    parser.add_argument('-r', '--filter-by-revision', help='Оставить только инстансы с заданной ревизией')
    parser.add_argument('-d', '--delimeter', help='Разделитель для хостов результирующего списка', default=' ')
    parser.add_argument('-c', '--print-container-names', action='store_true', help='Печатать имена контейнеров')
    return parser.parse_args()


def main():
    ops = parse_args()
    instances = []
    for nanny_service in ops.nanny_service:
        instances += hq.get_instances(nanny_service)
    if ops.filter_by_active_revisions:
        instances = hq.filter_instances_just_active_revisions(instances)
    if ops.filter_by_active_instances:
        instances = hq.filter_instances_just_active(instances)
    if ops.filter_by_tag:
        instances = hq.filter_instances_by_tag(instances, ops.filter_by_tag)
    if ops.filter_by_revision:
        instances = hq.filter_instances_by_revision(instances, ops.filter_by_revision)
    if ops.print_container_names:
        print ops.delimeter.join([instance.spec.hostname for instance in instances])
    else:
        print ops.delimeter.join(hq.extract_node_names_sorted(instances))


if __name__ == '__main__':
    main()
