#include <Python.h>

static PyObject *CoreWriterError;

PyObject *remove_oldest_dump(PyObject* self, PyObject* args) {
    char* dir;
    uint64_t ttl;

    Y_UNUSED(self);

    if (!PyArg_ParseTuple(args, "sK", &dir, &ttl)) {
        return NULL;
    }

    return Py_BuildValue("K", 0);
}

PyObject *count_regular_files(PyObject* self, PyObject* args) {
    char *dir_path;

    Y_UNUSED(self);

    if (!PyArg_ParseTuple(args, "s", &dir_path))
        return PyErr_Format(CoreWriterError, "Bad arguments supplied");

    return Py_BuildValue("KK", 0, 0);
}

PyObject *save_core(PyObject* self, PyObject* args) {
    int fd = -1;
    char* output_path;
    uint64_t ttl;

    Y_UNUSED(self);

    if (!PyArg_ParseTuple(args, "isK", &fd, &output_path, &ttl))
        return PyErr_Format(CoreWriterError, "Bad arguments supplied");

    if (fd < 0)
        return PyErr_Format(CoreWriterError, "Invalid input fd supplied");

    if (!output_path)
        return PyErr_Format(CoreWriterError, "Empty output path supplied");

    return Py_BuildValue("k", 0);
}

static PyMethodDef CoreWriterFunctions[] = {
    {"save_core", (PyCFunction)save_core, METH_VARARGS,
     "save core dump file consuming minimum resources"},
    {"remove_oldest_dump", (PyCFunction)remove_oldest_dump, METH_VARARGS,
     "remove dump files older than ttl secs"},
    {"count_regular_files", (PyCFunction)count_regular_files, METH_VARARGS,
     "count regular files reside in path"},
     {NULL, NULL, 0, NULL}};

PyMODINIT_FUNC initcorewriter() {
    PyObject *m = Py_InitModule("corewriter", CoreWriterFunctions);

    CoreWriterError = PyErr_NewException((char *)"corewriter.error", NULL, NULL);
    Py_INCREF(CoreWriterError);
    PyModule_AddObject(m, "error", CoreWriterError);
}
