from . import interfaces


class InstallAction(interfaces.IInstanceCtlAction):

    def __init__(self, job_ctrl, hq_status_reporter):
        """
        :type job_ctrl: instancectl.jobs.controller.JobController
        :type hq_status_reporter: instancectl.hq.reporter.HqInstanceStatusReporter
        """
        self.job_ctrl = job_ctrl
        self.hq_status_reporter = hq_status_reporter

    def run(self):
        self.hq_status_reporter.start()
        self.job_ctrl.prepare_instance()

    def stop(self):
        self.hq_status_reporter.stop()
        self.hq_status_reporter.report()

