from __future__ import unicode_literals

import base64

from infra.nanny.instancectl.proto import secret_pb2


def encode_legacy_secret_dict_values(s):
    """
    :type s: dict
    :rtype dict:
    """
    return {k: v.encode('utf8') for k, v in s.iteritems()}


def encode_secret_entry_values(s):
    """
    :type s: infra.nanny.instancectl.proto.secret_pb2.Secret
    :rtype dict
    """
    d = {}
    for e in s.content.entries:
        if e.meta.format == secret_pb2.SecretEntryMeta.BASE64:
            d[e.content.key] = base64.b64decode(e.content.value)
    return d
