from __future__ import unicode_literals
import atexit
import logging

from instancectl import constants
from instancectl.clients.unixsocket_rpc import client
from infra.nanny.instancectl.proto import instancectl_pb2
from infra.nanny.instancectl.proto import instancectl_stub
from instancectl.cmd import log as setup_logging

log = logging.getLogger('actions.reopenlog')


def call_reopenlog(args, console_handler):
    setup_logging.setup_logging(console_handler, args.console)

    log.info("Calling reopenlog")

    @atexit.register
    def log_exit():
        log.info("Exited")

    url = '{}{}/rpc/control'.format(client.UNIX_SOCKET_SCHEME, constants.UNIXSOCKET_PATH)
    rpc = client.UnixsocketRpcClient(rpc_url=url)
    stub = instancectl_stub.InstanceRevisionServiceStub(rpc)
    req = instancectl_pb2.ReopenInstanceLogsRequest()
    stub.reopen_instance_logs(req)


def add_parsers(subparsers):
    parser = subparsers.add_parser(name='reopenlog', description='Request instance to reopen logs')
    parser.set_defaults(handle=call_reopenlog)
