from __future__ import unicode_literals

import atexit
import logging

from instancectl.lib import actionsutil
from instancectl.cmd import log as setup_logging


log = logging.getLogger('actions.install')


def install_action(args, console_handler):
    """
    Installs/prepares instance.

    * Parses loop.conf and renders it with env vars like BSCONFIG_* and other,
    * Saves rendering result to state/instance.conf
    * Runs prepare_scripts.

    Assuming that we are in the instance directory.
    """
    setup_logging.setup_logging(console_handler, args.console)
    log.info("Installing instance")

    @atexit.register
    def log_exit():
        log.info("Exited")

    action = actionsutil.make_install_action(args.config, args.hq_url)
    try:
        action.run()
    finally:
        action.stop()


def add_parsers(subparsers):
    parser = subparsers.add_parser(
        name='install',
        description='Install instance (compile instancectl config; run prepare_scripts/init containers)'
    )
    parser.set_defaults(handle=install_action)
    parser.add_argument(
        "-c", "--config", metavar="CONFIGFILE", dest="config",
        help="config file", type=str, default='loop.conf',
    )
    parser.add_argument(
        "--hq-url", metavar="HQ_URL", dest="hq_url",
        help="HQ URL", type=str, default=None,
    )
