from __future__ import unicode_literals

import sys
import argparse
import atexit
import logging

from instancectl import constants
from instancectl.clients.unixsocket_rpc import client
from infra.nanny.instancectl.proto import instancectl_pb2
from infra.nanny.instancectl.proto import instancectl_stub
from instancectl.jobs import job
from instancectl.cmd import log as setup_logging

log = logging.getLogger('actions.notify')


def notify_dynamic_resources_updated(args, console_handler):
    setup_logging.setup_logging(console_handler, args.console)
    log.info("Notifying main process about new dynamic resources (iss_hook_notify)")

    @atexit.register
    def log_exit():
        log.info("Exited")

    url = '{}{}/rpc/control'.format(client.UNIX_SOCKET_SCHEME, constants.UNIXSOCKET_PATH)
    rpc = client.UnixsocketRpcClient(rpc_url=url)
    stub = instancectl_stub.InstanceRevisionServiceStub(rpc)
    req = instancectl_pb2.NotifyInstanceDynamicResourcesUpdatedRequest()
    req.updates.extend(args.updates)
    resp = stub.notify_instance_dynamic_resources_updated(req)
    if resp.success.status == 'True':
        sys.exit(0)
    log.warning('Notify action failed: %s', resp.success.message)
    sys.exit(job.JobStatusCheckResult.PENDING)


def add_parsers(subparsers):
    parser = subparsers.add_parser(name='notify', description='Notify instance about dynamic resources update')
    parser.set_defaults(handle=notify_dynamic_resources_updated)
    parser.add_argument("--updates", metavar="UPDATES", nargs=argparse.REMAINDER,
                        help="iss_hook_notify arguments", type=str)

